/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Wolf;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class FlankAndSurroundGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private int coordinationTimer;
    private Location assignedPosition;
    private static final int COORDINATION_INTERVAL = 40;
    private static final double SURROUND_RADIUS = 8.0;
    private static final double ATTACK_RANGE = 2.5;

    public FlankAndSurroundGoal(Mob mob, Plugin plugin, HerdManager herdManager) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "flank_surround"));
        this.coordinationTimer = 0;
    }

    public boolean shouldActivate() {
        if (!(this.mob instanceof Wolf)) {
            return false;
        }
        if (this.mob.getTarget() == null || !this.mob.getTarget().isValid()) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd pack = herdOpt.get();
        return pack.size() >= 3;
    }

    public boolean shouldStayActive() {
        return this.mob.getTarget() != null && this.mob.getTarget().isValid();
    }

    public void start() {
        this.coordinationTimer = 0;
        this.assignedPosition = null;
    }

    public void stop() {
        this.assignedPosition = null;
        this.mob.removeMetadata("pack_role", this.plugin);
    }

    public void tick() {
        ++this.coordinationTimer;
        if (this.coordinationTimer >= 40) {
            this.coordinationTimer = 0;
            this.coordinateFlankingPositions();
        }
        if (this.assignedPosition != null && this.assignedPosition.getWorld() != null) {
            this.executeFlanking();
        }
    }

    private void coordinateFlankingPositions() {
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isValid()) {
            return;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return;
        }
        Herd pack = herdOpt.get();
        ArrayList<Wolf> activePackMembers = new ArrayList<Wolf>();
        for (UUID memberId : pack.members()) {
            Wolf packMember = (Wolf)Bukkit.getEntity((UUID)memberId);
            if (packMember == null || !packMember.isValid() || packMember.isDead() || !(packMember.getLocation().distance(target.getLocation()) < 16.0)) continue;
            activePackMembers.add(packMember);
            if (packMember.getTarget() != null) continue;
            packMember.setTarget(target);
        }
        if (activePackMembers.size() < 2) {
            return;
        }
        this.assignSurroundPositions(target, activePackMembers);
    }

    private void assignSurroundPositions(LivingEntity target, List<Wolf> packMembers) {
        Location targetLoc = target.getLocation();
        int memberCount = packMembers.size();
        double angleIncrement = 360.0 / (double)memberCount;
        for (int i = 0; i < packMembers.size(); ++i) {
            Wolf packMember = packMembers.get(i);
            double angle = Math.toRadians(angleIncrement * (double)i);
            Vector offset = new Vector(Math.cos(angle) * 8.0, 0.0, Math.sin(angle) * 8.0);
            Location surroundPosition = targetLoc.clone().add(offset);
            surroundPosition.setY(targetLoc.getY());
            if (!packMember.getUniqueId().equals(this.mob.getUniqueId())) continue;
            this.assignedPosition = surroundPosition;
            if (this.isTargetBehind(target, (LivingEntity)this.mob, 90.0)) {
                this.mob.setMetadata("pack_role", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)"ATTACKER"));
                continue;
            }
            this.mob.setMetadata("pack_role", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)"DISTRACTOR"));
        }
    }

    private void executeFlanking() {
        String role;
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        double distanceToPosition = this.mob.getLocation().distance(this.assignedPosition);
        double distanceToTarget = this.mob.getLocation().distance(target.getLocation());
        String string = role = this.mob.hasMetadata("pack_role") ? ((MetadataValue)this.mob.getMetadata("pack_role").get(0)).asString() : "ATTACKER";
        if (distanceToPosition > 2.0) {
            this.mob.getPathfinder().moveTo(this.assignedPosition, 1.0);
        } else if (distanceToTarget <= 2.5 && role.equals("ATTACKER")) {
            this.mob.getPathfinder().stopPathfinding();
            this.mob.attack((Entity)target);
            Location mobLoc = this.mob.getLocation();
            if (mobLoc.getWorld() != null) {
                mobLoc.getWorld().spawnParticle(Particle.CRIT, mobLoc.clone().add(0.0, 1.0, 0.0), 3);
            }
        } else if (role.equals("DISTRACTOR")) {
            Location targetLoc = target.getLocation();
            Vector direction = targetLoc.toVector().subtract(this.mob.getLocation().toVector()).normalize();
            Location distractPosition = targetLoc.clone().subtract(direction.multiply(3));
            this.mob.getPathfinder().moveTo(distractPosition, 0.8);
            if (Math.random() < 0.1) {
                this.mob.lookAt((Entity)target);
            }
        }
    }

    private boolean isTargetBehind(LivingEntity observer, LivingEntity target, double arcAngle) {
        Vector toTarget;
        Vector observerDirection = observer.getLocation().getDirection().normalize();
        double angle = Math.toDegrees(Math.acos(observerDirection.dot(toTarget = target.getLocation().toVector().subtract(observer.getLocation().toVector()).normalize())));
        return angle > 180.0 - arcAngle / 2.0;
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK, GoalType.TARGET);
    }
}

