/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FlightBurstGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private int flightCooldown;
    private static final int COOLDOWN_TICKS = 60;
    private static final double PANIC_THRESHOLD = 0.7;
    private static final double FLIGHT_POWER = 0.8;

    public FlightBurstGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "flight_burst"));
        this.flightCooldown = 0;
    }

    public boolean shouldActivate() {
        if (this.flightCooldown > 0) {
            --this.flightCooldown;
            return false;
        }
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent >= 0.7) {
            return false;
        }
        if (!this.mob.isOnGround()) {
            return false;
        }
        return this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean();
    }

    public boolean shouldStayActive() {
        return false;
    }

    public void start() {
        this.performFlightBurst();
        this.flightCooldown = 60;
    }

    public void stop() {
    }

    public void tick() {
    }

    private void performFlightBurst() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return;
        }
        Vector velocity = this.mob.getVelocity();
        velocity.setY(0.8);
        double angle = Math.random() * 2.0 * Math.PI;
        velocity.setX(Math.cos(angle) * 0.3);
        velocity.setZ(Math.sin(angle) * 0.3);
        this.mob.setVelocity(velocity);
        mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_CHICKEN_HURT, 1.0f, 1.5f);
        mobLoc.getWorld().spawnParticle(Particle.POOF, mobLoc, 10, 0.3, 0.3, 0.3, 0.05);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.JUMP);
    }
}

