/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;
import org.shotrush.atom.content.mobs.herd.HerdRole;

public class HerdLeaderWanderGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final HerdManager herdManager;
    private Location wanderTarget;
    private int cooldown;
    private static final int WANDER_COOLDOWN = 200;
    private static final int MIN_WANDER_DISTANCE = 5;
    private static final int MAX_WANDER_DISTANCE = 15;

    public HerdLeaderWanderGoal(Mob mob, Plugin plugin, HerdManager herdManager) {
        this.mob = mob;
        this.herdManager = herdManager;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "herd_leader_wander"));
        this.cooldown = 0;
        this.wanderTarget = null;
    }

    public boolean shouldActivate() {
        if (this.herdManager.getRole(this.mob.getUniqueId()) != HerdRole.LEADER) {
            return false;
        }
        if (this.mob.getTarget() != null) {
            return false;
        }
        if (this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean()) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isPresent() && herdOpt.get().isPanicking()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        return true;
    }

    public boolean shouldStayActive() {
        if (this.wanderTarget == null) {
            return false;
        }
        if (this.mob.getTarget() != null) {
            return false;
        }
        if (this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean()) {
            return false;
        }
        double distance = this.mob.getLocation().distance(this.wanderTarget);
        return distance > 2.0;
    }

    public void start() {
        this.computeWanderTarget();
        this.cooldown = 200 + (int)(Math.random() * 100.0);
    }

    public void stop() {
        this.wanderTarget = null;
        this.mob.getPathfinder().stopPathfinding();
    }

    public void tick() {
        Location current = this.mob.getLocation();
        if (current == null || current.getWorld() == null) {
            return;
        }
        if (this.wanderTarget == null || this.wanderTarget.getWorld() == null) {
            return;
        }
        this.mob.getPathfinder().moveTo(this.wanderTarget, 0.8);
    }

    private void computeWanderTarget() {
        Location current = this.mob.getLocation();
        Location centroid = null;
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isPresent()) {
            centroid = this.herdManager.getHerdCentroid(herdOpt.get());
        }
        if (centroid != null && Math.random() < 0.4) {
            Vector towardsCentroid = centroid.toVector().subtract(current.toVector()).normalize();
            double distance = 5.0 + Math.random() * 10.0;
            this.wanderTarget = current.clone().add(towardsCentroid.multiply(distance));
        } else {
            double angle = Math.random() * 2.0 * Math.PI;
            double distance = 5.0 + Math.random() * 10.0;
            double x = Math.cos(angle) * distance;
            double z = Math.sin(angle) * distance;
            this.wanderTarget = current.clone().add(x, 0.0, z);
        }
        this.wanderTarget.setY(current.getY());
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE);
    }
}

