/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.content.mobs.AnimalDomestication;
import org.shotrush.atom.content.mobs.ai.combat.MoraleSystem;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class HerdPanicGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private final SpeciesBehavior behavior;
    private final MoraleSystem moraleSystem;
    private Location fleeTarget;
    private int repathTimer;
    private static final int REPATH_INTERVAL = 20;

    public HerdPanicGoal(Mob mob, Plugin plugin, HerdManager herdManager, SpeciesBehavior behavior, MoraleSystem moraleSystem) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.behavior = behavior;
        this.moraleSystem = moraleSystem;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "herd_panic"));
        this.repathTimer = 0;
    }

    public boolean shouldActivate() {
        if (this.moraleSystem != null && this.moraleSystem.isMoraleBroken(this.mob)) {
            return true;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isPresent() && herdOpt.get().isPanicking()) {
            return true;
        }
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent < this.behavior.panicHealthThreshold()) {
            return true;
        }
        return this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean();
    }

    public boolean shouldStayActive() {
        if (!this.mob.isValid() || this.mob.isDead()) {
            return false;
        }
        if (this.moraleSystem != null && this.moraleSystem.isMoraleBroken(this.mob)) {
            return true;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isPresent() && herdOpt.get().isPanicking()) {
            return true;
        }
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent < this.behavior.panicHealthThreshold() * 1.5) {
            return true;
        }
        return this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean();
    }

    public void start() {
        this.mob.setMetadata("fleeing", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        this.computeFleeTarget();
        this.repathTimer = 0;
    }

    public void stop() {
        this.mob.removeMetadata("fleeing", this.plugin);
        this.fleeTarget = null;
        this.mob.getPathfinder().stopPathfinding();
    }

    public void tick() {
        if (this.fleeTarget == null) {
            this.computeFleeTarget();
        }
        ++this.repathTimer;
        if (this.repathTimer >= 20) {
            this.repathTimer = 0;
            this.computeFleeTarget();
        }
        if (this.fleeTarget == null || this.fleeTarget.getWorld() == null) {
            return;
        }
        double domesticationFactor = AnimalDomestication.getDomesticationFactor((Animals)this.mob);
        double speed = this.behavior.getFleeSpeed(domesticationFactor);
        this.drainStamina();
        if (this.fleeTarget != null && this.fleeTarget.getWorld() != null) {
            if (this.mob.getLocation().distance(this.fleeTarget) < 3.0) {
                this.computeFleeTarget();
            }
            this.mob.getPathfinder().moveTo(this.fleeTarget, speed);
        }
    }

    private void computeFleeTarget() {
        if (!this.mob.isValid() || this.mob.isDead()) {
            this.fleeTarget = null;
            return;
        }
        Location current = this.mob.getLocation();
        if (current == null || current.getWorld() == null) {
            this.fleeTarget = null;
            return;
        }
        Location threatLocation = null;
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isPresent()) {
            threatLocation = herdOpt.get().lastThreatLocation();
        }
        if (threatLocation == null && this.mob.getLastDamageCause() != null) {
            Location location = threatLocation = this.mob.getLastDamageCause().getEntity() != null ? this.mob.getLastDamageCause().getEntity().getLocation() : current;
        }
        if (threatLocation == null) {
            threatLocation = current.clone().add(Math.random() * 10.0 - 5.0, 0.0, Math.random() * 10.0 - 5.0);
        }
        Vector awayFromThreat = current.toVector().subtract(threatLocation.toVector()).normalize();
        double distance = 20.0 + Math.random() * 10.0;
        this.fleeTarget = current.clone().add(awayFromThreat.multiply(distance));
        this.fleeTarget.setY(current.getY());
        if (this.fleeTarget.getWorld() == null) {
            this.fleeTarget = null;
        }
    }

    private void drainStamina() {
        if (!this.mob.hasMetadata("stamina")) {
            double maxStamina = 100.0 + Math.random() * 100.0;
            this.mob.setMetadata("maxStamina", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)maxStamina));
            this.mob.setMetadata("stamina", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)maxStamina));
            return;
        }
        double stamina = ((MetadataValue)this.mob.getMetadata("stamina").get(0)).asDouble();
        double drain = 0.3;
        stamina = Math.max(0.0, stamina - drain);
        this.mob.setMetadata("stamina", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)stamina));
        if (stamina <= 0.0) {
            this.stop();
        }
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

