/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;

public class HuntPreyGoal
implements Goal<Mob>,
Listener {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final SpeciesBehavior behavior;
    private LivingEntity preyTarget;
    private static final Set<EntityType> PREY_TYPES = Set.of(EntityType.RABBIT, EntityType.CHICKEN, EntityType.SHEEP);
    private static final Set<UUID> HUNTING_MOBS = ConcurrentHashMap.newKeySet();

    public HuntPreyGoal(Mob mob, Plugin plugin, SpeciesBehavior behavior) {
        this.mob = mob;
        this.plugin = plugin;
        this.behavior = behavior;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "hunt_prey"));
    }

    public boolean shouldActivate() {
        Mob mob = this.mob;
        if (!(mob instanceof Animals)) {
            return false;
        }
        Animals animal = (Animals)mob;
        if (!this.mob.isValid() || this.mob.isDead()) {
            return false;
        }
        if (this.mob.getType() != EntityType.WOLF && this.mob.getType() != EntityType.FOX) {
            return false;
        }
        if (this.mob.getTarget() instanceof Player) {
            return false;
        }
        this.preyTarget = this.findNearestPrey();
        return this.preyTarget != null;
    }

    public boolean shouldStayActive() {
        if (!(this.mob instanceof Animals)) {
            return false;
        }
        if (!this.mob.isValid() || this.mob.isDead()) {
            return false;
        }
        if (this.preyTarget == null || !this.preyTarget.isValid() || this.preyTarget.isDead()) {
            return false;
        }
        if (this.mob.getTarget() instanceof Player) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        Location preyLoc = this.preyTarget.getLocation();
        if (mobLoc == null || preyLoc == null) {
            return false;
        }
        return mobLoc.distanceSquared(preyLoc) < this.behavior.aggroRadius() * this.behavior.aggroRadius() * 4.0;
    }

    public void start() {
        LivingEntity livingEntity;
        if (this.preyTarget != null && (livingEntity = this.preyTarget) instanceof Mob) {
            Mob preyMob = (Mob)livingEntity;
            this.mob.setTarget(this.preyTarget);
            this.mob.setMetadata("hunting", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)this.preyTarget.getUniqueId()));
            HUNTING_MOBS.add(this.mob.getUniqueId());
        }
    }

    public void stop() {
        this.mob.setTarget(null);
        this.mob.removeMetadata("hunting", this.plugin);
        HUNTING_MOBS.remove(this.mob.getUniqueId());
        this.preyTarget = null;
    }

    public void tick() {
        Mob mob = this.mob;
        if (!(mob instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)mob;
        if (this.preyTarget == null || !this.preyTarget.isValid() || this.preyTarget.isDead()) {
            this.stop();
            return;
        }
        this.mob.setTarget(this.preyTarget);
        Location preyLoc = this.preyTarget.getLocation();
        if (preyLoc != null && preyLoc.getWorld() != null) {
            double chaseSpeed = this.behavior.getChaseSpeed(0.0);
            this.mob.getPathfinder().moveTo(preyLoc, chaseSpeed);
        }
    }

    private LivingEntity findNearestPrey() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return null;
        }
        return mobLoc.getWorld().getNearbyEntities(mobLoc, this.behavior.aggroRadius(), this.behavior.aggroRadius(), this.behavior.aggroRadius()).stream().filter(entity -> entity instanceof LivingEntity).filter(entity -> PREY_TYPES.contains(entity.getType())).filter(entity -> entity.isValid() && !((LivingEntity)entity).isDead()).map(entity -> (LivingEntity)entity).min((a, b) -> Double.compare(mobLoc.distanceSquared(a.getLocation()), mobLoc.distanceSquared(b.getLocation()))).orElse(null);
    }

    @EventHandler
    public void onPreyDeath(EntityDeathEvent event) {
        UUID killerId;
        UUID uUID = killerId = event.getEntity().getKiller() != null ? event.getEntity().getKiller().getUniqueId() : null;
        if (killerId == null) {
            return;
        }
        if (!HUNTING_MOBS.contains(killerId)) {
            return;
        }
        Entity killerEntity = this.plugin.getServer().getEntity(killerId);
        if (!(killerEntity instanceof Animals)) {
            return;
        }
        Animals animal = (Animals)killerEntity;
        HUNTING_MOBS.remove(killerId);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK, GoalType.TARGET);
    }
}

