/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Wolf;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class PackHuntingGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private int coordinationTimer;
    private static final int COORDINATION_INTERVAL = 60;
    private static final double PACK_BONUS_DAMAGE = 2.0;
    private static final double SURROUND_RANGE = 15.0;

    public PackHuntingGoal(Mob mob, Plugin plugin, HerdManager herdManager) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "pack_hunting"));
        this.coordinationTimer = 0;
    }

    public boolean shouldActivate() {
        if (!(this.mob instanceof Wolf)) {
            return false;
        }
        if (this.mob.getTarget() == null) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd pack = herdOpt.get();
        return pack.size() >= 2;
    }

    public boolean shouldStayActive() {
        return this.mob.getTarget() != null && this.mob.getTarget().isValid();
    }

    public void start() {
        this.coordinationTimer = 0;
    }

    public void stop() {
    }

    public void tick() {
        ++this.coordinationTimer;
        if (this.coordinationTimer >= 60) {
            this.coordinationTimer = 0;
            this.coordinatePackAttack();
        }
    }

    private void coordinatePackAttack() {
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isValid()) {
            return;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return;
        }
        Herd pack = herdOpt.get();
        ArrayList<Wolf> nearbyPackMembers = new ArrayList<Wolf>();
        for (UUID memberId : pack.members()) {
            Location memberLoc;
            Wolf packMember = (Wolf)Bukkit.getEntity((UUID)memberId);
            if (packMember == null || !packMember.isValid() || packMember.getUniqueId().equals(this.mob.getUniqueId()) || (memberLoc = packMember.getLocation()) == null || !(memberLoc.distance(target.getLocation()) < 15.0)) continue;
            nearbyPackMembers.add(packMember);
        }
        if (nearbyPackMembers.isEmpty()) {
            return;
        }
        for (Wolf packMember : nearbyPackMembers) {
            if (packMember.getTarget() != null) continue;
            packMember.setTarget(target);
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_WOLF_AMBIENT, 0.5f, 0.8f);
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, 1.0, 0.0), 2);
        }
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.TARGET);
    }
}

