/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PounceAttackGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private LivingEntity target;
    private int pounceCooldown;
    private boolean isPouncing;
    private static final int COOLDOWN_TICKS = 80;
    private static final double POUNCE_RANGE_MIN = 3.0;
    private static final double POUNCE_RANGE_MAX = 8.0;
    private static final double DAMAGE = 4.0;
    private static final double POUNCE_POWER = 1.2;

    public PounceAttackGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "pounce_attack"));
        this.pounceCooldown = 0;
        this.isPouncing = false;
    }

    public boolean shouldActivate() {
        if (this.pounceCooldown > 0) {
            --this.pounceCooldown;
            return false;
        }
        LivingEntity currentTarget = this.mob.getTarget();
        if (currentTarget == null || !currentTarget.isValid()) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return false;
        }
        Location targetLoc = currentTarget.getLocation();
        if (targetLoc == null) {
            return false;
        }
        double distance = mobLoc.distance(targetLoc);
        if (distance >= 3.0 && distance <= 8.0) {
            this.target = currentTarget;
            return true;
        }
        return false;
    }

    public boolean shouldStayActive() {
        return this.isPouncing;
    }

    public void start() {
        this.isPouncing = true;
        this.performPounce();
    }

    public void stop() {
        this.isPouncing = false;
        this.target = null;
        this.pounceCooldown = 80;
    }

    public void tick() {
        if (this.target == null || !this.target.isValid()) {
            this.stop();
            return;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null) {
            this.stop();
            return;
        }
        Location targetLoc = this.target.getLocation();
        if (targetLoc == null) {
            this.stop();
            return;
        }
        double distance = mobLoc.distance(targetLoc);
        if (distance < 1.5 || this.mob.isOnGround()) {
            if (distance < 2.0) {
                this.target.damage(4.0, (Entity)this.mob);
            }
            this.stop();
        }
    }

    private void performPounce() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            this.stop();
            return;
        }
        if (this.target == null) {
            this.stop();
            return;
        }
        Location targetLoc = this.target.getLocation();
        if (targetLoc == null) {
            this.stop();
            return;
        }
        Vector direction = targetLoc.toVector().subtract(mobLoc.toVector()).normalize();
        direction.setY(0.4);
        this.mob.setVelocity(direction.multiply(1.2));
        mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_FOX_AGGRO, 1.0f, 1.0f);
        mobLoc.getWorld().spawnParticle(Particle.CLOUD, mobLoc, 10, 0.2, 0.2, 0.2, 0.05);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.JUMP);
    }
}

