/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;

public class RamChargeGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private LivingEntity target;
    private Location chargeStart;
    private boolean isCharging;
    private boolean isWindingUp;
    private boolean isStunned;
    private int chargeCooldown;
    private int stunDuration;
    private static final int COOLDOWN_TICKS = 100;
    private static final double CHARGE_DISTANCE = 5.0;
    private static final double CHARGE_SPEED = 2.0;
    private static final double DAMAGE = 6.0;
    private static final double KNOCKBACK = 1.2;
    private static final double RECOIL_DAMAGE = 4.0;
    private static final int STUN_TICKS = 40;

    public RamChargeGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "ram_charge"));
        this.isCharging = false;
        this.chargeCooldown = 0;
    }

    public boolean shouldActivate() {
        if (this.isStunned) {
            --this.stunDuration;
            if (this.stunDuration <= 0) {
                this.isStunned = false;
            }
            return false;
        }
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
            return false;
        }
        LivingEntity currentTarget = this.mob.getTarget();
        if (currentTarget == null || !currentTarget.isValid()) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return false;
        }
        Location targetLoc = currentTarget.getLocation();
        if (targetLoc == null) {
            return false;
        }
        double distance = mobLoc.distance(targetLoc);
        if (distance >= 5.0 && distance <= 15.0) {
            this.target = currentTarget;
            this.chargeStart = mobLoc.clone();
            return true;
        }
        return false;
    }

    public boolean shouldStayActive() {
        if (this.isWindingUp) {
            return true;
        }
        if (!this.isCharging) {
            return false;
        }
        if (this.target == null || !this.target.isValid()) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null) {
            return false;
        }
        if (this.chargeStart == null) {
            return false;
        }
        double distanceTraveled = mobLoc.distance(this.chargeStart);
        return distanceTraveled < 10.0;
    }

    public void start() {
        this.isWindingUp = true;
        this.mob.getPathfinder().stopPathfinding();
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_RAVAGER_ROAR, 0.5f, 1.5f);
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, this.mob.getHeight() + 0.5, 0.0), 3, 0.3, 0.3, 0.3, 0.0);
        }
        SchedulerAPI.runTaskLater((Entity)this.mob, () -> {
            this.isWindingUp = false;
            this.isCharging = true;
            Location loc = this.mob.getLocation();
            if (loc != null && loc.getWorld() != null) {
                loc.getWorld().playSound(loc, Sound.ENTITY_RAVAGER_STEP, 1.0f, 0.8f);
            }
        }, 20L);
    }

    public void stop() {
        this.isCharging = false;
        this.isWindingUp = false;
        this.target = null;
        this.chargeStart = null;
        if (!this.isStunned) {
            this.chargeCooldown = 100;
        }
        this.mob.getPathfinder().stopPathfinding();
    }

    public void tick() {
        if (this.isWindingUp) {
            this.mob.getPathfinder().stopPathfinding();
            return;
        }
        if (this.isStunned) {
            this.mob.getPathfinder().stopPathfinding();
            Location mobLoc = this.mob.getLocation();
            if (mobLoc != null && mobLoc.getWorld() != null && this.stunDuration % 5 == 0) {
                mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, this.mob.getHeight() + 0.8, 0.0), 3, 0.2, 0.2, 0.2, 0.0);
            }
            return;
        }
        if (this.target == null || !this.target.isValid()) {
            this.stop();
            return;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            this.stop();
            return;
        }
        Location targetLoc = this.target.getLocation();
        if (targetLoc == null) {
            this.stop();
            return;
        }
        double distance = mobLoc.distance(targetLoc);
        if (distance < 2.0) {
            this.performRamHit();
            this.stop();
            return;
        }
        this.checkWallCollision(mobLoc);
        this.mob.getPathfinder().moveTo(targetLoc, 2.0);
        if (Math.random() < 0.2) {
            mobLoc.getWorld().spawnParticle(Particle.CLOUD, mobLoc, 5, 0.3, 0.2, 0.3, 0.03);
        }
    }

    private void performRamHit() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return;
        }
        this.target.damage(6.0, (Entity)this.mob);
        Vector knockbackDirection = this.target.getLocation().toVector().subtract(mobLoc.toVector()).normalize();
        knockbackDirection.setY(0.15);
        this.target.setVelocity(knockbackDirection.multiply(1.2));
        mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_IRON_GOLEM_ATTACK, 1.0f, 0.8f);
        mobLoc.getWorld().spawnParticle(Particle.EXPLOSION, this.target.getLocation(), 3, 0.3, 0.3, 0.3, 0.0);
        mobLoc.getWorld().spawnParticle(Particle.CLOUD, this.target.getLocation(), 30, 0.6, 0.5, 0.6, 0.15);
    }

    private void checkWallCollision(Location mobLoc) {
        Vector facing = mobLoc.getDirection().normalize();
        Location checkLoc = mobLoc.clone().add(facing.multiply(1.5));
        Block block = checkLoc.getBlock();
        if (block.getType().isSolid() && !block.getType().equals((Object)Material.AIR)) {
            this.isStunned = true;
            this.stunDuration = 40;
            this.isCharging = false;
            this.mob.damage(4.0);
            this.mob.getPathfinder().stopPathfinding();
            mobLoc.getWorld().playSound(mobLoc, Sound.BLOCK_STONE_HIT, 1.0f, 0.5f);
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_RAVAGER_HURT, 1.0f, 1.0f);
            mobLoc.getWorld().spawnParticle(Particle.BLOCK, checkLoc, 30, 0.3, 0.3, 0.3, (Object)block.getBlockData());
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, this.mob.getHeight() + 0.8, 0.0), 5, 0.3, 0.3, 0.3, 0.0);
            this.chargeCooldown = 140;
        }
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

