/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.AnimalDomestication;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class ReunionGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private final SpeciesBehavior behavior;
    private int callOutTimer;
    private static final int CALL_INTERVAL = 60;
    private static final double SEPARATION_MULTIPLIER = 3.0;
    private static final double REUNION_SPEED = 1.4;

    public ReunionGoal(Mob mob, Plugin plugin, HerdManager herdManager, SpeciesBehavior behavior) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.behavior = behavior;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "reunion"));
        this.callOutTimer = 0;
    }

    public boolean shouldActivate() {
        Mob mob = this.mob;
        if (!(mob instanceof Animals)) {
            return false;
        }
        Animals animal = (Animals)mob;
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        Location herdCentroid = this.herdManager.getHerdCentroid(herd);
        if (herdCentroid == null) {
            return false;
        }
        double domesticationFactor = AnimalDomestication.getDomesticationFactor(animal);
        double cohesionRadius = this.behavior.getCohesionRadius(domesticationFactor);
        double separationThreshold = cohesionRadius * 3.0;
        double distance = this.mob.getLocation().distance(herdCentroid);
        return distance > separationThreshold;
    }

    public boolean shouldStayActive() {
        if (!this.mob.isValid() || this.mob.isDead()) {
            return false;
        }
        if (this.mob.getTarget() != null) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        Location herdCentroid = this.herdManager.getHerdCentroid(herd);
        if (herdCentroid == null) {
            return false;
        }
        Mob mob = this.mob;
        if (!(mob instanceof Animals)) {
            return false;
        }
        Animals animal = (Animals)mob;
        double domesticationFactor = AnimalDomestication.getDomesticationFactor(animal);
        double cohesionRadius = this.behavior.getCohesionRadius(domesticationFactor);
        double reunionThreshold = cohesionRadius * 1.5;
        double distance = this.mob.getLocation().distance(herdCentroid);
        return distance > reunionThreshold;
    }

    public void start() {
        this.callOutTimer = 0;
    }

    public void stop() {
        this.mob.getPathfinder().stopPathfinding();
    }

    public void tick() {
        Location loc;
        ++this.callOutTimer;
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return;
        }
        Herd herd = herdOpt.get();
        Location herdCentroid = this.herdManager.getHerdCentroid(herd);
        if (herdCentroid == null) {
            return;
        }
        this.mob.getPathfinder().moveTo(herdCentroid, 1.4);
        if (this.callOutTimer >= 60) {
            this.callOutTimer = 0;
            this.performCallOut();
        }
        if (this.mob.getTicksLived() % 10 == 0 && (loc = this.mob.getLocation()) != null && loc.getWorld() != null) {
            loc.getWorld().spawnParticle(Particle.NOTE, loc.clone().add(0.0, this.mob.getHeight() + 0.5, 0.0), 1);
        }
    }

    private void performCallOut() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return;
        }
        Sound callSound = switch (this.mob.getType()) {
            case EntityType.COW -> Sound.ENTITY_COW_AMBIENT;
            case EntityType.SHEEP -> Sound.ENTITY_SHEEP_AMBIENT;
            case EntityType.PIG -> Sound.ENTITY_PIG_AMBIENT;
            case EntityType.HORSE -> Sound.ENTITY_HORSE_AMBIENT;
            case EntityType.WOLF -> Sound.ENTITY_WOLF_AMBIENT;
            default -> Sound.ENTITY_VILLAGER_AMBIENT;
        };
        mobLoc.getWorld().playSound(mobLoc, callSound, 1.5f, 0.9f);
        mobLoc.getWorld().spawnParticle(Particle.NOTE, mobLoc.clone().add(0.0, this.mob.getHeight() + 1.0, 0.0), 5, 0.3, 0.3, 0.3, 0.01);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE);
    }
}

