/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Armadillo;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class RollDefenseGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private int rollDuration;
    private int rollCooldown;
    private boolean isRolled;
    private static final int ROLL_DURATION = 60;
    private static final int COOLDOWN_TICKS = 100;
    private static final double PANIC_THRESHOLD = 0.8;

    public RollDefenseGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "roll_defense"));
        this.rollDuration = 0;
        this.rollCooldown = 0;
        this.isRolled = false;
    }

    public boolean shouldActivate() {
        if (!(this.mob instanceof Armadillo)) {
            return false;
        }
        if (this.rollCooldown > 0) {
            --this.rollCooldown;
            return false;
        }
        double healthPercent = this.mob.getHealth() / this.mob.getAttribute(Attribute.MAX_HEALTH).getValue();
        if (healthPercent >= 0.8) {
            return false;
        }
        return this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean();
    }

    public boolean shouldStayActive() {
        return this.isRolled && this.rollDuration > 0;
    }

    public void start() {
        this.isRolled = true;
        this.rollDuration = 60;
        this.mob.setInvulnerable(true);
        this.mob.setAI(false);
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_ARMADILLO_ROLL, 1.0f, 1.0f);
            mobLoc.getWorld().spawnParticle(Particle.POOF, mobLoc, 15, 0.3, 0.3, 0.3, 0.05);
        }
    }

    public void stop() {
        this.isRolled = false;
        this.mob.setInvulnerable(false);
        this.mob.setAI(true);
        this.rollCooldown = 100;
    }

    public void tick() {
        --this.rollDuration;
        if (this.rollDuration <= 0) {
            this.stop();
            return;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null && this.rollDuration % 10 == 0) {
            Vector rollDirection = mobLoc.getDirection().multiply(-0.2);
            rollDirection.setY(0);
            this.mob.setVelocity(rollDirection);
        }
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE);
    }
}

