/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.content.mobs.herd.DominanceRank;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;
import org.shotrush.atom.core.data.PersistentData;

public class SentryBehaviorGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private int sentryTicks;
    private int scanDirection;
    private static final int SENTRY_DURATION = 2400;
    private static final double THREAT_DETECTION_RANGE = 20.0;
    private static final double SCAN_SPEED = 2.0;

    public SentryBehaviorGoal(Mob mob, Plugin plugin, HerdManager herdManager) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "sentry_behavior"));
        this.sentryTicks = 0;
        this.scanDirection = 0;
    }

    public boolean shouldActivate() {
        if (!(this.mob instanceof Animals)) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        DominanceRank rank = herd.getDominanceHierarchy().getRank(this.mob.getUniqueId());
        if (rank != DominanceRank.ALPHA && rank != DominanceRank.BETA) {
            return false;
        }
        long timeSinceLastSentry = System.currentTimeMillis() - PersistentData.getLong((PersistentDataHolder)this.mob, "last_sentry_time", 0L);
        return timeSinceLastSentry > 120000L && Math.random() < 0.1;
    }

    public boolean shouldStayActive() {
        if (!this.mob.isValid() || this.mob.isDead()) {
            return false;
        }
        if (this.mob.getTarget() != null) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        if (herd.isPanicking()) {
            return false;
        }
        return this.sentryTicks < 2400;
    }

    public void start() {
        this.sentryTicks = 0;
        this.scanDirection = 0;
        this.mob.getPathfinder().stopPathfinding();
    }

    public void stop() {
        PersistentData.set((PersistentDataHolder)this.mob, "last_sentry_time", System.currentTimeMillis());
    }

    public void tick() {
        Location loc;
        ++this.sentryTicks;
        this.mob.getPathfinder().stopPathfinding();
        this.scanDirection = (int)((double)this.scanDirection + 2.0);
        if (this.scanDirection >= 360) {
            this.scanDirection = 0;
        }
        float yaw = this.mob.getLocation().getYaw() + (float)this.scanDirection;
        Location lookTarget = this.mob.getEyeLocation().clone();
        lookTarget.setYaw(yaw);
        lookTarget.setPitch(0.0f);
        Vector direction = lookTarget.getDirection();
        Location scanPoint = this.mob.getEyeLocation().add(direction.multiply(5));
        this.mob.lookAt(scanPoint);
        if (this.sentryTicks % 60 == 0 && (loc = this.mob.getLocation()) != null && loc.getWorld() != null) {
            loc.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, loc.clone().add(0.0, this.mob.getHeight(), 0.0), 1);
        }
        if (this.sentryTicks % 20 == 0) {
            this.detectThreats();
        }
    }

    private void detectThreats() {
        Location loc = this.mob.getLocation();
        if (loc == null || loc.getWorld() == null) {
            return;
        }
        for (Entity entity : loc.getWorld().getNearbyEntities(loc, 20.0, 20.0, 20.0)) {
            if (!this.isThreat(entity)) continue;
            this.alertHerd(entity.getLocation());
            break;
        }
    }

    private boolean isThreat(Entity entity) {
        Wolf wolf;
        if (entity instanceof Player) {
            return true;
        }
        if (entity instanceof Monster) {
            return true;
        }
        return entity instanceof Wolf && (wolf = (Wolf)entity).isAngry();
    }

    private void alertHerd(Location threatLocation) {
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return;
        }
        Herd herd = herdOpt.get();
        this.herdManager.broadcastPanic(herd, threatLocation, 5000L);
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_GOAT_SCREAMING_AMBIENT, 1.5f, 1.0f);
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, this.mob.getHeight(), 0.0), 5, 0.5, 0.5, 0.5);
        }
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

