/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class SpitAttackGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private int spitCooldown;
    private static final int COOLDOWN_TICKS = 40;
    private static final double SPIT_RANGE_MIN = 5.0;
    private static final double SPIT_RANGE_MAX = 15.0;

    public SpitAttackGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "spit_attack"));
        this.spitCooldown = 0;
    }

    public boolean shouldActivate() {
        if (!(this.mob instanceof Llama)) {
            return false;
        }
        if (this.spitCooldown > 0) {
            --this.spitCooldown;
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isValid()) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return false;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return false;
        }
        double distance = mobLoc.distance(targetLoc);
        return distance >= 5.0 && distance <= 15.0;
    }

    public boolean shouldStayActive() {
        return false;
    }

    public void start() {
        this.performSpit();
        this.spitCooldown = 40;
    }

    public void stop() {
    }

    public void tick() {
    }

    private void performSpit() {
        Mob mob = this.mob;
        if (!(mob instanceof Llama)) {
            return;
        }
        Llama llama = (Llama)mob;
        LivingEntity target = this.mob.getTarget();
        if (target == null || !target.isValid()) {
            return;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return;
        }
        Location targetLoc = target.getLocation();
        if (targetLoc == null) {
            return;
        }
        LlamaSpit spit = (LlamaSpit)llama.launchProjectile(LlamaSpit.class);
        spit.setShooter((ProjectileSource)llama);
        Vector direction = targetLoc.toVector().subtract(mobLoc.toVector()).normalize();
        spit.setVelocity(direction.multiply(1.5));
        mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_LLAMA_SPIT, 1.0f, 1.0f);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

