/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class StalkPreyGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private LivingEntity prey;
    private static final double POUNCE_DISTANCE = 5.0;
    private static final double STALK_SPEED = 0.5;
    private static final double BLIND_SPOT_ANGLE = 120.0;

    public StalkPreyGoal(Mob mob, Plugin plugin) {
        this.mob = mob;
        this.plugin = plugin;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "stalk_prey"));
    }

    public boolean shouldActivate() {
        if (this.mob.getTarget() == null || !this.mob.getTarget().isValid()) {
            return false;
        }
        this.prey = this.mob.getTarget();
        if (this.mob.hasMetadata("in_combat") && ((MetadataValue)this.mob.getMetadata("in_combat").get(0)).asBoolean()) {
            return false;
        }
        double distance = this.mob.getLocation().distance(this.prey.getLocation());
        return distance > 5.0 && distance < 20.0;
    }

    public boolean shouldStayActive() {
        if (this.prey == null || !this.prey.isValid()) {
            return false;
        }
        double distance = this.mob.getLocation().distance(this.prey.getLocation());
        if (distance <= 5.0) {
            this.mob.setMetadata("ready_to_pounce", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
            return false;
        }
        return distance < 20.0;
    }

    public void start() {
        this.mob.setMetadata("stalking", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        this.mob.setSneaking(true);
    }

    public void stop() {
        this.mob.removeMetadata("stalking", this.plugin);
        this.mob.setSneaking(false);
    }

    public void tick() {
        if (this.prey == null || !this.prey.isValid()) {
            return;
        }
        Location mobLoc = this.mob.getLocation();
        Location preyLoc = this.prey.getLocation();
        if (mobLoc.getWorld() == null || preyLoc.getWorld() == null) {
            return;
        }
        Location stalkTarget = this.calculateBlindSpotPosition(mobLoc, preyLoc);
        if (stalkTarget != null) {
            this.mob.getPathfinder().moveTo(stalkTarget, 0.5);
        }
        if (this.canSee(this.prey, (LivingEntity)this.mob)) {
            this.mob.getPathfinder().stopPathfinding();
            if (Math.random() < 0.3) {
                this.mob.setMetadata("in_combat", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
                this.stop();
            }
        }
    }

    private Location calculateBlindSpotPosition(Location mobLoc, Location preyLoc) {
        Vector mobToPreyDirection;
        Vector preyDirection = preyLoc.getDirection().normalize();
        double angleToPreyFacing = Math.toDegrees(preyDirection.angle(mobToPreyDirection = preyLoc.toVector().subtract(mobLoc.toVector()).normalize()));
        if (angleToPreyFacing < 60.0) {
            Vector rightVector = preyDirection.clone().rotateAroundY(Math.toRadians(90.0));
            if (Math.random() < 0.5) {
                rightVector.multiply(-1);
            }
            Location targetPos = preyLoc.clone().add(rightVector.multiply(3));
            targetPos.setY(preyLoc.getY());
            return targetPos;
        }
        return preyLoc.clone();
    }

    private boolean canSee(LivingEntity observer, LivingEntity target) {
        Vector toTarget;
        Vector observerDirection = observer.getLocation().getDirection().normalize();
        double angle = Math.toDegrees(Math.acos(observerDirection.dot(toTarget = target.getLocation().toVector().subtract(observer.getLocation().toVector()).normalize())));
        return angle < 90.0;
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.LOOK);
    }
}

