/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class StampedeGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private Location stampedeThreat;
    private Vector stampedeDirection;
    private static final double STAMPEDE_SPEED = 1.6;
    private static final double GROUND_SHAKE_RADIUS = 8.0;
    private static final double TRAMPLE_RADIUS = 2.0;
    private static final double TRAMPLE_DAMAGE = 2.0;
    private int soundCooldown;

    public StampedeGoal(Mob mob, Plugin plugin, HerdManager herdManager) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "stampede"));
    }

    public boolean shouldActivate() {
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        if (!herd.isPanicking()) {
            return false;
        }
        if (herd.size() < 4) {
            return false;
        }
        Location threatLoc = herd.lastThreatLocation();
        if (threatLoc == null) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return false;
        }
        this.stampedeThreat = threatLoc;
        this.stampedeDirection = mobLoc.toVector().subtract(threatLoc.toVector()).normalize();
        this.stampedeDirection.setY(0);
        return true;
    }

    public boolean shouldStayActive() {
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        return herdOpt.get().isPanicking();
    }

    public void start() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_RAVAGER_STEP, 0.8f, 0.9f);
        }
        this.soundCooldown = 0;
    }

    public void stop() {
        this.stampedeThreat = null;
        this.stampedeDirection = null;
    }

    public void tick() {
        if (this.stampedeDirection == null) {
            return;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return;
        }
        Location target = mobLoc.clone().add(this.stampedeDirection.clone().multiply(30));
        if (target.getWorld() == null) {
            return;
        }
        this.mob.getPathfinder().moveTo(target, 1.6);
        if (Math.random() < 0.3) {
            mobLoc.getWorld().spawnParticle(Particle.DUST_PLUME, mobLoc.clone().add(0.0, 0.1, 0.0), 8, 0.5, 0.2, 0.5, 0.02);
        }
        this.applyGroundShakeEffects(mobLoc);
        this.trampleEntitiesInPath(mobLoc);
        if (this.soundCooldown <= 0) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_GENERIC_EXPLODE, 0.3f, 0.5f);
            this.soundCooldown = 15;
        } else {
            --this.soundCooldown;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return;
        }
        Herd herd = herdOpt.get();
        for (UUID memberId : herd.members()) {
            Location syncTarget;
            Animals member = (Animals)Bukkit.getEntity((UUID)memberId);
            if (member == null || !member.isValid() || member.getUniqueId().equals(this.mob.getUniqueId()) || !(member instanceof Mob)) continue;
            Animals memberMob = member;
            Location memberLoc = member.getLocation();
            if (memberLoc == null || !(mobLoc.distance(memberLoc) < 5.0) || (syncTarget = memberLoc.clone().add(this.stampedeDirection.clone().multiply(25))).getWorld() == null) continue;
            memberMob.getPathfinder().moveTo(syncTarget, 1.6);
        }
    }

    private void applyGroundShakeEffects(Location mobLoc) {
        for (Entity nearby : mobLoc.getWorld().getNearbyEntities(mobLoc, 8.0, 8.0, 8.0)) {
            if (!(nearby instanceof Player)) continue;
            Player player = (Player)nearby;
            player.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 60, 0, false, false));
            Vector shakeVelocity = new Vector((Math.random() - 0.5) * 0.15, 0.1, (Math.random() - 0.5) * 0.15);
            player.setVelocity(player.getVelocity().add(shakeVelocity));
        }
    }

    private void trampleEntitiesInPath(Location mobLoc) {
        for (Entity nearby : mobLoc.getWorld().getNearbyEntities(mobLoc, 2.0, 2.0, 2.0)) {
            if (!(nearby instanceof LivingEntity)) continue;
            LivingEntity target = (LivingEntity)nearby;
            if (nearby.equals((Object)this.mob)) continue;
            if (nearby instanceof Animals) {
                Optional<Herd> targetHerd = this.herdManager.getHerd(nearby.getUniqueId());
                Optional<Herd> mobHerd = this.herdManager.getHerd(this.mob.getUniqueId());
                if (targetHerd.isPresent() && mobHerd.isPresent() && targetHerd.get().equals(mobHerd.get())) continue;
            }
            target.damage(2.0, (Entity)this.mob);
            mobLoc.getWorld().spawnParticle(Particle.BLOCK, target.getLocation(), 10, 0.3, 0.3, 0.3, (Object)Material.DIRT.createBlockData());
        }
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE);
    }
}

