/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.AnimalDomestication;
import org.shotrush.atom.content.mobs.ai.config.SpeciesBehavior;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;
import org.shotrush.atom.content.mobs.herd.HerdRole;

public class StayNearHerdGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final HerdManager herdManager;
    private final SpeciesBehavior behavior;
    private int repathTimer;
    private static final int REPATH_INTERVAL = 40;

    public StayNearHerdGoal(Mob mob, Plugin plugin, HerdManager herdManager, SpeciesBehavior behavior) {
        this.mob = mob;
        this.herdManager = herdManager;
        this.behavior = behavior;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "stay_near_herd"));
        this.repathTimer = 0;
    }

    public boolean shouldActivate() {
        if (this.herdManager.getRole(this.mob.getUniqueId()) == HerdRole.LEADER) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        Animals leader = (Animals)Bukkit.getEntity((UUID)herd.leader());
        if (leader == null || !leader.isValid()) {
            return false;
        }
        double domesticationFactor = AnimalDomestication.getDomesticationFactor((Animals)this.mob);
        double cohesionRadius = this.behavior.getCohesionRadius(domesticationFactor);
        double distance = this.mob.getLocation().distance(leader.getLocation());
        return distance > cohesionRadius;
    }

    public boolean shouldStayActive() {
        if (this.mob.getTarget() != null) {
            return false;
        }
        if (this.mob.hasMetadata("fleeing") && ((MetadataValue)this.mob.getMetadata("fleeing").get(0)).asBoolean()) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        if (herd.isPanicking()) {
            return false;
        }
        Animals leader = (Animals)Bukkit.getEntity((UUID)herd.leader());
        if (leader == null || !leader.isValid()) {
            return false;
        }
        double domesticationFactor = AnimalDomestication.getDomesticationFactor((Animals)this.mob);
        double innerRadius = this.behavior.getCohesionRadius(domesticationFactor) * 0.6;
        double distance = this.mob.getLocation().distance(leader.getLocation());
        return distance > innerRadius;
    }

    public void start() {
        this.repathTimer = 0;
    }

    public void stop() {
        this.mob.getPathfinder().stopPathfinding();
    }

    public void tick() {
        ++this.repathTimer;
        if (this.repathTimer < 40) {
            return;
        }
        this.repathTimer = 0;
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return;
        }
        Herd herd = herdOpt.get();
        Animals leader = (Animals)Bukkit.getEntity((UUID)herd.leader());
        if (leader == null || !leader.isValid()) {
            return;
        }
        Location targetLocation = leader.getLocation();
        if (targetLocation == null || targetLocation.getWorld() == null) {
            return;
        }
        Location centroid = this.herdManager.getHerdCentroid(herd);
        if (centroid != null && Math.random() < 0.3) {
            targetLocation = centroid;
        }
        if (targetLocation == null || targetLocation.getWorld() == null) {
            return;
        }
        double domesticationFactor = AnimalDomestication.getDomesticationFactor((Animals)this.mob);
        double speed = 1.0 + 0.19999999999999996 * (1.0 - domesticationFactor);
        this.mob.getPathfinder().moveTo(targetLocation, speed);
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE);
    }
}

