/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.shotrush.atom.content.mobs.herd.DominanceRank;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

public class TerritoryDefenseGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final HerdManager herdManager;
    private Animals rivalLeader;
    private int chargeTimer;
    private static final double TERRITORY_RADIUS = 20.0;
    private static final double CHARGE_SPEED = 1.5;
    private static final int MAX_CHARGE_DURATION = 200;

    public TerritoryDefenseGoal(Mob mob, Plugin plugin, HerdManager herdManager) {
        this.mob = mob;
        this.plugin = plugin;
        this.herdManager = herdManager;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "territory_defense"));
        this.chargeTimer = 0;
    }

    public boolean shouldActivate() {
        Mob mob = this.mob;
        if (!(mob instanceof Animals)) {
            return false;
        }
        Animals animal = (Animals)mob;
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        Herd herd = herdOpt.get();
        DominanceRank rank = herd.getDominanceHierarchy().getRank(this.mob.getUniqueId());
        if (rank != DominanceRank.ALPHA) {
            return false;
        }
        Location mobLoc = this.mob.getLocation();
        if (mobLoc == null || mobLoc.getWorld() == null) {
            return false;
        }
        for (Entity nearby : mobLoc.getWorld().getNearbyEntities(mobLoc, 20.0, 20.0, 20.0)) {
            Herd rivalHerd;
            Optional<Herd> rivalHerdOpt;
            Animals rival;
            if (!(nearby instanceof Animals) || (rival = (Animals)nearby).getType() != this.mob.getType() || rival.getUniqueId() == this.mob.getUniqueId() || (rivalHerdOpt = this.herdManager.getHerd(rival.getUniqueId())).isEmpty() || (rivalHerd = rivalHerdOpt.get()).id().equals(herd.id()) || !rivalHerd.leader().equals(rival.getUniqueId())) continue;
            this.rivalLeader = rival;
            return true;
        }
        return false;
    }

    public boolean shouldStayActive() {
        if (!this.mob.isValid() || this.mob.isDead()) {
            return false;
        }
        if (this.rivalLeader == null || !this.rivalLeader.isValid()) {
            return false;
        }
        Optional<Herd> herdOpt = this.herdManager.getHerd(this.mob.getUniqueId());
        if (herdOpt.isEmpty()) {
            return false;
        }
        double distance = this.mob.getLocation().distance(this.rivalLeader.getLocation());
        if (distance > 30.0) {
            return false;
        }
        return this.chargeTimer < 200;
    }

    public void start() {
        this.chargeTimer = 0;
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().playSound(mobLoc, Sound.ENTITY_RAVAGER_ROAR, 1.5f, 1.2f);
            mobLoc.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, mobLoc.clone().add(0.0, this.mob.getHeight(), 0.0), 5, 0.5, 0.5, 0.5);
        }
    }

    public void stop() {
        this.rivalLeader = null;
        this.chargeTimer = 0;
        this.mob.getPathfinder().stopPathfinding();
    }

    public void tick() {
        Location loc;
        ++this.chargeTimer;
        if (this.rivalLeader == null || !this.rivalLeader.isValid()) {
            this.stop();
            return;
        }
        Location rivalLocation = this.rivalLeader.getLocation();
        if (rivalLocation == null) {
            return;
        }
        this.mob.getPathfinder().moveTo(rivalLocation, 1.5);
        double distance = this.mob.getLocation().distance(rivalLocation);
        if (distance < 2.5) {
            this.pushRivalAway();
        }
        if (this.chargeTimer % 20 == 0 && (loc = this.mob.getLocation()) != null && loc.getWorld() != null) {
            loc.getWorld().spawnParticle(Particle.SWEEP_ATTACK, loc.clone().add(0.0, this.mob.getHeight() / 2.0, 0.0), 1);
        }
    }

    private void pushRivalAway() {
        Optional<Herd> myHerdOpt;
        if (this.rivalLeader == null) {
            return;
        }
        Vector direction = this.rivalLeader.getLocation().toVector().subtract(this.mob.getLocation().toVector()).normalize();
        Vector pushVelocity = direction.multiply(0.8).setY(0.3);
        this.rivalLeader.setVelocity(pushVelocity);
        Location mobLoc = this.mob.getLocation();
        if (mobLoc != null && mobLoc.getWorld() != null) {
            mobLoc.getWorld().spawnParticle(Particle.CLOUD, this.rivalLeader.getLocation().add(0.0, 0.5, 0.0), 5, 0.3, 0.3, 0.3, 0.1);
            mobLoc.getWorld().playSound(this.rivalLeader.getLocation(), Sound.ENTITY_IRON_GOLEM_ATTACK, 0.8f, 1.5f);
        }
        if ((myHerdOpt = this.herdManager.getHerd(this.mob.getUniqueId())).isPresent()) {
            Herd myHerd = myHerdOpt.get();
            myHerd.getDominanceHierarchy().recordConfrontationWin(this.mob.getUniqueId());
        }
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.MOVE, GoalType.TARGET);
    }
}

