/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.ai.goals;

import com.destroystokyo.paper.entity.ai.Goal;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import java.util.EnumSet;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.mobs.ai.combat.InjurySystem;

public class TrackWoundedPreyGoal
implements Goal<Mob> {
    private final GoalKey<Mob> key;
    private final Mob mob;
    private final Plugin plugin;
    private final InjurySystem injurySystem;
    private LivingEntity woundedTarget;
    private static final double DETECTION_RADIUS = 32.0;
    private static final double AGGRO_RANGE_MULTIPLIER = 1.5;

    public TrackWoundedPreyGoal(Mob mob, Plugin plugin, InjurySystem injurySystem) {
        this.mob = mob;
        this.plugin = plugin;
        this.injurySystem = injurySystem;
        this.key = GoalKey.of(Mob.class, (NamespacedKey)new NamespacedKey(plugin, "track_wounded_prey"));
    }

    public boolean shouldActivate() {
        if (this.mob.getTarget() != null && this.mob.getTarget().isValid()) {
            return false;
        }
        this.woundedTarget = this.findNearestWoundedPrey();
        return this.woundedTarget != null;
    }

    public boolean shouldStayActive() {
        if (this.woundedTarget == null || !this.woundedTarget.isValid() || this.woundedTarget.isDead()) {
            return false;
        }
        InjurySystem.InjuryLevel level = this.injurySystem.getInjuryLevel((Mob)this.woundedTarget);
        if (level == InjurySystem.InjuryLevel.HEALTHY) {
            return false;
        }
        double distance = this.mob.getLocation().distance(this.woundedTarget.getLocation());
        return distance < 48.0;
    }

    public void start() {
        if (this.woundedTarget != null) {
            this.mob.setTarget(this.woundedTarget);
        }
    }

    public void stop() {
        this.woundedTarget = null;
    }

    public void tick() {
        if (this.woundedTarget == null || !this.woundedTarget.isValid()) {
            return;
        }
        double distance = this.mob.getLocation().distance(this.woundedTarget.getLocation());
        if (distance < 3.0) {
            this.mob.attack((Entity)this.woundedTarget);
        }
    }

    private LivingEntity findNearestWoundedPrey() {
        Location mobLoc = this.mob.getLocation();
        if (mobLoc.getWorld() == null) {
            return null;
        }
        List<LivingEntity> nearbyEntities = mobLoc.getWorld().getLivingEntities().stream().filter(entity -> entity instanceof Animals).filter(entity -> !entity.getUniqueId().equals(this.mob.getUniqueId())).filter(entity -> entity.getLocation().distance(mobLoc) <= 32.0).filter(entity -> entity instanceof Mob).toList();
        LivingEntity nearestWounded = null;
        double nearestDistance = Double.MAX_VALUE;
        for (LivingEntity entity2 : nearbyEntities) {
            Mob potentialPrey = (Mob)entity2;
            InjurySystem.InjuryLevel level = this.injurySystem.getInjuryLevel(potentialPrey);
            if (level != InjurySystem.InjuryLevel.WOUNDED && level != InjurySystem.InjuryLevel.CRITICALLY_INJURED) continue;
            double distance = mobLoc.distance(entity2.getLocation());
            if (level == InjurySystem.InjuryLevel.CRITICALLY_INJURED) {
                distance *= 0.7;
            }
            if (!(distance < nearestDistance)) continue;
            nearestDistance = distance;
            nearestWounded = entity2;
        }
        return nearestWounded;
    }

    public GoalKey<Mob> getKey() {
        return this.key;
    }

    public EnumSet<GoalType> getTypes() {
        return EnumSet.of(GoalType.TARGET, GoalType.MOVE);
    }
}

