/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.annotation.CommandAlias;
import co.aikar.commands.annotation.Default;
import co.aikar.commands.annotation.Description;
import co.aikar.commands.annotation.Subcommand;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdManager;

@CommandAlias(value="herd")
@Description(value="Debug commands for animal herds")
public class HerdCommand
extends BaseCommand {
    private final HerdManager herdManager;

    public HerdCommand(HerdManager herdManager) {
        this.herdManager = herdManager;
    }

    @Default
    @Subcommand(value="info")
    @Description(value="Get information about the animal you're looking at")
    public void onInfo(Player player) {
        Entity target = this.getTargetAnimal(player, 10.0);
        if (!(target instanceof Animals)) {
            player.sendMessage((Component)Component.text("You must be looking at an animal!", (TextColor)NamedTextColor.RED));
            return;
        }
        Animals animal = (Animals)target;
        Optional<Herd> herdOpt = this.herdManager.getHerd(animal.getUniqueId());
        if (herdOpt.isEmpty()) {
            player.sendMessage((Component)Component.text("This animal is not in a herd.", (TextColor)NamedTextColor.YELLOW));
            return;
        }
        Herd herd = herdOpt.get();
        boolean isLeader = herd.leader().equals(animal.getUniqueId());
        boolean isAggressive = animal.hasMetadata("aggressive") && ((MetadataValue)animal.getMetadata("aggressive").get(0)).asBoolean();
        double stamina = animal.hasMetadata("stamina") ? ((MetadataValue)animal.getMetadata("stamina").get(0)).asDouble() : 0.0;
        double maxStamina = animal.hasMetadata("maxStamina") ? ((MetadataValue)animal.getMetadata("maxStamina").get(0)).asDouble() : 100.0;
        player.sendMessage((Component)Component.text("=== Animal Info ===", (TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text("Species: ", (TextColor)NamedTextColor.GRAY).append(Component.text(animal.getType().name(), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("UUID: ", (TextColor)NamedTextColor.GRAY).append(Component.text(animal.getUniqueId().toString(), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("Role: ", (TextColor)NamedTextColor.GRAY).append(Component.text(isLeader ? "LEADER" : "FOLLOWER", (TextColor)(isLeader ? NamedTextColor.YELLOW : NamedTextColor.AQUA))));
        player.sendMessage(Component.text("Aggressive: ", (TextColor)NamedTextColor.GRAY).append(Component.text(isAggressive ? "Yes" : "No", (TextColor)(isAggressive ? NamedTextColor.RED : NamedTextColor.GREEN))));
        player.sendMessage(Component.text("Stamina: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.format("%.1f / %.1f", stamina, maxStamina), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("Health: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.format("%.1f / %.1f", animal.getHealth(), animal.getAttribute(Attribute.MAX_HEALTH).getValue()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage((Component)Component.text("=== Herd Info ===", (TextColor)NamedTextColor.GOLD));
        player.sendMessage(Component.text("Herd ID: ", (TextColor)NamedTextColor.GRAY).append(Component.text(herd.id().toString(), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("Members: ", (TextColor)NamedTextColor.GRAY).append(Component.text(String.valueOf(herd.size()), (TextColor)NamedTextColor.WHITE)));
        player.sendMessage(Component.text("Panicking: ", (TextColor)NamedTextColor.GRAY).append(Component.text(herd.isPanicking() ? "Yes" : "No", (TextColor)(herd.isPanicking() ? NamedTextColor.RED : NamedTextColor.GREEN))));
    }

    @Subcommand(value="list")
    @Description(value="List all nearby herds")
    public void onList(Player player) {
        int count2 = 0;
        for (Entity entity : player.getLocation().getNearbyEntities(50.0, 50.0, 50.0)) {
            Herd herd;
            Animals animal;
            Optional<Herd> herdOpt;
            if (!(entity instanceof Animals) || (herdOpt = this.herdManager.getHerd((animal = (Animals)entity).getUniqueId())).isEmpty() || !(herd = herdOpt.get()).leader().equals(animal.getUniqueId())) continue;
            player.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text("Herd: ", (TextColor)NamedTextColor.GRAY).append(Component.text(animal.getType().name(), (TextColor)NamedTextColor.YELLOW))).append(Component.text(" (", (TextColor)NamedTextColor.GRAY))).append(Component.text(herd.size() + " members", (TextColor)NamedTextColor.WHITE))).append(Component.text(")", (TextColor)NamedTextColor.GRAY)));
            ++count2;
        }
        if (count2 == 0) {
            player.sendMessage((Component)Component.text("No herds found nearby.", (TextColor)NamedTextColor.YELLOW));
        }
    }

    private Entity getTargetAnimal(Player player, double range) {
        return player.getTargetEntity((int)range, false);
    }
}

