/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.herd;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.shotrush.atom.content.mobs.herd.DominanceRank;
import org.shotrush.atom.content.mobs.herd.Herd;

public final class DominanceHierarchy {
    private final Map<UUID, DominanceRank> memberRanks;
    private final Map<UUID, Integer> confrontationWins;
    private final Herd herd;
    private static final double ALPHA_THRESHOLD = 0.85;
    private static final double BETA_THRESHOLD = 0.65;
    private static final double SUBORDINATE_THRESHOLD = 0.3;

    public DominanceHierarchy(Herd herd) {
        this.herd = herd;
        this.memberRanks = new ConcurrentHashMap<UUID, DominanceRank>();
        this.confrontationWins = new ConcurrentHashMap<UUID, Integer>();
    }

    public DominanceRank getRank(UUID memberId) {
        return this.memberRanks.getOrDefault(memberId, DominanceRank.SUBORDINATE);
    }

    public void setRank(UUID memberId, DominanceRank rank) {
        this.memberRanks.put(memberId, rank);
    }

    public void recalculateRanks() {
        Set<UUID> members = this.herd.members();
        if (members.size() <= 1) {
            if (!members.isEmpty()) {
                UUID leaderId = members.iterator().next();
                this.memberRanks.put(leaderId, DominanceRank.ALPHA);
            }
            return;
        }
        ArrayList<RankedMember> rankings = new ArrayList<RankedMember>();
        for (UUID memberId : members) {
            Animals animal = (Animals)Bukkit.getEntity((UUID)memberId);
            if (animal == null || !animal.isValid()) continue;
            double score = this.calculateDominanceScore(animal, memberId);
            rankings.add(new RankedMember(memberId, score));
        }
        rankings.sort(Comparator.comparingDouble(RankedMember::score).reversed());
        int totalMembers = rankings.size();
        for (int i = 0; i < rankings.size(); ++i) {
            UUID memberId = ((RankedMember)rankings.get(i)).memberId();
            double position = (double)i / (double)Math.max(1, totalMembers - 1);
            DominanceRank rank = position <= 0.85 && i == 0 ? DominanceRank.ALPHA : (position <= 0.65 && i <= 1 ? DominanceRank.BETA : (position >= 0.7 && i == rankings.size() - 1 ? DominanceRank.OMEGA : DominanceRank.SUBORDINATE));
            this.memberRanks.put(memberId, rank);
        }
    }

    private double calculateDominanceScore(Animals animal, UUID memberId) {
        double healthRatio = animal.getHealth() / Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getValue();
        long age = animal.getTicksLived();
        double ageScore = Math.min(1.0, (double)age / 480000.0);
        int wins = this.confrontationWins.getOrDefault(memberId, 0);
        double winScore = Math.min(1.0, (double)wins / 10.0);
        boolean isLeader = this.herd.leader().equals(memberId);
        double leaderBonus = isLeader ? 0.3 : 0.0;
        return healthRatio * 0.4 + ageScore * 0.3 + winScore * 0.2 + leaderBonus;
    }

    public void recordConfrontationWin(UUID winnerId) {
        this.confrontationWins.merge(winnerId, 1, Integer::sum);
        this.recalculateRanks();
    }

    public void challengeForRank(UUID challengerId, UUID defenderId) {
        double defenderScore;
        Animals challenger = (Animals)Bukkit.getEntity((UUID)challengerId);
        Animals defender = (Animals)Bukkit.getEntity((UUID)defenderId);
        if (challenger == null || defender == null) {
            return;
        }
        double challengerScore = this.calculateDominanceScore(challenger, challengerId);
        if (challengerScore > (defenderScore = this.calculateDominanceScore(defender, defenderId)) * 1.2) {
            this.recordConfrontationWin(challengerId);
        } else {
            this.recordConfrontationWin(defenderId);
        }
    }

    public boolean hasHigherRank(UUID member1, UUID member2) {
        DominanceRank rank1 = this.getRank(member1);
        DominanceRank rank2 = this.getRank(member2);
        return rank1.ordinal() < rank2.ordinal();
    }

    public boolean canAccessResource(UUID memberId, UUID competitorId) {
        return this.hasHigherRank(memberId, competitorId);
    }

    public boolean canMate(UUID memberId) {
        DominanceRank rank = this.getRank(memberId);
        return rank == DominanceRank.ALPHA || rank == DominanceRank.BETA;
    }

    public void removeMember(UUID memberId) {
        this.memberRanks.remove(memberId);
        this.confrontationWins.remove(memberId);
        this.recalculateRanks();
    }

    private record RankedMember(UUID memberId, double score) {
    }
}

