/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.herd;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.shotrush.atom.content.mobs.herd.DominanceHierarchy;

public final class Herd {
    private final UUID id;
    private final EntityType species;
    private final World world;
    private final Set<UUID> members;
    private UUID leader;
    private long panicUntil;
    private Location lastThreatLocation;
    private final DominanceHierarchy dominanceHierarchy;

    public Herd(UUID id, EntityType species, World world, UUID initialLeader) {
        this.id = id;
        this.species = species;
        this.world = world;
        this.members = ConcurrentHashMap.newKeySet();
        this.leader = initialLeader;
        this.panicUntil = 0L;
        this.lastThreatLocation = null;
        this.dominanceHierarchy = new DominanceHierarchy(this);
        this.members.add(initialLeader);
    }

    public UUID id() {
        return this.id;
    }

    public EntityType species() {
        return this.species;
    }

    public World world() {
        return this.world;
    }

    public Set<UUID> members() {
        return this.members;
    }

    public UUID leader() {
        return this.leader;
    }

    public void setLeader(UUID leader) {
        this.leader = leader;
    }

    public boolean isPanicking() {
        return System.currentTimeMillis() < this.panicUntil;
    }

    public void setPanic(long durationMs, Location threatLocation) {
        this.panicUntil = System.currentTimeMillis() + durationMs;
        this.lastThreatLocation = threatLocation;
    }

    public Location lastThreatLocation() {
        return this.lastThreatLocation;
    }

    public void addMember(UUID memberId) {
        this.members.add(memberId);
    }

    public void removeMember(UUID memberId) {
        this.members.remove(memberId);
    }

    public int size() {
        return this.members.size();
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public DominanceHierarchy getDominanceHierarchy() {
        return this.dominanceHierarchy;
    }
}

