/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.herd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Animals;
import org.bukkit.entity.EntityType;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.mobs.herd.Herd;
import org.shotrush.atom.content.mobs.herd.HerdPersistence;
import org.shotrush.atom.content.mobs.herd.HerdRole;

public final class HerdManager {
    private final Atom plugin;
    private final Map<World, Map<EntityType, List<Herd>>> herdsByWorld;
    private final Map<UUID, Herd> animalToHerd;
    private final Map<UUID, Herd> herdsByUUID;
    private final HerdPersistence persistence;
    private static final double HERD_JOIN_RADIUS = 16.0;

    public HerdManager(Atom plugin) {
        this.plugin = plugin;
        this.herdsByWorld = new ConcurrentHashMap<World, Map<EntityType, List<Herd>>>();
        this.animalToHerd = new ConcurrentHashMap<UUID, Herd>();
        this.herdsByUUID = new ConcurrentHashMap<UUID, Herd>();
        this.persistence = new HerdPersistence(plugin);
    }

    public Herd getOrCreateHerd(Animals animal) {
        Location location;
        EntityType species;
        Herd existingHerd = this.animalToHerd.get(animal.getUniqueId());
        if (existingHerd != null) {
            return existingHerd;
        }
        UUID persistedHerdId = this.persistence.getHerdId(animal);
        if (persistedHerdId != null) {
            Herd persistedHerd = this.herdsByUUID.get(persistedHerdId);
            if (persistedHerd != null) {
                this.joinHerd(animal, persistedHerd);
                this.plugin.getLogger().info("Restored animal to persisted herd: " + String.valueOf(persistedHerdId));
                return persistedHerd;
            }
            persistedHerd = new Herd(persistedHerdId, animal.getType(), animal.getWorld(), animal.getUniqueId());
            this.registerHerd(persistedHerd);
            this.animalToHerd.put(animal.getUniqueId(), persistedHerd);
            this.plugin.getLogger().info("Re-created persisted herd: " + String.valueOf(persistedHerdId) + " with original leader");
            return persistedHerd;
        }
        World world = animal.getWorld();
        Herd nearbyHerd = this.findNearbyHerd(world, species = animal.getType(), location = animal.getLocation());
        if (nearbyHerd != null) {
            this.joinHerd(animal, nearbyHerd);
            return nearbyHerd;
        }
        return this.createNewHerd(animal);
    }

    private Herd findNearbyHerd(World world, EntityType species, Location location) {
        Map<EntityType, List<Herd>> worldHerds = this.herdsByWorld.get(world);
        if (worldHerds == null) {
            return null;
        }
        List<Herd> speciesHerds = worldHerds.get(species);
        if (speciesHerds == null) {
            return null;
        }
        for (Herd herd : speciesHerds) {
            Animals leader = (Animals)Bukkit.getEntity((UUID)herd.leader());
            if (leader == null || !(leader.getLocation().distance(location) <= 16.0)) continue;
            return herd;
        }
        return null;
    }

    private Herd createNewHerd(Animals animal) {
        UUID herdId = UUID.randomUUID();
        Herd herd = new Herd(herdId, animal.getType(), animal.getWorld(), animal.getUniqueId());
        this.registerHerd(herd);
        this.animalToHerd.put(animal.getUniqueId(), herd);
        this.plugin.getLogger().info("Created new herd " + String.valueOf(herdId) + " for " + String.valueOf(animal.getType()) + " with leader " + String.valueOf(animal.getUniqueId()));
        return herd;
    }

    private void registerHerd(Herd herd) {
        this.herdsByWorld.computeIfAbsent(herd.world(), k -> new ConcurrentHashMap()).computeIfAbsent(herd.species(), k -> new ArrayList()).add(herd);
        this.herdsByUUID.put(herd.id(), herd);
    }

    private void joinHerd(Animals animal, Herd herd) {
        herd.addMember(animal.getUniqueId());
        this.animalToHerd.put(animal.getUniqueId(), herd);
        this.plugin.getLogger().info(String.valueOf(animal.getType()) + " " + String.valueOf(animal.getUniqueId()) + " joined herd " + String.valueOf(herd.id()));
    }

    public void leaveHerd(UUID animalId) {
        Herd herd = this.animalToHerd.remove(animalId);
        if (herd == null) {
            return;
        }
        herd.removeMember(animalId);
        this.plugin.getLogger().info("Animal " + String.valueOf(animalId) + " left herd " + String.valueOf(herd.id()));
        if (herd.isEmpty()) {
            this.removeHerd(herd);
            return;
        }
        if (herd.leader().equals(animalId)) {
            this.electNewLeader(herd);
        }
    }

    private void electNewLeader(Herd herd) {
        Animals newLeader = null;
        double highestScore = -1.0;
        for (UUID memberId : herd.members()) {
            long age;
            double maxHealth;
            double health;
            double healthRatio;
            double score;
            Animals animal = (Animals)Bukkit.getEntity((UUID)memberId);
            if (animal == null || !animal.isValid() || !((score = (healthRatio = (health = animal.getHealth()) / (maxHealth = Objects.requireNonNull(animal.getAttribute(Attribute.MAX_HEALTH)).getValue())) * 0.6 + (double)(age = (long)animal.getTicksLived()) / 100000.0 * 0.4) > highestScore)) continue;
            highestScore = score;
            newLeader = animal;
        }
        if (newLeader != null) {
            herd.setLeader(newLeader.getUniqueId());
            this.plugin.getLogger().info("Elected new leader " + String.valueOf(newLeader.getUniqueId()) + " for herd " + String.valueOf(herd.id()));
        }
    }

    private void removeHerd(Herd herd) {
        List<Herd> speciesHerds;
        Map<EntityType, List<Herd>> worldHerds = this.herdsByWorld.get(herd.world());
        if (worldHerds != null && (speciesHerds = worldHerds.get(herd.species())) != null) {
            speciesHerds.remove(herd);
        }
        this.herdsByUUID.remove(herd.id());
        this.plugin.getLogger().info("Removed empty herd " + String.valueOf(herd.id()));
    }

    public HerdPersistence getPersistence() {
        return this.persistence;
    }

    public Optional<Herd> getHerd(UUID animalId) {
        return Optional.ofNullable(this.animalToHerd.get(animalId));
    }

    public HerdRole getRole(UUID animalId) {
        Herd herd = this.animalToHerd.get(animalId);
        if (herd == null) {
            return HerdRole.FOLLOWER;
        }
        return herd.leader().equals(animalId) ? HerdRole.LEADER : HerdRole.FOLLOWER;
    }

    public void broadcastPanic(Herd herd, Location threatLocation, long durationMs) {
        herd.setPanic(durationMs, threatLocation);
        this.plugin.getLogger().info("Herd " + String.valueOf(herd.id()) + " entering panic mode for " + durationMs + "ms");
    }

    public Location getHerdCentroid(Herd herd) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (UUID memberId : herd.members()) {
            Animals animal = (Animals)Bukkit.getEntity((UUID)memberId);
            if (animal == null || !animal.isValid()) continue;
            locations.add(animal.getLocation());
        }
        if (locations.isEmpty()) {
            return null;
        }
        double x = locations.stream().mapToDouble(Location::getX).average().orElse(0.0);
        double y = locations.stream().mapToDouble(Location::getY).average().orElse(0.0);
        double z = locations.stream().mapToDouble(Location::getZ).average().orElse(0.0);
        return new Location(herd.world(), x, y, z);
    }
}

