/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.mobs.herd;

import java.util.UUID;
import org.bukkit.entity.Animals;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.core.data.PersistentData;

public final class HerdPersistence {
    public HerdPersistence(Plugin plugin) {
    }

    public void saveHerdData(Animals animal, UUID herdId, boolean isLeader, boolean isAggressive, double maxStamina, double stamina) {
        PersistentData.set((PersistentDataHolder)animal, "herd_id", herdId.toString());
        PersistentData.set((PersistentDataHolder)animal, "is_leader", isLeader);
        PersistentData.set((PersistentDataHolder)animal, "is_aggressive", isAggressive);
        PersistentData.set((PersistentDataHolder)animal, "max_stamina", maxStamina);
        PersistentData.set((PersistentDataHolder)animal, "stamina", stamina);
    }

    public boolean hasHerdData(Animals animal) {
        return PersistentData.has((PersistentDataHolder)animal, "herd_id");
    }

    public UUID getHerdId(Animals animal) {
        String idString = PersistentData.getString((PersistentDataHolder)animal, "herd_id", null);
        if (idString == null) {
            return null;
        }
        try {
            return UUID.fromString(idString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isLeader(Animals animal) {
        return PersistentData.getBoolean((PersistentDataHolder)animal, "is_leader", false);
    }

    public boolean isAggressive(Animals animal) {
        return PersistentData.getBoolean((PersistentDataHolder)animal, "is_aggressive", false);
    }

    public double getMaxStamina(Animals animal, double defaultValue) {
        return PersistentData.getDouble((PersistentDataHolder)animal, "max_stamina", defaultValue);
    }

    public double getStamina(Animals animal, double defaultValue) {
        return PersistentData.getDouble((PersistentDataHolder)animal, "stamina", defaultValue);
    }

    public void updateStamina(Animals animal, double stamina) {
        PersistentData.set((PersistentDataHolder)animal, "stamina", stamina);
    }

    public void clearHerdData(Animals animal) {
        PersistentData.remove((PersistentDataHolder)animal, "herd_id");
        PersistentData.remove((PersistentDataHolder)animal, "is_leader");
        PersistentData.remove((PersistentDataHolder)animal, "is_aggressive");
        PersistentData.remove((PersistentDataHolder)animal, "max_stamina");
        PersistentData.remove((PersistentDataHolder)animal, "stamina");
    }
}

