/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.systems;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.systems.PlayerTemperatureSystem;
import org.shotrush.atom.core.api.combat.ArmorProtectionAPI;
import org.shotrush.atom.core.api.combat.TemperatureEffectsAPI;
import org.shotrush.atom.core.api.player.AttributeModifierAPI;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.api.world.EnvironmentalFactorAPI;
import org.shotrush.atom.core.data.PersistentData;
import org.shotrush.atom.core.util.ActionBarManager;

public class ItemHeatSystem
implements Listener {
    public static ItemHeatSystem instance;
    private final Plugin plugin;
    private static final NamespacedKey HEAT_MODIFIER_KEY;
    private static final Map<UUID, Map<Integer, Double>> playerItemHeatCache;
    private static final Map<UUID, ItemStack> lastKnownItems;

    public ItemHeatSystem(Plugin plugin) {
        this.plugin = plugin;
        instance = this;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.startHeatTickForPlayer(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        Map<Integer, Double> slotHeatMap = playerItemHeatCache.get(playerId);
        if (slotHeatMap != null) {
            for (int slot = 0; slot < 9; ++slot) {
                Double cachedHeat;
                ItemStack item = player.getInventory().getItem(slot);
                if (item == null || item.getType() == Material.AIR || (cachedHeat = slotHeatMap.get(slot)) == null) continue;
                ItemHeatSystem.setItemHeat(item, cachedHeat);
            }
        }
        playerItemHeatCache.remove(playerId);
        lastKnownItems.remove(playerId);
    }

    @EventHandler
    public void onItemHeld(PlayerItemHeldEvent event) {
        ItemStack item;
        Double cachedHeat;
        UUID playerId;
        Map<Integer, Double> slotHeatMap;
        Player player = event.getPlayer();
        int previousSlot = event.getPreviousSlot();
        ItemStack previousItem = player.getInventory().getItem(previousSlot);
        if (previousItem != null && previousItem.getType() != Material.AIR && (slotHeatMap = playerItemHeatCache.get(playerId = player.getUniqueId())) != null && (cachedHeat = slotHeatMap.get(previousSlot)) != null) {
            ItemHeatSystem.setItemHeat(previousItem, cachedHeat);
        }
        if ((item = player.getInventory().getItem(event.getNewSlot())) != null && item.getType() != Material.AIR) {
            this.applyHeatEffect(player, item);
        } else {
            this.removeHeatEffect(player);
        }
    }

    private void startHeatTickForPlayer(Player player) {
        SchedulerAPI.runTaskTimer((Entity)player, task -> {
            if (!player.isOnline()) {
                task.cancel();
                playerItemHeatCache.remove(player.getUniqueId());
                lastKnownItems.remove(player.getUniqueId());
                return;
            }
            ItemStack heldItem = player.getInventory().getItemInMainHand();
            if (heldItem != null && heldItem.getType() != Material.AIR) {
                this.updateItemHeatInCache(player, heldItem);
                this.applyHeatEffectFromCache(player, heldItem);
                this.displayHeatActionBarFromCache(player, heldItem);
            }
        }, 1L, 20L);
    }

    private void updateItemHeatInCache(Player player, ItemStack item) {
        UUID playerId = player.getUniqueId();
        int slot = player.getInventory().getHeldItemSlot();
        ItemStack lastItem = lastKnownItems.get(playerId);
        if (lastItem == null || !item.isSimilar(lastItem)) {
            double heat = ItemHeatSystem.getItemHeat(item);
            playerItemHeatCache.computeIfAbsent(playerId, k -> new HashMap()).put(slot, heat);
            lastKnownItems.put(playerId, item.clone());
        }
        double currentHeat = playerItemHeatCache.computeIfAbsent(playerId, k -> new HashMap()).computeIfAbsent(slot, k -> ItemHeatSystem.getItemHeat(item));
        Location loc = player.getLocation();
        double bodyTemp = 37.0;
        PlayerTemperatureSystem tempSystem = PlayerTemperatureSystem.getInstance();
        if (tempSystem != null) {
            bodyTemp = tempSystem.getPlayerTemperature(player);
        }
        double targetTemp = bodyTemp - 17.0;
        double heatFromSources = EnvironmentalFactorAPI.getNearbyHeatSources(loc, 6);
        double heatDifference = (targetTemp += heatFromSources * 10.0) - currentHeat;
        double heatChange = heatDifference * 0.08;
        double newHeat = currentHeat + heatChange;
        newHeat = Math.max(-100.0, Math.min(500.0, newHeat));
        playerItemHeatCache.get(playerId).put(slot, newHeat);
    }

    private void applyHeatEffectFromCache(Player player, ItemStack item) {
        UUID playerId = player.getUniqueId();
        int slot = player.getInventory().getHeldItemSlot();
        Double heat = (Double)playerItemHeatCache.computeIfAbsent(playerId, k -> new HashMap()).get(slot);
        if (heat == null) {
            heat = ItemHeatSystem.getItemHeat(item);
        }
        boolean hasProtection = ArmorProtectionAPI.hasLeatherChestplate(player);
        if (heat != 0.0) {
            double speedModifier = -Math.abs(heat) * 0.001;
            AttributeModifierAPI.applyModifier(player, Attribute.MOVEMENT_SPEED, HEAT_MODIFIER_KEY, speedModifier, AttributeModifier.Operation.MULTIPLY_SCALAR_1);
        } else {
            AttributeModifierAPI.removeModifier(player, Attribute.MOVEMENT_SPEED, HEAT_MODIFIER_KEY);
        }
        TemperatureEffectsAPI.applyHeatDamage(player, heat, hasProtection);
        TemperatureEffectsAPI.applyColdDamage(player, heat, hasProtection);
    }

    private void displayHeatActionBarFromCache(Player player, ItemStack item) {
        String descriptor;
        String color;
        ActionBarManager manager;
        UUID playerId = player.getUniqueId();
        int slot = player.getInventory().getHeldItemSlot();
        Double heat = (Double)playerItemHeatCache.computeIfAbsent(playerId, k -> new HashMap()).get(slot);
        if (heat == null) {
            heat = ItemHeatSystem.getItemHeat(item);
        }
        if ((manager = ActionBarManager.getInstance()) == null) {
            return;
        }
        if (Math.abs(heat) < 5.0) {
            manager.removeMessage(player, "item_heat");
            return;
        }
        if (heat > 200.0) {
            color = "\u00a74";
            descriptor = "Burning";
        } else if (heat > 100.0) {
            color = "\u00a7c";
            descriptor = "Very Hot";
        } else if (heat > 50.0) {
            color = "\u00a76";
            descriptor = "Hot";
        } else if (heat > 20.0) {
            color = "\u00a7e";
            descriptor = "Warm";
        } else if (heat < -50.0) {
            color = "\u00a7b";
            descriptor = "Freezing";
        } else if (heat < -20.0) {
            color = "\u00a73";
            descriptor = "Cold";
        } else {
            color = "\u00a77";
            descriptor = "Cool";
        }
        String message = String.format("\u00a77Item: %s%s \u00a77(%.0f\u00b0C)", color, descriptor, heat);
        manager.setMessage(player, "item_heat", message);
    }

    private void displayHeatActionBar(Player player, ItemStack item) {
        String descriptor;
        String color;
        double heat = ItemHeatSystem.getItemHeat(item);
        ActionBarManager manager = ActionBarManager.getInstance();
        if (manager == null) {
            return;
        }
        if (Math.abs(heat) < 5.0) {
            manager.removeMessage(player, "item_heat");
            return;
        }
        if (heat > 200.0) {
            color = "\u00a74";
            descriptor = "Burning";
        } else if (heat > 100.0) {
            color = "\u00a7c";
            descriptor = "Very Hot";
        } else if (heat > 50.0) {
            color = "\u00a76";
            descriptor = "Hot";
        } else if (heat > 20.0) {
            color = "\u00a7e";
            descriptor = "Warm";
        } else if (heat < -50.0) {
            color = "\u00a7b";
            descriptor = "Freezing";
        } else if (heat < -20.0) {
            color = "\u00a73";
            descriptor = "Cold";
        } else {
            color = "\u00a77";
            descriptor = "Cool";
        }
        String message = String.format("\u00a77Item: %s%s \u00a77(%.0f\u00b0C)", color, descriptor, heat);
        manager.setMessage(player, "item_heat", message);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Item droppedItem = event.getItemDrop();
        ItemStack item = droppedItem.getItemStack();
        this.saveCachedHeatToItem(player, item);
        droppedItem.setItemStack(item);
        double heat = ItemHeatSystem.getItemHeat(item);
        if (heat > 200.0) {
            ItemHeatSystem.startDroppedItemFireTracking(droppedItem);
        }
        if (heat >= 50.0) {
            boolean hasProtection;
            ItemStack chestplate = player.getInventory().getChestplate();
            boolean bl = hasProtection = chestplate != null && chestplate.getType() == Material.LEATHER_CHESTPLATE;
            if (!hasProtection) {
                player.setFireTicks(40);
            }
        }
        this.startDroppedItemHeatTracking(droppedItem);
    }

    private void startDroppedItemHeatTracking(Item droppedItem) {
        SchedulerAPI.runTaskTimer((Entity)droppedItem, task -> {
            if (droppedItem.isDead() || !droppedItem.isValid()) {
                task.cancel();
                return;
            }
            ItemStack itemStack = droppedItem.getItemStack();
            double currentHeat = ItemHeatSystem.getItemHeat(itemStack);
            Location loc = droppedItem.getLocation();
            double heatChange = EnvironmentalFactorAPI.getNearbyHeatSources(loc, 6);
            double ambientTemp = 20.0;
            if (currentHeat > ambientTemp) {
                heatChange -= 0.5;
            }
            double newHeat = Math.max(0.0, currentHeat + heatChange * 0.1);
            ItemHeatSystem.setItemHeat(itemStack, newHeat);
            droppedItem.setItemStack(itemStack);
            if (newHeat >= 200.0) {
                Block below;
                double fireChance = Math.min(0.5, (newHeat - 200.0) / 600.0);
                if (Math.random() < fireChance && ((below = loc.getBlock().getRelative(BlockFace.DOWN)).getType().isBurnable() || below.getType() == Material.AIR)) {
                    loc.getBlock().setType(Material.FIRE);
                }
            }
        }, 20L, 20L);
    }

    private void updateItemHeatFromEnvironment(Player player, ItemStack item) {
        double currentHeat = ItemHeatSystem.getItemHeat(item);
        Location loc = player.getLocation();
        double tempChange = 0.0;
        Biome biome = loc.getBlock().getBiome();
        tempChange += EnvironmentalFactorAPI.getBiomeTemperature(biome);
        tempChange += EnvironmentalFactorAPI.getDayNightModifier(loc.getWorld());
        tempChange += EnvironmentalFactorAPI.getLightLevelModifier(loc);
        tempChange += EnvironmentalFactorAPI.getWaterIceModifier(player, loc);
        double targetTemp = 20.0 + (tempChange += EnvironmentalFactorAPI.getNearbyHeatSources(loc, 5)) * 2.0;
        double heatDifference = targetTemp - currentHeat;
        double heatChange = heatDifference * 0.08;
        double newHeat = currentHeat + heatChange;
        if (Math.abs((newHeat = Math.max(-150.0, Math.min(600.0, newHeat))) - currentHeat) > 0.5) {
            ItemHeatSystem.setItemHeat(item, newHeat);
        }
    }

    private void applyHeatEffect(Player player, ItemStack item) {
        double heat = ItemHeatSystem.getItemHeat(item);
        boolean hasProtection = ArmorProtectionAPI.hasLeatherChestplate(player);
        if (heat != 0.0) {
            double speedModifier = -Math.abs(heat) * 0.001;
            AttributeModifierAPI.applyModifier(player, Attribute.MOVEMENT_SPEED, HEAT_MODIFIER_KEY, speedModifier, AttributeModifier.Operation.MULTIPLY_SCALAR_1);
        } else {
            AttributeModifierAPI.removeModifier(player, Attribute.MOVEMENT_SPEED, HEAT_MODIFIER_KEY);
        }
        TemperatureEffectsAPI.applyHeatDamage(player, heat, hasProtection);
        TemperatureEffectsAPI.applyColdDamage(player, heat, hasProtection);
    }

    private void removeHeatEffect(Player player) {
        AttributeModifierAPI.removeModifier(player, Attribute.MOVEMENT_SPEED, HEAT_MODIFIER_KEY);
    }

    public static double getItemHeat(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return 0.0;
        }
        return PersistentData.getDouble((PersistentDataHolder)item.getItemMeta(), "item_heat", 0.0);
    }

    public static void setItemHeat(ItemStack item, double heat) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentData.set((PersistentDataHolder)meta, "item_heat", heat);
        item.setItemMeta(meta);
    }

    private void saveCachedHeatToItem(Player player, ItemStack item) {
        Double cachedHeat;
        UUID playerId = player.getUniqueId();
        int slot = player.getInventory().getHeldItemSlot();
        Map<Integer, Double> slotHeatMap = playerItemHeatCache.get(playerId);
        if (slotHeatMap != null && (cachedHeat = slotHeatMap.get(slot)) != null) {
            ItemHeatSystem.setItemHeat(item, cachedHeat);
        }
    }

    public void saveHeatForSlot(Player player, int slot, ItemStack item) {
        Double cachedHeat;
        UUID playerId = player.getUniqueId();
        Map<Integer, Double> slotHeatMap = playerItemHeatCache.get(playerId);
        if (slotHeatMap != null && (cachedHeat = slotHeatMap.get(slot)) != null) {
            ItemHeatSystem.setItemHeat(item, cachedHeat);
        }
    }

    public static void startItemDisplayHeatTracking(ItemDisplay itemDisplay) {
        SchedulerAPI.runTaskTimer((Entity)itemDisplay, task -> {
            if (itemDisplay.isDead() || !itemDisplay.isValid()) {
                task.cancel();
                return;
            }
            ItemStack itemStack = itemDisplay.getItemStack();
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                task.cancel();
                return;
            }
            double currentHeat = ItemHeatSystem.getItemHeat(itemStack);
            Location loc = itemDisplay.getLocation();
            double heatFromSources = EnvironmentalFactorAPI.getNearbyHeatSources(loc, 6);
            double ambientTemp = 20.0;
            double targetTemp = ambientTemp + heatFromSources * 10.0;
            double heatDifference = targetTemp - currentHeat;
            double heatChange = heatDifference * 0.05;
            double newHeat = currentHeat + heatChange;
            if (Math.abs((newHeat = Math.max(-100.0, Math.min(500.0, newHeat))) - currentHeat) > 0.5) {
                ItemHeatSystem.setItemHeat(itemStack, newHeat);
                itemDisplay.setItemStack(itemStack);
            }
        }, 20L, 20L);
    }

    public static void startDroppedItemFireTracking(Item item) {
        SchedulerAPI.runTaskTimer((Entity)item, task -> {
            if (item.isDead() || !item.isValid()) {
                task.cancel();
                return;
            }
            ItemStack itemStack = item.getItemStack();
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                task.cancel();
                return;
            }
            double currentHeat = ItemHeatSystem.getItemHeat(itemStack);
            if (currentHeat > 200.0) {
                ItemHeatSystem.igniteNearbyBlocks(item.getLocation(), currentHeat);
            }
            double ambientTemp = 20.0;
            double heatDifference = ambientTemp - currentHeat;
            double heatChange = heatDifference * 0.02;
            double newHeat = currentHeat + heatChange;
            if (Math.abs((newHeat = Math.max(-100.0, Math.min(500.0, newHeat))) - currentHeat) > 0.5) {
                ItemHeatSystem.setItemHeat(itemStack, newHeat);
                item.setItemStack(itemStack);
            }
        }, 10L, 10L);
    }

    private static void igniteNearbyBlocks(Location location, double temperature) {
        if (location.getWorld() == null) {
            return;
        }
        int radius = (int)Math.min(3.0, (temperature - 200.0) / 100.0);
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Location checkLoc = location.clone().add((double)x, (double)y, (double)z);
                    Block block = checkLoc.getBlock();
                    if (!ItemHeatSystem.isFlammable(block) || block.getRelative(BlockFace.UP).getType() != Material.AIR) continue;
                    double igniteChance = Math.min(0.3, (temperature - 200.0) / 1000.0);
                    if (!(Math.random() < igniteChance)) continue;
                    block.getRelative(BlockFace.UP).setType(Material.FIRE);
                }
            }
        }
    }

    private static boolean isFlammable(Block block) {
        Material type = block.getType();
        return type == Material.OAK_PLANKS || type == Material.SPRUCE_PLANKS || type == Material.BIRCH_PLANKS || type == Material.JUNGLE_PLANKS || type == Material.ACACIA_PLANKS || type == Material.DARK_OAK_PLANKS || type == Material.MANGROVE_PLANKS || type == Material.CHERRY_PLANKS || type == Material.BAMBOO_PLANKS || type == Material.CRIMSON_PLANKS || type == Material.WARPED_PLANKS || type == Material.OAK_LOG || type == Material.SPRUCE_LOG || type == Material.BIRCH_LOG || type == Material.JUNGLE_LOG || type == Material.ACACIA_LOG || type == Material.DARK_OAK_LOG || type == Material.MANGROVE_LOG || type == Material.CHERRY_LOG || type == Material.OAK_LEAVES || type == Material.SPRUCE_LEAVES || type == Material.BIRCH_LEAVES || type == Material.JUNGLE_LEAVES || type == Material.ACACIA_LEAVES || type == Material.DARK_OAK_LEAVES || type == Material.MANGROVE_LEAVES || type == Material.CHERRY_LEAVES || type == Material.AZALEA_LEAVES || type == Material.FLOWERING_AZALEA_LEAVES || type == Material.GRASS_BLOCK || type == Material.TALL_GRASS || type == Material.FERN || type == Material.LARGE_FERN || type == Material.DEAD_BUSH || type == Material.DANDELION || type == Material.POPPY || type == Material.BLUE_ORCHID || type.name().endsWith("_WOOL") || type.name().endsWith("_CARPET") || type == Material.HAY_BLOCK || type == Material.DRIED_KELP_BLOCK || type == Material.TNT || type == Material.BOOKSHELF;
    }

    @Generated
    public static ItemHeatSystem getInstance() {
        return instance;
    }

    static {
        HEAT_MODIFIER_KEY = new NamespacedKey("atom", "heat_modifier");
        playerItemHeatCache = new HashMap<UUID, Map<Integer, Double>>();
        lastKnownItems = new HashMap<UUID, ItemStack>();
    }
}

