/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.systems;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.content.systems.ThirstSystem;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.api.combat.ArmorProtectionAPI;
import org.shotrush.atom.core.api.combat.TemperatureEffectsAPI;
import org.shotrush.atom.core.api.player.PlayerDataAPI;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.api.world.EnvironmentalFactorAPI;
import org.shotrush.atom.core.util.ActionBarManager;

@RegisterSystem(id="player_temperature_system", priority=4, dependencies={"action_bar_manager"}, toggleable=true, description="Manages player body temperature")
public class PlayerTemperatureSystem
implements Listener {
    public static PlayerTemperatureSystem instance;
    private final Plugin plugin;
    private final Map<UUID, Double> playerTemperatures = new HashMap<UUID, Double>();
    private static final double NORMAL_TEMP = 37.0;
    private static final double MAX_TEMP = 44.0;
    private static final double MIN_TEMP = 30.0;
    private static final double COMFORTABLE_RANGE = 2.0;
    private static final double WARNING_RANGE = 3.0;

    public PlayerTemperatureSystem(Plugin plugin) {
        this.plugin = plugin;
        instance = this;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        double savedTemp = PlayerDataAPI.getDouble(player, "temperature.body", 37.0);
        this.playerTemperatures.put(playerId, savedTemp);
        this.startTemperatureTickForPlayer(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        double temp = this.playerTemperatures.getOrDefault(playerId, 37.0);
        PlayerDataAPI.setDouble(player, "temperature.body", temp);
        this.playerTemperatures.remove(playerId);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        UUID playerId = player.getUniqueId();
        this.playerTemperatures.put(playerId, 37.0);
        PlayerDataAPI.setDouble(player, "temperature.body", 37.0);
    }

    private void startTemperatureTickForPlayer(Player player) {
        SchedulerAPI.runTaskTimer((Entity)player, task -> {
            if (!player.isOnline()) {
                task.cancel();
                return;
            }
            this.updatePlayerTemperature(player);
        }, 1L, 20L);
    }

    private void updatePlayerTemperature(Player player) {
        UUID playerId = player.getUniqueId();
        double currentTemp = this.playerTemperatures.getOrDefault(playerId, 37.0);
        Location loc = player.getLocation();
        double envChange = EnvironmentalFactorAPI.calculateEnvironmentalTemperatureChange(player, loc, 0.0125);
        double armorInsulation = ArmorProtectionAPI.getInsulationValue(player);
        envChange *= 1.0 - armorInsulation * 0.7;
        double naturalRegulation = 0.0;
        double tempDiff = currentTemp - 37.0;
        double deviation = Math.abs(tempDiff);
        if (deviation > 2.0) {
            naturalRegulation = -tempDiff * 0.08;
            double regulationCost = deviation * 0.015;
            if (Math.random() < regulationCost) {
                int currentThirst;
                ThirstSystem thirstSystem;
                int currentHunger = player.getFoodLevel();
                if (currentHunger > 0) {
                    player.setFoodLevel(Math.max(0, currentHunger - 1));
                }
                if ((thirstSystem = ThirstSystem.getInstance()) != null && (currentThirst = thirstSystem.getThirst(player)) > 0) {
                    thirstSystem.addThirst(player, -1);
                }
            }
        }
        double totalChange = envChange + naturalRegulation;
        totalChange = Math.max(-0.2, Math.min(0.2, totalChange));
        double newTemp = Math.max(30.0, Math.min(44.0, currentTemp + totalChange));
        this.playerTemperatures.put(playerId, newTemp);
        this.applyTemperatureEffects(player, newTemp);
    }

    private void applyTemperatureEffects(Player player, double temp) {
        TemperatureEffectsAPI.applyBodyTemperatureEffects(player, temp);
        ActionBarManager manager = ActionBarManager.getInstance();
        if (manager == null) {
            return;
        }
        String message = "<gray>Body:</gray> " + TemperatureEffectsAPI.getBodyTempDisplay(temp);
        manager.setMessage(player, "body_temp", message);
    }

    public double getPlayerTemperature(Player player) {
        return this.playerTemperatures.getOrDefault(player.getUniqueId(), 37.0);
    }

    @Generated
    public static PlayerTemperatureSystem getInstance() {
        return instance;
    }
}

