/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.systems;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.RayTraceResult;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.systems.ItemHeatSystem;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.api.player.PlayerDataAPI;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.items.CustomItem;
import org.shotrush.atom.core.util.ActionBarManager;

@RegisterSystem(id="thirst_system", priority=2, dependencies={"action_bar_manager"}, toggleable=true, description="Manages player thirst mechanics")
public class ThirstSystem
implements Listener {
    public static ThirstSystem instance;
    private final Plugin plugin;
    private final Map<UUID, Integer> thirstLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Long> thirstAccelerationEnd = new HashMap<UUID, Long>();
    private final Map<UUID, Integer> thirstDamageTicks = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> thirstTickCounter = new HashMap<UUID, Integer>();
    private static final int MAX_THIRST = 20;
    private static final int THIRST_DECREASE_INTERVAL = 1;
    private static final int THIRST_DRAIN_RATE = 600;
    private static final int THIRST_DAMAGE_INTERVAL = 80;

    public ThirstSystem(Plugin plugin) {
        this.plugin = plugin;
        instance = this;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        int savedThirst = PlayerDataAPI.getInt(player, "thirst.level", 20);
        this.thirstLevels.put(playerId, savedThirst);
        this.updateThirstDisplay(player);
        this.startThirstTickForPlayer(player);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        int thirst = this.thirstLevels.getOrDefault(playerId, 20);
        PlayerDataAPI.setInt(player, "thirst.level", thirst);
        this.thirstLevels.remove(playerId);
        this.thirstAccelerationEnd.remove(playerId);
        this.thirstDamageTicks.remove(playerId);
        this.thirstTickCounter.remove(playerId);
        ActionBarManager.getInstance().removeMessage(player, "thirst");
    }

    private void startThirstTickForPlayer(Player player) {
        SchedulerAPI.runTaskTimer((Entity)player, task -> {
            if (!player.isOnline()) {
                task.cancel();
                return;
            }
            UUID playerId = player.getUniqueId();
            int currentThirst = this.thirstLevels.getOrDefault(playerId, 20);
            int tickCounter = this.thirstTickCounter.getOrDefault(playerId, 0) + 1;
            this.thirstTickCounter.put(playerId, tickCounter);
            if (tickCounter >= 600) {
                this.thirstTickCounter.put(playerId, 0);
                int decreaseAmount = 1;
                Long accelerationEnd = this.thirstAccelerationEnd.get(playerId);
                if (accelerationEnd != null && System.currentTimeMillis() < accelerationEnd) {
                    decreaseAmount = 2;
                } else {
                    this.thirstAccelerationEnd.remove(playerId);
                }
                this.thirstLevels.put(playerId, Math.max(0, currentThirst -= decreaseAmount));
            }
            if (currentThirst <= 0) {
                int damageTicks = this.thirstDamageTicks.getOrDefault(playerId, 0);
                this.thirstDamageTicks.put(playerId, ++damageTicks);
                if (damageTicks >= 80) {
                    player.damage(1.0);
                    this.thirstDamageTicks.put(playerId, 0);
                }
            } else {
                this.thirstDamageTicks.remove(playerId);
                if (currentThirst <= 5) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 0, false, false));
                }
            }
            this.checkWaterPurification(player);
            this.updateThirstDisplay(player);
        }, 1L, 1L);
    }

    @EventHandler
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        PotionMeta meta;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item.getType() == Material.POTION && (meta = (PotionMeta)item.getItemMeta()) != null) {
            if (meta.hasCustomEffect(PotionEffectType.REGENERATION)) {
                this.drinkPurifiedWater(player);
            } else if (meta.getBasePotionType() == PotionType.WATER) {
                this.drinkRawWater(player);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR || item.getType() == Material.BUCKET) {
            RayTraceResult result = player.rayTraceBlocks(5.0, FluidCollisionMode.ALWAYS);
            if (result != null && result.getHitBlock() != null && this.isWaterBlock(result.getHitBlock())) {
                this.drinkRawWater(player);
                event.setCancelled(true);
                return;
            }
            if (event.getClickedBlock() != null && this.isWaterBlock(event.getClickedBlock())) {
                this.drinkRawWater(player);
                event.setCancelled(true);
                return;
            }
        }
    }

    private boolean isWaterBlock(Block block) {
        Waterlogged waterlogged;
        BlockData blockData;
        return block.getType() == Material.WATER || (blockData = block.getBlockData()) instanceof Waterlogged && (waterlogged = (Waterlogged)blockData).isWaterlogged();
    }

    private void drinkRawWater(Player player) {
        UUID playerId = player.getUniqueId();
        int currentThirst = this.thirstLevels.getOrDefault(playerId, 20);
        this.addThirst(player, 5);
        int newThirst = this.thirstLevels.getOrDefault(playerId, 20);
        int gained = newThirst - currentThirst;
        if (gained > 0) {
            ActionBarManager.send(player, "<aqua>+<gray>" + gained + "</gray> Thirst</aqua>");
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 200, 0, false, false));
        this.thirstAccelerationEnd.put(playerId, System.currentTimeMillis() + 30000L);
    }

    private void drinkPurifiedWater(Player player) {
        UUID playerId = player.getUniqueId();
        int currentThirst = this.thirstLevels.getOrDefault(playerId, 20);
        this.addThirst(player, 10);
        int newThirst = this.thirstLevels.getOrDefault(playerId, 20);
        int gained = newThirst - currentThirst;
        if (gained > 0) {
            ActionBarManager.send(player, "<aqua>+<gray>" + gained + "</gray> Thirst</aqua> <gray>(Purified)</gray>");
        }
    }

    private void checkWaterPurification(Player player) {
        CustomItem purifiedWater;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() != Material.POTION) {
            return;
        }
        double heat = ItemHeatSystem.getItemHeat(item);
        if (heat < 100.0) {
            return;
        }
        PotionMeta meta = (PotionMeta)item.getItemMeta();
        if (meta != null && !meta.hasCustomEffect(PotionEffectType.REGENERATION) && (purifiedWater = Atom.getInstance().getItemRegistry().getItem("purified_water")) != null) {
            ItemStack newItem = purifiedWater.create();
            ItemHeatSystem.setItemHeat(newItem, heat);
            player.getInventory().setItemInMainHand(newItem);
        }
    }

    private void updateThirstDisplay(Player player) {
        int thirst = this.thirstLevels.getOrDefault(player.getUniqueId(), 20);
        String color = thirst <= 0 ? "<dark_red>" : (thirst <= 5 ? "<red>" : (thirst <= 10 ? "<gold>" : (thirst <= 15 ? "<yellow>" : "<aqua>")));
        String message = color + thirst + "<dark_gray>/<gray>20";
        ActionBarManager.getInstance().setMessage(player, "thirst", message);
    }

    public void addThirst(Player player, int amount) {
        UUID playerId = player.getUniqueId();
        int currentThirst = this.thirstLevels.getOrDefault(playerId, 20);
        int newThirst = Math.min(currentThirst + amount, 20);
        this.thirstLevels.put(playerId, newThirst);
        this.updateThirstDisplay(player);
    }

    public int getThirst(Player player) {
        return this.thirstLevels.getOrDefault(player.getUniqueId(), 20);
    }

    @Generated
    public static ThirstSystem getInstance() {
        return instance;
    }
}

