/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.systems.groundstorage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.core.data.PersistentData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\nJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\nJ(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\bJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010\u001f\u001a\u00020\u001cJ*\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\"J\u001a\u0010#\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fJ\u0016\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010&\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\"\u0010'\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\b2\b\u0010(\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010)\u001a\u00020\u001cJ\"\u0010*\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u00142\b\b\u0002\u0010)\u001a\u00020\u001cJ\u001a\u0010+\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\b2\b\b\u0002\u0010)\u001a\u00020\u001cJ0\u0010,\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\b2\u0016\u0010-\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00140.2\b\b\u0002\u0010)\u001a\u00020\u001cJ \u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\b\b\u0002\u0010)\u001a\u00020\u001cJ\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\nJ\u0018\u00103\u001a\u00020%2\u0006\u0010\u0011\u001a\u00020\n2\b\b\u0002\u0010\u001f\u001a\u00020\u001cJ\u0015\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u00108\u001a\u00020%J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/shotrush/atom/content/systems/groundstorage/GroundItemDisplayUtils;", "", "<init>", "()V", "GROUND_ITEM_KEY", "", "findGroundItemsInRadius", "", "Lorg/bukkit/entity/ItemDisplay;", "center", "Lorg/bukkit/Location;", "radius", "", "findGroundItemsAbove", "block", "Lorg/bukkit/block/Block;", "findGroundItemsBelow", "location", "findGroundItemsOnBlock", "isObstructed", "Lorg/bukkit/inventory/ItemStack;", "display", "vanilla", "Lorg/bukkit/Material;", "customKey", "Lnet/momirealms/craftengine/core/util/Key;", "getGroundItem", "isGroundItem", "", "removeGroundItem", "", "dropNaturally", "findGroundItemsWithMaterials", "materials", "", "findClosestGroundItem", "countGroundItems", "", "hasGroundItemsInRadius", "setGroundItem", "newItem", "playSound", "replaceGroundItem", "clearGroundItem", "transformGroundItem", "transform", "Lkotlin/Function1;", "swapGroundItems", "display1", "display2", "getGroundItemsInChunk", "clearGroundItemsInChunk", "getSpawnTime", "", "(Lorg/bukkit/entity/ItemDisplay;)Ljava/lang/Long;", "shouldDespawn", "maxAgeMinutes", "findAllGroundItems", "Atom"})
@SourceDebugExtension(value={"SMAP\nGroundItemDisplayUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroundItemDisplayUtils.kt\norg/shotrush/atom/content/systems/groundstorage/GroundItemDisplayUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,352:1\n808#2,11:353\n774#2:364\n865#2,2:365\n774#2:367\n865#2,2:368\n774#2:370\n865#2,2:371\n774#2:373\n865#2,2:374\n774#2:376\n865#2,2:377\n2423#2,14:379\n774#2:405\n865#2,2:406\n1869#2,2:408\n1#3:393\n4225#4,11:394\n*S KotlinDebug\n*F\n+ 1 GroundItemDisplayUtils.kt\norg/shotrush/atom/content/systems/groundstorage/GroundItemDisplayUtils\n*L\n31#1:353,11\n32#1:364\n32#1:365,2\n45#1:367\n45#1:368,2\n59#1:370\n59#1:371,2\n77#1:373\n77#1:374,2\n160#1:376\n160#1:377,2\n174#1:379,14\n299#1:405\n299#1:406,2\n310#1:408,2\n298#1:394,11\n*E\n"})
public final class GroundItemDisplayUtils {
    @NotNull
    public static final GroundItemDisplayUtils INSTANCE = new GroundItemDisplayUtils();
    @NotNull
    private static final String GROUND_ITEM_KEY = "ground_item_display";

    private GroundItemDisplayUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> findGroundItemsInRadius(@NotNull Location center, double radius) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Collection collection = center.getWorld().getNearbyEntities(center, radius, radius, radius);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
        Iterable iterable = collection;
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ItemDisplay)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            if (!PersistentData.isFlagged((PersistentDataHolder)display, GROUND_ITEM_KEY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List findGroundItemsInRadius$default(GroundItemDisplayUtils groundItemDisplayUtils, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.5;
        }
        return groundItemDisplayUtils.findGroundItemsInRadius(location, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> findGroundItemsAbove(@NotNull Block block) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(block, "block");
        Location location = block.getLocation().add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location searchLocation = location;
        Iterable $this$filter$iv = this.findGroundItemsInRadius(searchLocation, 1.0);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Block displayBlock;
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(display.getLocation().getBlock(), "getBlock(...)");
            if (!(displayBlock.getX() == block.getX() && displayBlock.getZ() == block.getZ() && displayBlock.getY() >= block.getY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> findGroundItemsBelow(@NotNull Location location) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(location, "location");
        Location location2 = location.clone().add(0.0, -0.5, 0.0);
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        Location searchLocation = location2;
        Iterable $this$filter$iv = this.findGroundItemsInRadius(searchLocation, 1.0);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Block targetBlock;
            Block displayBlock;
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(display.getLocation().getBlock(), "getBlock(...)");
            Intrinsics.checkNotNullExpressionValue(location.getBlock(), "getBlock(...)");
            if (!(displayBlock.getX() == targetBlock.getX() && displayBlock.getZ() == targetBlock.getZ() && displayBlock.getY() <= targetBlock.getY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> findGroundItemsOnBlock(@NotNull Location location) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(location, "location");
        Location location2 = location.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Location blockLocation = location2;
        Location location3 = blockLocation.add(0.5, 0.5, 0.5);
        Intrinsics.checkNotNullExpressionValue(location3, "add(...)");
        Location searchLocation = location3;
        Iterable iterable = this.findGroundItemsInRadius(searchLocation, 1.0);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location displayBlock;
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(display.getLocation().getBlock().getLocation(), "getLocation(...)");
            if (!(displayBlock.getBlockX() == blockLocation.getBlockX() && displayBlock.getBlockZ() == blockLocation.getBlockZ() && displayBlock.getBlockY() >= blockLocation.getBlockY())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ItemStack isObstructed(@NotNull ItemDisplay display, @Nullable Material vanilla, @Nullable Key customKey) {
        Holder owner;
        ImmutableBlockState customState;
        Intrinsics.checkNotNullParameter(display, "display");
        Block block = display.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (vanilla != null && block2.getType() == vanilla) {
            return this.getGroundItem(display);
        }
        if (customKey != null && (customState = CraftEngineBlocks.getCustomBlockState((Block)block2)) != null && (owner = customState.owner()).matchesKey(customKey)) {
            return this.getGroundItem(display);
        }
        return null;
    }

    public static /* synthetic */ ItemStack isObstructed$default(GroundItemDisplayUtils groundItemDisplayUtils, ItemDisplay itemDisplay, Material material, Key key, int n, Object object) {
        if ((n & 2) != 0) {
            material = null;
        }
        if ((n & 4) != 0) {
            key = null;
        }
        return groundItemDisplayUtils.isObstructed(itemDisplay, material, key);
    }

    @Nullable
    public final ItemStack getGroundItem(@NotNull ItemDisplay display) {
        Intrinsics.checkNotNullParameter(display, "display");
        ItemStack itemStack = display.getItemStack();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemStack(...)");
        ItemStack item = itemStack;
        return item.getType() != Material.AIR ? item : null;
    }

    public final boolean isGroundItem(@NotNull ItemDisplay display) {
        Intrinsics.checkNotNullParameter(display, "display");
        return PersistentData.isFlagged((PersistentDataHolder)display, GROUND_ITEM_KEY);
    }

    public final void removeGroundItem(@NotNull ItemDisplay display, boolean dropNaturally) {
        Intrinsics.checkNotNullParameter(display, "display");
        ItemStack item = this.getGroundItem(display);
        if (item != null) {
            Item item2 = dropNaturally ? display.getWorld().dropItemNaturally(display.getLocation(), item) : display.getWorld().dropItem(display.getLocation(), item);
        }
        display.remove();
    }

    public static /* synthetic */ void removeGroundItem$default(GroundItemDisplayUtils groundItemDisplayUtils, ItemDisplay itemDisplay, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        groundItemDisplayUtils.removeGroundItem(itemDisplay, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> findGroundItemsWithMaterials(@NotNull Location center, double radius, @NotNull Set<? extends Material> materials) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(materials, "materials");
        Iterable iterable = this.findGroundItemsInRadius(center, radius);
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            ItemStack item = INSTANCE.getGroundItem(display);
            if (!(item != null && materials.contains(item.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ItemDisplay findClosestGroundItem(@NotNull Location center, double radius) {
        Object v0;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Iterable iterable = this.findGroundItemsInRadius(center, radius);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                ItemDisplay display = (ItemDisplay)minElem$iv;
                boolean bl = false;
                double minValue$iv = display.getLocation().distance(center);
                do {
                    Object e$iv = iterator$iv.next();
                    ItemDisplay display2 = (ItemDisplay)e$iv;
                    $i$a$-minByOrNull-GroundItemDisplayUtils$findClosestGroundItem$1 = false;
                    double v$iv = display2.getLocation().distance(center);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public static /* synthetic */ ItemDisplay findClosestGroundItem$default(GroundItemDisplayUtils groundItemDisplayUtils, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.5;
        }
        return groundItemDisplayUtils.findClosestGroundItem(location, d);
    }

    public final int countGroundItems(@NotNull Location center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return this.findGroundItemsInRadius(center, radius).size();
    }

    public final boolean hasGroundItemsInRadius(@NotNull Location center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return !((Collection)this.findGroundItemsInRadius(center, radius)).isEmpty();
    }

    public final boolean setGroundItem(@NotNull ItemDisplay display, @Nullable ItemStack newItem, boolean playSound) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter(display, "display");
        if (!this.isGroundItem(display)) {
            return false;
        }
        if (newItem == null) {
            itemStack = new ItemStack(Material.AIR);
        } else if (newItem.getType() == Material.AIR) {
            itemStack = new ItemStack(Material.AIR);
        } else {
            ItemStack itemStack2;
            ItemStack $this$setGroundItem_u24lambda_u240 = itemStack2 = newItem.clone();
            boolean bl = false;
            $this$setGroundItem_u24lambda_u240.setAmount(1);
            ItemStack itemStack3 = itemStack2;
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue(itemStack3, "apply(...)");
        }
        ItemStack itemToSet = itemStack;
        display.setItemStack(itemToSet);
        if (playSound && itemToSet.getType() != Material.AIR) {
            display.getWorld().playSound(display.getLocation(), Sound.ENTITY_ITEM_FRAME_ADD_ITEM, 0.5f, 1.0f);
        }
        return true;
    }

    public static /* synthetic */ boolean setGroundItem$default(GroundItemDisplayUtils groundItemDisplayUtils, ItemDisplay itemDisplay, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemDisplayUtils.setGroundItem(itemDisplay, itemStack, bl);
    }

    @Nullable
    public final ItemStack replaceGroundItem(@NotNull ItemDisplay display, @NotNull ItemStack newItem, boolean playSound) {
        Intrinsics.checkNotNullParameter(display, "display");
        Intrinsics.checkNotNullParameter(newItem, "newItem");
        if (!this.isGroundItem(display)) {
            return null;
        }
        ItemStack previousItem = this.getGroundItem(display);
        this.setGroundItem(display, newItem, playSound);
        return previousItem;
    }

    public static /* synthetic */ ItemStack replaceGroundItem$default(GroundItemDisplayUtils groundItemDisplayUtils, ItemDisplay itemDisplay, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemDisplayUtils.replaceGroundItem(itemDisplay, itemStack, bl);
    }

    @Nullable
    public final ItemStack clearGroundItem(@NotNull ItemDisplay display, boolean playSound) {
        Intrinsics.checkNotNullParameter(display, "display");
        if (!this.isGroundItem(display)) {
            return null;
        }
        ItemStack previousItem = this.getGroundItem(display);
        display.setItemStack(new ItemStack(Material.AIR));
        if (playSound) {
            display.getWorld().playSound(display.getLocation(), Sound.ENTITY_ITEM_FRAME_REMOVE_ITEM, 0.5f, 1.0f);
        }
        return previousItem;
    }

    public static /* synthetic */ ItemStack clearGroundItem$default(GroundItemDisplayUtils groundItemDisplayUtils, ItemDisplay itemDisplay, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return groundItemDisplayUtils.clearGroundItem(itemDisplay, bl);
    }

    public final boolean transformGroundItem(@NotNull ItemDisplay display, @NotNull Function1<? super ItemStack, ? extends ItemStack> transform2, boolean playSound) {
        Intrinsics.checkNotNullParameter(display, "display");
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (!this.isGroundItem(display)) {
            return false;
        }
        ItemStack currentItem = this.getGroundItem(display);
        ItemStack newItem = transform2.invoke((ItemStack)currentItem);
        this.setGroundItem(display, newItem, playSound);
        return true;
    }

    public static /* synthetic */ boolean transformGroundItem$default(GroundItemDisplayUtils groundItemDisplayUtils, ItemDisplay itemDisplay, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemDisplayUtils.transformGroundItem(itemDisplay, function1, bl);
    }

    public final boolean swapGroundItems(@NotNull ItemDisplay display1, @NotNull ItemDisplay display2, boolean playSound) {
        Intrinsics.checkNotNullParameter(display1, "display1");
        Intrinsics.checkNotNullParameter(display2, "display2");
        if (!this.isGroundItem(display1) || !this.isGroundItem(display2)) {
            return false;
        }
        ItemStack item1 = this.getGroundItem(display1);
        ItemStack item2 = this.getGroundItem(display2);
        this.setGroundItem(display1, item2, playSound);
        this.setGroundItem(display2, item1, playSound);
        return true;
    }

    public static /* synthetic */ boolean swapGroundItems$default(GroundItemDisplayUtils groundItemDisplayUtils, ItemDisplay itemDisplay, ItemDisplay itemDisplay2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemDisplayUtils.swapGroundItems(itemDisplay, itemDisplay2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> getGroundItemsInChunk(@NotNull Location location) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter(location, "location");
        Chunk chunk = location.getChunk();
        Intrinsics.checkNotNullExpressionValue(chunk, "getChunk(...)");
        Chunk chunk2 = chunk;
        Entity[] entityArray = chunk2.getEntities();
        Intrinsics.checkNotNullExpressionValue(entityArray, "getEntities(...)");
        Object[] $this$filterIsInstance$iv = entityArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ItemDisplay)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isGroundItem(display)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final int clearGroundItemsInChunk(@NotNull Location location, boolean dropNaturally) {
        Intrinsics.checkNotNullParameter(location, "location");
        List<ItemDisplay> items = this.getGroundItemsInChunk(location);
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemDisplay display = (ItemDisplay)element$iv;
            boolean bl = false;
            INSTANCE.removeGroundItem(display, dropNaturally);
        }
        return items.size();
    }

    public static /* synthetic */ int clearGroundItemsInChunk$default(GroundItemDisplayUtils groundItemDisplayUtils, Location location, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return groundItemDisplayUtils.clearGroundItemsInChunk(location, bl);
    }

    @Nullable
    public final Long getSpawnTime(@NotNull ItemDisplay display) {
        Long l;
        Intrinsics.checkNotNullParameter(display, "display");
        if (this.isGroundItem(display)) {
            Object object = display.getWorld();
            if (object == null || (object = object.getName()) == null) {
                return null;
            }
            l = (Long)display.getPersistentDataContainer().get(new NamespacedKey((String)object, "spawn_time"), PersistentDataType.LONG);
        } else {
            l = null;
        }
        return l;
    }

    public final boolean shouldDespawn(@NotNull ItemDisplay display, int maxAgeMinutes) {
        Intrinsics.checkNotNullParameter(display, "display");
        Long l = this.getSpawnTime(display);
        if (l == null) {
            return false;
        }
        long spawnTime = l;
        long ageMinutes = (System.currentTimeMillis() - spawnTime) / (long)60000;
        return ageMinutes >= (long)maxAgeMinutes;
    }

    @NotNull
    public final List<ItemDisplay> findAllGroundItems(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.findGroundItemsOnBlock(location);
    }
}

