/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.systems.groundstorage;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.ItemFrame;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.data.PersistentData;

@RegisterSystem(id="ground_item_frame_handler", priority=15, toggleable=true, description="Place items on ground with random rotation [DEPRECATED - Use GroundItemDisplayHandler]", enabledByDefault=false)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/shotrush/atom/content/systems/groundstorage/GroundItemFrameHandler;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "onFrameBreak", "", "event", "Lorg/bukkit/event/hanging/HangingBreakEvent;", "onFrameDamage", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onFrameInteract", "Lorg/bukkit/event/player/PlayerInteractEntityEvent;", "isGroundItem", "", "frame", "Lorg/bukkit/entity/ItemFrame;", "dropItem", "Companion", "Atom"})
public final class GroundItemFrameHandler
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Plugin plugin;
    @NotNull
    private static final String GROUND_ITEM_KEY = "ground_item_frame";

    public GroundItemFrameHandler(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
    }

    @EventHandler
    public final void onFrameBreak(@NotNull HangingBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Hanging hanging = event.getEntity();
        ItemFrame itemFrame = hanging instanceof ItemFrame ? (ItemFrame)hanging : null;
        if (itemFrame == null) {
            return;
        }
        ItemFrame frame = itemFrame;
        if (!this.isGroundItem(frame)) {
            return;
        }
        if (event.getCause() == HangingBreakEvent.RemoveCause.OBSTRUCTION) {
            event.setCancelled(true);
            return;
        }
        this.dropItem(frame);
        event.setCancelled(true);
        frame.remove();
    }

    @EventHandler
    public final void onFrameDamage(@NotNull EntityDamageByEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getEntity();
        ItemFrame itemFrame = entity instanceof ItemFrame ? (ItemFrame)entity : null;
        if (itemFrame == null) {
            return;
        }
        ItemFrame frame = itemFrame;
        if (!this.isGroundItem(frame)) {
            return;
        }
        this.dropItem(frame);
        event.setCancelled(true);
        frame.remove();
    }

    @EventHandler
    public final void onFrameInteract(@NotNull PlayerInteractEntityEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Entity entity = event.getRightClicked();
        ItemFrame itemFrame = entity instanceof ItemFrame ? (ItemFrame)entity : null;
        if (itemFrame == null) {
            return;
        }
        ItemFrame frame = itemFrame;
        if (!this.isGroundItem(frame)) {
            return;
        }
        event.setCancelled(true);
    }

    private final boolean isGroundItem(ItemFrame frame) {
        return PersistentData.isFlagged((PersistentDataHolder)frame, GROUND_ITEM_KEY);
    }

    private final void dropItem(ItemFrame frame) {
        ItemStack itemStack = frame.getItem();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItem(...)");
        ItemStack item = itemStack;
        if (item.getType() != Material.AIR) {
            frame.getWorld().dropItemNaturally(frame.getLocation(), item);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/shotrush/atom/content/systems/groundstorage/GroundItemFrameHandler$Companion;", "", "<init>", "()V", "GROUND_ITEM_KEY", "", "Atom"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

