/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.systems.groundstorage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.registry.Holder;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.core.data.PersistentData;

@Deprecated(message="Use GroundItemDisplayUtils instead for ItemDisplay-based ground items", replaceWith=@ReplaceWith(expression="GroundItemDisplayUtils", imports={"org.shotrush.atom.content.systems.groundstorage.GroundItemDisplayUtils"}))
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\t2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001b\u001a\u00020\u000bJ\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001b\u001a\u00020\u000bJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010#\u001a\u00020\u001fJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u000f2\b\b\u0002\u0010#\u001a\u00020\u001fJ*\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&J\u001a\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0016\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010*\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u001b\u001a\u00020\u000bJ\"\u0010,\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\t2\b\u0010-\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010.\u001a\u00020\u001fJ\"\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u00142\b\b\u0002\u0010.\u001a\u00020\u001fJ\u001a\u00100\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010.\u001a\u00020\u001fJ*\u00101\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00170&J\u001a\u00102\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u000fJ\"\u0010,\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000f2\b\u0010-\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010.\u001a\u00020\u001fJ0\u00103\u001a\u00020\u001f2\u0006\u0010\u0015\u001a\u00020\t2\u0016\u00104\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0014052\b\b\u0002\u0010.\u001a\u00020\u001fJ \u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\b\b\u0002\u0010.\u001a\u00020\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/shotrush/atom/content/systems/groundstorage/GroundItemUtils;", "", "<init>", "()V", "GROUND_ITEM_KEY", "", "GROUND_ITEM_DISPLAY_KEY", "findGroundItemsInRadius", "", "Lorg/bukkit/entity/ItemFrame;", "center", "Lorg/bukkit/Location;", "radius", "", "findGroundItemDisplaysInRadius", "Lorg/bukkit/entity/ItemDisplay;", "findGroundItemAbove", "block", "Lorg/bukkit/block/Block;", "isObstructed", "Lorg/bukkit/inventory/ItemStack;", "frame", "vanilla", "Lorg/bukkit/Material;", "customKey", "Lnet/momirealms/craftengine/core/util/Key;", "findGroundItemBelow", "location", "findGroundItemsOnBlock", "getGroundItem", "isGroundItem", "", "display", "removeGroundItem", "", "dropNaturally", "findGroundItemsWithMaterials", "materials", "", "findClosestGroundItem", "countGroundItems", "", "hasGroundItemsInRadius", "findAllGroundItems", "setGroundItem", "newItem", "playSound", "replaceGroundItem", "clearGroundItem", "findGroundItemDisplaysWithMaterials", "findClosestGroundItemDisplay", "transformGroundItem", "transform", "Lkotlin/Function1;", "swapGroundItems", "frame1", "frame2", "Atom"})
@SourceDebugExtension(value={"SMAP\nGroundItemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroundItemUtils.kt\norg/shotrush/atom/content/systems/groundstorage/GroundItemUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n808#2,11:380\n774#2:391\n865#2,2:392\n808#2,11:394\n774#2:405\n865#2,2:406\n774#2:408\n865#2,2:409\n774#2:411\n865#2,2:412\n2423#2,14:414\n774#2:429\n865#2,2:430\n2423#2,14:432\n1#3:428\n*S KotlinDebug\n*F\n+ 1 GroundItemUtils.kt\norg/shotrush/atom/content/systems/groundstorage/GroundItemUtils\n*L\n35#1:380,11\n36#1:391\n36#1:392,2\n49#1:394,11\n50#1:405\n50#1:406,2\n102#1:408\n102#1:409,2\n185#1:411\n185#1:412,2\n199#1:414,14\n293#1:429\n293#1:430,2\n307#1:432,14\n*E\n"})
public final class GroundItemUtils {
    @NotNull
    public static final GroundItemUtils INSTANCE = new GroundItemUtils();
    @NotNull
    private static final String GROUND_ITEM_KEY = "ground_item_frame";
    @NotNull
    private static final String GROUND_ITEM_DISPLAY_KEY = "ground_item_display";

    private GroundItemUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemFrame> findGroundItemsInRadius(@NotNull Location center, double radius) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Collection collection = center.getWorld().getNearbyEntities(center, radius, radius, radius);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
        Iterable iterable = collection;
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ItemFrame)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemFrame frame = (ItemFrame)element$iv$iv;
            boolean bl = false;
            if (!PersistentData.isFlagged((PersistentDataHolder)frame, GROUND_ITEM_KEY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List findGroundItemsInRadius$default(GroundItemUtils groundItemUtils, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.6;
        }
        return groundItemUtils.findGroundItemsInRadius(location, d);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> findGroundItemDisplaysInRadius(@NotNull Location center, double radius) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Collection collection = center.getWorld().getNearbyEntities(center, radius, radius, radius);
        Intrinsics.checkNotNullExpressionValue(collection, "getNearbyEntities(...)");
        Iterable iterable = collection;
        boolean $i$f$filterIsInstance = false;
        void var6_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ItemDisplay)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            if (!PersistentData.isFlagged((PersistentDataHolder)display, GROUND_ITEM_DISPLAY_KEY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List findGroundItemDisplaysInRadius$default(GroundItemUtils groundItemUtils, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.5;
        }
        return groundItemUtils.findGroundItemDisplaysInRadius(location, d);
    }

    @Nullable
    public final ItemFrame findGroundItemAbove(@NotNull Block block) {
        Intrinsics.checkNotNullParameter(block, "block");
        Location location = block.getLocation().add(0.5, 1.0, 0.5);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location searchLocation = location;
        return CollectionsKt.firstOrNull(this.findGroundItemsInRadius(searchLocation, 0.6));
    }

    @Nullable
    public final ItemStack isObstructed(@NotNull ItemFrame frame, @Nullable Material vanilla, @Nullable Key customKey) {
        Holder owner;
        ImmutableBlockState customState;
        Intrinsics.checkNotNullParameter(frame, "frame");
        Block block = frame.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        if (vanilla != null && block2.getType() == vanilla) {
            return this.getGroundItem(frame);
        }
        if (customKey != null && (customState = CraftEngineBlocks.getCustomBlockState((Block)block2)) != null && (owner = customState.owner()).matchesKey(customKey)) {
            return this.getGroundItem(frame);
        }
        return null;
    }

    public static /* synthetic */ ItemStack isObstructed$default(GroundItemUtils groundItemUtils, ItemFrame itemFrame, Material material, Key key, int n, Object object) {
        if ((n & 2) != 0) {
            material = null;
        }
        if ((n & 4) != 0) {
            key = null;
        }
        return groundItemUtils.isObstructed(itemFrame, material, key);
    }

    @Nullable
    public final ItemFrame findGroundItemBelow(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        Location location2 = location.clone().add(0.0, -1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
        Location searchLocation = location2;
        return CollectionsKt.firstOrNull(this.findGroundItemsInRadius(searchLocation, 0.6));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemFrame> findGroundItemsOnBlock(@NotNull Location location) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(location, "location");
        Location location2 = location.getBlock().getLocation();
        Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
        Location blockLocation = location2;
        Location location3 = blockLocation.add(0.5, 1.0, 0.5);
        Intrinsics.checkNotNullExpressionValue(location3, "add(...)");
        Iterable $this$filter$iv = this.findGroundItemsInRadius(location3, 0.8);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Location frameBlock;
            ItemFrame frame = (ItemFrame)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(frame.getLocation().getBlock().getLocation(), "getLocation(...)");
            if (!(frameBlock.getBlockX() == blockLocation.getBlockX() && frameBlock.getBlockZ() == blockLocation.getBlockZ() && frameBlock.getBlockY() == blockLocation.getBlockY() + 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ItemStack getGroundItem(@NotNull ItemFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        ItemStack itemStack = frame.getItem();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItem(...)");
        ItemStack item = itemStack;
        return item.getType() != Material.AIR ? item : null;
    }

    public final boolean isGroundItem(@NotNull ItemFrame frame) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        return PersistentData.isFlagged((PersistentDataHolder)frame, GROUND_ITEM_KEY);
    }

    public final boolean isGroundItem(@NotNull ItemDisplay display) {
        Intrinsics.checkNotNullParameter(display, "display");
        return PersistentData.isFlagged((PersistentDataHolder)display, GROUND_ITEM_DISPLAY_KEY);
    }

    public final void removeGroundItem(@NotNull ItemFrame frame, boolean dropNaturally) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        ItemStack item = this.getGroundItem(frame);
        if (item != null) {
            Item item2 = dropNaturally ? frame.getWorld().dropItemNaturally(frame.getLocation(), item) : frame.getWorld().dropItem(frame.getLocation(), item);
        }
        frame.remove();
    }

    public static /* synthetic */ void removeGroundItem$default(GroundItemUtils groundItemUtils, ItemFrame itemFrame, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        groundItemUtils.removeGroundItem(itemFrame, bl);
    }

    public final void removeGroundItem(@NotNull ItemDisplay display, boolean dropNaturally) {
        Intrinsics.checkNotNullParameter(display, "display");
        ItemStack item = this.getGroundItem(display);
        if (item != null) {
            Item item2 = dropNaturally ? display.getWorld().dropItemNaturally(display.getLocation(), item) : display.getWorld().dropItem(display.getLocation(), item);
        }
        display.remove();
    }

    public static /* synthetic */ void removeGroundItem$default(GroundItemUtils groundItemUtils, ItemDisplay itemDisplay, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        groundItemUtils.removeGroundItem(itemDisplay, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemFrame> findGroundItemsWithMaterials(@NotNull Location center, double radius, @NotNull Set<? extends Material> materials) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(materials, "materials");
        Iterable iterable = this.findGroundItemsInRadius(center, radius);
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemFrame frame = (ItemFrame)element$iv$iv;
            boolean bl = false;
            ItemStack item = INSTANCE.getGroundItem(frame);
            if (!(item != null && materials.contains(item.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ItemFrame findClosestGroundItem(@NotNull Location center, double radius) {
        Object v0;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Iterable iterable = this.findGroundItemsInRadius(center, radius);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                ItemFrame frame = (ItemFrame)minElem$iv;
                boolean bl = false;
                double minValue$iv = frame.getLocation().distance(center);
                do {
                    Object e$iv = iterator$iv.next();
                    ItemFrame frame2 = (ItemFrame)e$iv;
                    $i$a$-minByOrNull-GroundItemUtils$findClosestGroundItem$1 = false;
                    double v$iv = frame2.getLocation().distance(center);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public static /* synthetic */ ItemFrame findClosestGroundItem$default(GroundItemUtils groundItemUtils, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.6;
        }
        return groundItemUtils.findClosestGroundItem(location, d);
    }

    public final int countGroundItems(@NotNull Location center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return this.findGroundItemsInRadius(center, radius).size();
    }

    public final boolean hasGroundItemsInRadius(@NotNull Location center, double radius) {
        Intrinsics.checkNotNullParameter(center, "center");
        return !((Collection)this.findGroundItemsInRadius(center, radius)).isEmpty();
    }

    @NotNull
    public final List<ItemFrame> findAllGroundItems(@NotNull Location location) {
        Intrinsics.checkNotNullParameter(location, "location");
        return this.findGroundItemsOnBlock(location);
    }

    public final boolean setGroundItem(@NotNull ItemFrame frame, @Nullable ItemStack newItem, boolean playSound) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter(frame, "frame");
        if (!this.isGroundItem(frame)) {
            return false;
        }
        if (newItem == null) {
            itemStack = new ItemStack(Material.AIR);
        } else if (newItem.getType() == Material.AIR) {
            itemStack = new ItemStack(Material.AIR);
        } else {
            ItemStack itemStack2;
            ItemStack $this$setGroundItem_u24lambda_u240 = itemStack2 = newItem.clone();
            boolean bl = false;
            $this$setGroundItem_u24lambda_u240.setAmount(1);
            ItemStack itemStack3 = itemStack2;
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue(itemStack3, "apply(...)");
        }
        ItemStack itemToSet = itemStack;
        frame.setItem(itemToSet, playSound);
        return true;
    }

    public static /* synthetic */ boolean setGroundItem$default(GroundItemUtils groundItemUtils, ItemFrame itemFrame, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemUtils.setGroundItem(itemFrame, itemStack, bl);
    }

    @Nullable
    public final ItemStack replaceGroundItem(@NotNull ItemFrame frame, @NotNull ItemStack newItem, boolean playSound) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(newItem, "newItem");
        if (!this.isGroundItem(frame)) {
            return null;
        }
        ItemStack previousItem = this.getGroundItem(frame);
        this.setGroundItem(frame, newItem, playSound);
        return previousItem;
    }

    public static /* synthetic */ ItemStack replaceGroundItem$default(GroundItemUtils groundItemUtils, ItemFrame itemFrame, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemUtils.replaceGroundItem(itemFrame, itemStack, bl);
    }

    @Nullable
    public final ItemStack clearGroundItem(@NotNull ItemFrame frame, boolean playSound) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        if (!this.isGroundItem(frame)) {
            return null;
        }
        ItemStack previousItem = this.getGroundItem(frame);
        frame.setItem(new ItemStack(Material.AIR), playSound);
        return previousItem;
    }

    public static /* synthetic */ ItemStack clearGroundItem$default(GroundItemUtils groundItemUtils, ItemFrame itemFrame, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return groundItemUtils.clearGroundItem(itemFrame, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemDisplay> findGroundItemDisplaysWithMaterials(@NotNull Location center, double radius, @NotNull Set<? extends Material> materials) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Intrinsics.checkNotNullParameter(materials, "materials");
        Iterable iterable = this.findGroundItemDisplaysInRadius(center, radius);
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ItemDisplay display = (ItemDisplay)element$iv$iv;
            boolean bl = false;
            ItemStack item = INSTANCE.getGroundItem(display);
            if (!(item != null && materials.contains(item.getType()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ItemDisplay findClosestGroundItemDisplay(@NotNull Location center, double radius) {
        Object v0;
        void $this$minByOrNull$iv;
        Intrinsics.checkNotNullParameter(center, "center");
        Iterable iterable = this.findGroundItemDisplaysInRadius(center, radius);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                ItemDisplay display = (ItemDisplay)minElem$iv;
                boolean bl = false;
                double minValue$iv = display.getLocation().distance(center);
                do {
                    Object e$iv = iterator$iv.next();
                    ItemDisplay display2 = (ItemDisplay)e$iv;
                    $i$a$-minByOrNull-GroundItemUtils$findClosestGroundItemDisplay$1 = false;
                    double v$iv = display2.getLocation().distance(center);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    public static /* synthetic */ ItemDisplay findClosestGroundItemDisplay$default(GroundItemUtils groundItemUtils, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.5;
        }
        return groundItemUtils.findClosestGroundItemDisplay(location, d);
    }

    @Nullable
    public final ItemStack getGroundItem(@NotNull ItemDisplay display) {
        Intrinsics.checkNotNullParameter(display, "display");
        ItemStack itemStack = display.getItemStack();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemStack(...)");
        ItemStack item = itemStack;
        return item.getType() != Material.AIR ? item : null;
    }

    public final boolean setGroundItem(@NotNull ItemDisplay display, @Nullable ItemStack newItem, boolean playSound) {
        ItemStack itemStack;
        Intrinsics.checkNotNullParameter(display, "display");
        if (!this.isGroundItem(display)) {
            return false;
        }
        if (newItem == null) {
            itemStack = new ItemStack(Material.AIR);
        } else if (newItem.getType() == Material.AIR) {
            itemStack = new ItemStack(Material.AIR);
        } else {
            ItemStack itemStack2;
            ItemStack $this$setGroundItem_u24lambda_u241 = itemStack2 = newItem.clone();
            boolean bl = false;
            $this$setGroundItem_u24lambda_u241.setAmount(1);
            ItemStack itemStack3 = itemStack2;
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue(itemStack3, "apply(...)");
        }
        ItemStack itemToSet = itemStack;
        display.setItemStack(itemToSet);
        if (playSound && itemToSet.getType() != Material.AIR) {
            display.getWorld().playSound(display.getLocation(), Sound.ENTITY_ITEM_FRAME_ADD_ITEM, 0.5f, 1.0f);
        }
        return true;
    }

    public static /* synthetic */ boolean setGroundItem$default(GroundItemUtils groundItemUtils, ItemDisplay itemDisplay, ItemStack itemStack, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemUtils.setGroundItem(itemDisplay, itemStack, bl);
    }

    public final boolean transformGroundItem(@NotNull ItemFrame frame, @NotNull Function1<? super ItemStack, ? extends ItemStack> transform2, boolean playSound) {
        Intrinsics.checkNotNullParameter(frame, "frame");
        Intrinsics.checkNotNullParameter(transform2, "transform");
        if (!this.isGroundItem(frame)) {
            return false;
        }
        ItemStack currentItem = this.getGroundItem(frame);
        ItemStack newItem = transform2.invoke((ItemStack)currentItem);
        this.setGroundItem(frame, newItem, playSound);
        return true;
    }

    public static /* synthetic */ boolean transformGroundItem$default(GroundItemUtils groundItemUtils, ItemFrame itemFrame, Function1 function1, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemUtils.transformGroundItem(itemFrame, function1, bl);
    }

    public final boolean swapGroundItems(@NotNull ItemFrame frame1, @NotNull ItemFrame frame2, boolean playSound) {
        Intrinsics.checkNotNullParameter(frame1, "frame1");
        Intrinsics.checkNotNullParameter(frame2, "frame2");
        if (!this.isGroundItem(frame1) || !this.isGroundItem(frame2)) {
            return false;
        }
        ItemStack item1 = this.getGroundItem(frame1);
        ItemStack item2 = this.getGroundItem(frame2);
        this.setGroundItem(frame1, item2, playSound);
        this.setGroundItem(frame2, item1, playSound);
        return true;
    }

    public static /* synthetic */ boolean swapGroundItems$default(GroundItemUtils groundItemUtils, ItemFrame itemFrame, ItemFrame itemFrame2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return groundItemUtils.swapGroundItems(itemFrame, itemFrame2, bl);
    }
}

