/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.BlockPos;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.shotrush.atom.content.workstation.core.PlacedItem;
import org.shotrush.atom.content.workstation.core.WorkstationDataManager;
import org.shotrush.atom.core.api.annotation.RegisterSystem;

@RegisterSystem(id="workstation_block_listener", priority=5, toggleable=false, description="Handles workstation block break events and cleanup")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/shotrush/atom/content/workstation/WorkstationBlockListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "onBlockBreak", "", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "getWorkstationType", "", "block", "Lorg/bukkit/block/Block;", "cleanupNearbyEntities", "location", "Lorg/bukkit/Location;", "radius", "", "Companion", "Atom"})
@SourceDebugExtension(value={"SMAP\nWorkstationBlockListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkstationBlockListener.kt\norg/shotrush/atom/content/workstation/WorkstationBlockListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1869#2,2:116\n1869#2,2:118\n*S KotlinDebug\n*F\n+ 1 WorkstationBlockListener.kt\norg/shotrush/atom/content/workstation/WorkstationBlockListener\n*L\n57#1:116,2\n95#1:118,2\n*E\n"})
public final class WorkstationBlockListener
implements Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Plugin plugin;
    @NotNull
    private static final Set<String> WORKSTATION_TYPES;

    public WorkstationBlockListener(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void onBlockBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        String string = this.getWorkstationType(block2);
        if (string == null) {
            return;
        }
        String workstationType = string;
        this.plugin.getLogger().info("Workstation broken: " + workstationType + " at " + block2.getLocation());
        BlockPos pos = new BlockPos(block2.getX(), block2.getY(), block2.getZ());
        WorkstationDataManager.WorkstationData workstationData = WorkstationDataManager.INSTANCE.getWorkstationData(pos, workstationType);
        List placedItems = CollectionsKt.toList((Iterable)workstationData.getPlacedItems());
        if (!((Collection)placedItems).isEmpty()) {
            Location location = block2.getLocation().add(0.5, 0.5, 0.5);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location dropLocation = location;
            Iterable $this$forEach$iv = placedItems;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID uuid;
                PlacedItem placedItem = (PlacedItem)element$iv;
                boolean bl = false;
                block2.getWorld().dropItemNaturally(dropLocation, placedItem.getItem());
                if (placedItem.getDisplayUUID() == null) continue;
                boolean bl2 = false;
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null) continue;
                entity.remove();
            }
            this.plugin.getLogger().info("Dropped " + placedItems.size() + " items from workstation");
        }
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        WorkstationBlockListener.cleanupNearbyEntities$default(this, location, 0.0, 2, null);
        WorkstationDataManager.INSTANCE.removeWorkstationData(pos);
        WorkstationDataManager.INSTANCE.saveData();
    }

    private final String getWorkstationType(Block block) {
        ImmutableBlockState immutableBlockState = CraftEngineBlocks.getCustomBlockState((Block)block);
        if (immutableBlockState == null) {
            return null;
        }
        ImmutableBlockState state = immutableBlockState;
        for (String type : WORKSTATION_TYPES) {
            if (!state.owner().matchesKey(Key.of((String)("atom:" + type)))) continue;
            return type;
        }
        return null;
    }

    private final void cleanupNearbyEntities(Location location, double radius) {
        block2: {
            Location location2 = location.clone().add(0.5, 0.5, 0.5);
            Intrinsics.checkNotNullExpressionValue(location2, "add(...)");
            Location centerLocation = location2;
            Object object = location.getWorld();
            if (object == null || (object = object.getNearbyEntities(centerLocation, radius, radius, radius)) == null) break block2;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entity entity = (Entity)element$iv;
                boolean bl = false;
                Entity entity2 = entity;
                if (entity2 instanceof ItemDisplay) {
                    if (!(((ItemDisplay)entity).getLocation().distance(centerLocation) < radius)) continue;
                    this.plugin.getLogger().info("Removing orphaned ItemDisplay at " + ((ItemDisplay)entity).getLocation());
                    ((ItemDisplay)entity).remove();
                    continue;
                }
                if (!(entity2 instanceof Interaction) || !(((Interaction)entity).getLocation().distance(centerLocation) < radius)) continue;
                this.plugin.getLogger().info("Removing orphaned Interaction at " + ((Interaction)entity).getLocation());
                ((Interaction)entity).remove();
            }
        }
    }

    static /* synthetic */ void cleanupNearbyEntities$default(WorkstationBlockListener workstationBlockListener, Location location, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.5;
        }
        workstationBlockListener.cleanupNearbyEntities(location, d);
    }

    static {
        String[] stringArray = new String[]{"knapping_station", "leather_bed", "crafting_basket"};
        WORKSTATION_TYPES = SetsKt.setOf(stringArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/shotrush/atom/content/workstation/WorkstationBlockListener$Companion;", "", "<init>", "()V", "WORKSTATION_TYPES", "", "", "Atom"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

