/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.campfire;

import com.github.shynixn.mccoroutine.folia.MCCoroutineKt;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import net.momirealms.craftengine.core.world.BlockPos;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.workstation.campfire.CampfireRegistry;
import org.shotrush.atom.content.workstation.core.WorkstationDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0003;<=B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u000fJ\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020!J\u000e\u0010$\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000fJ\u001d\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+J!\u0010,\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00102\n\b\u0002\u0010-\u001a\u0004\u0018\u00010&H\u0002\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0082@\u00a2\u0006\u0002\u00100J\u0018\u00101\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u00102\u001a\u00020\u0012H\u0002J\u0010\u00103\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0010\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "atom", "Lorg/shotrush/atom/Atom;", "getAtom", "()Lorg/shotrush/atom/Atom;", "listeners", "", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$Listener;", "active", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/Location;", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;", "addListener", "", "l", "removeListener", "isTracked", "loc", "getState", "getAllStates", "", "trackOnPlace", "", "lit", "lightAt", "light", "state", "fromEvent", "", "extinguishAt", "reason", "brokenAt", "addFuel", "", "addedMs", "(Lorg/bukkit/Location;J)Ljava/lang/Long;", "resumeFromDisk", "targetWorld", "Lorg/bukkit/World;", "scheduleBurnout", "remainingOverride", "(Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;Ljava/lang/Long;)V", "cancelBurnout", "(Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setLit", "value", "persistStartTime", "clearPersistence", "clearKey", "pos", "Lnet/momirealms/craftengine/core/world/BlockPos;", "fix", "xyz", "s", "Companion", "CampfireState", "Listener", "Atom"})
@SourceDebugExtension(value={"SMAP\nCampfireRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampfireRegistry.kt\norg/shotrush/atom/content/workstation/campfire/CampfireRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,249:1\n1869#2,2:250\n1869#2,2:255\n1869#2,2:257\n1869#2,2:261\n1869#2,2:263\n72#3,2:252\n1#4:254\n216#5,2:259\n*S KotlinDebug\n*F\n+ 1 CampfireRegistry.kt\norg/shotrush/atom/content/workstation/campfire/CampfireRegistry\n*L\n59#1:250,2\n80#1:255,2\n131#1:257,2\n171#1:261,2\n175#1:263,2\n64#1:252,2\n64#1:254\n141#1:259,2\n*E\n"})
public final class CampfireRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final List<Listener> listeners;
    @NotNull
    private final ConcurrentHashMap<Location, CampfireState> active;
    public static final long BASE_BURN_MS = 120000L;
    @NotNull
    private static final String WS_TYPE = "campfire";

    public CampfireRegistry(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.listeners = new ArrayList();
        this.active = new ConcurrentHashMap();
    }

    private final Atom getAtom() {
        return Atom.Companion.getInstance();
    }

    public final boolean addListener(@NotNull Listener l) {
        Intrinsics.checkNotNullParameter(l, "l");
        return this.listeners.add(l);
    }

    public final boolean removeListener(@NotNull Listener l) {
        Intrinsics.checkNotNullParameter(l, "l");
        return this.listeners.remove(l);
    }

    public final boolean isTracked(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        return this.active.containsKey(loc);
    }

    @Nullable
    public final CampfireState getState(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        return this.active.get(loc);
    }

    @NotNull
    public final Collection<CampfireState> getAllStates() {
        Collection<CampfireState> collection = this.active.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return collection;
    }

    public final void trackOnPlace(@NotNull Location loc, boolean lit) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Location fixed = this.fix(loc);
        CampfireState state = new CampfireState(fixed, lit, null, null, 8, null);
        ((Map)this.active).put(fixed, state);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onCampfirePlaced(state);
        }
        if (lit) {
            this.light(state, "place");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void lightAt(@NotNull Location loc) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(loc, "loc");
        ConcurrentMap concurrentMap = this.active;
        Location key$iv = this.fix(loc);
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            CampfireState default$iv = new CampfireState(this.fix(loc), false, null, null, 8, null);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        CampfireState state = (CampfireState)object;
        Intrinsics.checkNotNull(state);
        this.light(state, "interact");
    }

    private final void light(CampfireState state, String fromEvent) {
        Block block = state.getLocation().getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        BlockData blockData = block2.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "getBlockData(...)");
        BlockData data = blockData;
        if (data instanceof Lightable && !((Lightable)data).isLit()) {
            ((Lightable)data).setLit(true);
            block2.setBlockData(data);
        }
        if (!state.getLit()) {
            state.setLit(true);
            state.setStartTime(System.currentTimeMillis());
            this.persistStartTime(state);
            CampfireRegistry.scheduleBurnout$default(this, state, null, 2, null);
            Iterable $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Listener it = (Listener)element$iv;
                boolean bl = false;
                it.onCampfireLit(state);
            }
            this.getAtom().getLogger().info("Campfire lit at " + this.xyz(state) + " (via " + fromEvent + ")");
        }
    }

    public final void extinguishAt(@NotNull Location loc, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(reason, "reason");
        CampfireState campfireState = this.active.get(this.fix(loc));
        if (campfireState == null) {
            return;
        }
        CampfireState state = campfireState;
        if (!state.getLit()) {
            return;
        }
        MCCoroutineKt.launch$default(this.getAtom(), MCCoroutineKt.regionDispatcher(this.getAtom(), state.getLocation()), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, reason, null){
            int label;
            final /* synthetic */ CampfireRegistry this$0;
            final /* synthetic */ CampfireState $state;
            final /* synthetic */ String $reason;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                this.$reason = $reason;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = CampfireRegistry.access$cancelBurnout(this.this$0, this.$state, this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        CampfireRegistry.access$setLit(this.this$0, this.$state.getLocation(), false);
                        this.$state.setLit(false);
                        var2_3 = CampfireRegistry.access$getListeners$p(this.this$0);
                        var3_4 = this.$state;
                        var4_5 = this.$reason;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Listener)element$iv;
                            $i$a$-forEach-CampfireRegistry$extinguishAt$1$1 = false;
                            it.onCampfireExtinguished(var3_4, var4_5);
                        }
                        CampfireRegistry.access$clearPersistence(this.this$0, this.$state);
                        CampfireRegistry.access$getAtom(this.this$0).getLogger().info("Campfire extinguished at " + CampfireRegistry.access$xyz(this.this$0, this.$state) + " (" + this.$reason + ")");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    public final void brokenAt(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        CampfireState campfireState = this.active.remove(this.fix(loc));
        if (campfireState == null) {
            return;
        }
        CampfireState state = campfireState;
        MCCoroutineKt.launch$default(this.getAtom(), MCCoroutineKt.regionDispatcher(this.getAtom(), state.getLocation()), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, null){
            int label;
            final /* synthetic */ CampfireRegistry this$0;
            final /* synthetic */ CampfireState $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = CampfireRegistry.access$cancelBurnout(this.this$0, this.$state, this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var2_3 = CampfireRegistry.access$getListeners$p(this.this$0);
                        var3_4 = this.$state;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Listener)element$iv;
                            $i$a$-forEach-CampfireRegistry$brokenAt$1$1 = false;
                            it.onCampfireBroken(var3_4);
                        }
                        CampfireRegistry.access$clearPersistence(this.this$0, this.$state);
                        CampfireRegistry.access$getAtom(this.this$0).getLogger().info("Campfire broken at " + CampfireRegistry.access$xyz(this.this$0, this.$state));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @Nullable
    public final Long addFuel(@NotNull Location loc, long addedMs) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Location fixed = this.fix(loc);
        CampfireState campfireState = this.active.get(fixed);
        if (campfireState == null) {
            return null;
        }
        CampfireState state = campfireState;
        if (!state.getLit() || state.getStartTime() == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        Long l = state.getStartTime();
        Intrinsics.checkNotNull(l);
        long elapsed = now - l;
        long remaining = 120000L - elapsed;
        if (remaining <= 0L) {
            return null;
        }
        long newDuration = remaining + addedMs;
        long newStart = now - (120000L - newDuration);
        state.setStartTime(newStart);
        this.persistStartTime(state);
        MCCoroutineKt.launch$default(this.getAtom(), MCCoroutineKt.regionDispatcher(this.getAtom(), state.getLocation()), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, null){
            int label;
            final /* synthetic */ CampfireRegistry this$0;
            final /* synthetic */ CampfireState $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = CampfireRegistry.access$cancelBurnout(this.this$0, this.$state, this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        CampfireRegistry.scheduleBurnout$default(this.this$0, this.$state, null, 2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        long endTime = newStart + 120000L;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Listener it = (Listener)element$iv;
            boolean bl = false;
            it.onFuelAdded(state, addedMs, endTime);
        }
        this.getAtom().getLogger().info("Fuel added at " + this.xyz(state) + ": +" + addedMs / (long)1000 + "s");
        return endTime;
    }

    public final void resumeFromDisk(@NotNull World targetWorld) {
        Intrinsics.checkNotNullParameter(targetWorld, "targetWorld");
        this.getAtom().getLogger().info("=== Resuming campfires for world " + targetWorld.getName() + " ===");
        int resumed = 0;
        int expired = 0;
        Map<String, WorkstationDataManager.WorkstationData> $this$forEach$iv = WorkstationDataManager.INSTANCE.getAllWorkstations();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, WorkstationDataManager.WorkstationData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, WorkstationDataManager.WorkstationData> element$iv;
            Map.Entry<String, WorkstationDataManager.WorkstationData> entry = element$iv = iterator2.next();
            boolean bl = false;
            WorkstationDataManager.WorkstationData data = entry.getValue();
            if (!Intrinsics.areEqual(data.getType(), WS_TYPE) || data.getCuringStartTime() == null) continue;
            Location loc = new Location(targetWorld, (double)data.getPosition().x(), (double)data.getPosition().y(), (double)data.getPosition().z());
            Bukkit.getServer().getRegionScheduler().run(this.plugin, loc, arg_0 -> CampfireRegistry.resumeFromDisk$lambda$0$0(loc, this, data, arg_0));
        }
        this.getAtom().getLogger().info("Resume summary: resumed=" + resumed + " expired=" + expired + " (final counts may differ due to async processing)");
    }

    private final void scheduleBurnout(CampfireState state, Long remainingOverride) {
        long remaining;
        Long l = state.getStartTime();
        if (l == null) {
            return;
        }
        long start = l;
        long now = System.currentTimeMillis();
        Long l2 = remainingOverride;
        long l3 = remaining = l2 != null ? l2 : RangesKt.coerceAtLeast(120000L - (now - start), 0L);
        if (remaining <= 0L) {
            this.extinguishAt(state.getLocation(), "burnout");
            return;
        }
        Job job2 = MCCoroutineKt.launch$default(this.getAtom(), MCCoroutineKt.regionDispatcher(this.getAtom(), state.getLocation()), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(remaining, state, this, null){
            int label;
            final /* synthetic */ long $remaining;
            final /* synthetic */ CampfireState $state;
            final /* synthetic */ CampfireRegistry this$0;
            {
                this.$remaining = $remaining;
                this.$state = $state;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = DelayKt.delay(this.$remaining, this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = lightable = (var3_3 /* !! */  = this.$state.getLocation().getBlock().getBlockData()) instanceof Lightable != false ? (Lightable)var3_3 /* !! */  : null;
                        if (lightable != null && lightable.isLit()) {
                            CampfireRegistry.access$setLit(this.this$0, this.$state.getLocation(), false);
                            this.$state.setLit(false);
                            var3_3 /* !! */  = CampfireRegistry.access$getListeners$p(this.this$0);
                            var4_5 = this.$state;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                it = (Listener)element$iv;
                                $i$a$-forEach-CampfireRegistry$scheduleBurnout$job$1$1 = false;
                                it.onCampfireExtinguished(var4_5, "burnout");
                            }
                            CampfireRegistry.access$clearPersistence(this.this$0, this.$state);
                            CampfireRegistry.access$getAtom(this.this$0).getLogger().info("Campfire burned out at " + CampfireRegistry.access$xyz(this.this$0, this.$state));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        state.setBurnoutJob(job2);
    }

    static /* synthetic */ void scheduleBurnout$default(CampfireRegistry campfireRegistry, CampfireState campfireState, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = null;
        }
        campfireRegistry.scheduleBurnout(campfireState, l);
    }

    /*
     * Unable to fully structure code
     */
    private final Object cancelBurnout(CampfireState state, Continuation<? super Unit> $completion) {
        if (!($completion instanceof cancelBurnout.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CampfireRegistry this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CampfireRegistry.access$cancelBurnout(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                v0 = state.getBurnoutJob();
                if (v0 != null) {
                    Job.DefaultImpls.cancel$default(v0, null, 1, null);
                }
                v1 = state.getBurnoutJob();
                if (v1 == null) break;
                $continuation.L$0 = state;
                $continuation.label = 1;
                v2 = JobKt.cancelAndJoin(v1, $continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                break;
            }
            case 1: {
                state = (CampfireState)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
                break;
            }
        }
        state.setBurnoutJob(null);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void setLit(Location loc, boolean value) {
        Block block = loc.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block block2 = block;
        BlockData blockData = block2.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "getBlockData(...)");
        BlockData data = blockData;
        if (data instanceof Lightable && ((Lightable)data).isLit() != value) {
            ((Lightable)data).setLit(value);
            block2.setBlockData(data);
        }
    }

    private final void persistStartTime(CampfireState state) {
        BlockPos pos = new BlockPos(state.getLocation().getBlockX(), state.getLocation().getBlockY(), state.getLocation().getBlockZ());
        WorkstationDataManager.WorkstationData d = WorkstationDataManager.INSTANCE.getWorkstationData(pos, WS_TYPE);
        d.setCuringStartTime(state.getStartTime());
        WorkstationDataManager.INSTANCE.saveData();
    }

    private final void clearPersistence(CampfireState state) {
        BlockPos pos = new BlockPos(state.getLocation().getBlockX(), state.getLocation().getBlockY(), state.getLocation().getBlockZ());
        WorkstationDataManager.INSTANCE.removeWorkstationData(pos);
    }

    private final void clearKey(BlockPos pos) {
        WorkstationDataManager.INSTANCE.removeWorkstationData(pos);
    }

    private final Location fix(Location l) {
        return new Location(l.getWorld(), (double)l.getBlockX(), (double)l.getBlockY(), (double)l.getBlockZ());
    }

    private final String xyz(CampfireState s2) {
        return s2.getLocation().getBlockX() + "," + s2.getLocation().getBlockY() + "," + s2.getLocation().getBlockZ();
    }

    private static final void resumeFromDisk$lambda$0$0(Location $loc, CampfireRegistry this$0, WorkstationDataManager.WorkstationData $data, ScheduledTask scheduledTask) {
        try {
            Lightable lightable;
            Block block = $loc.getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
            Block block2 = block;
            if (block2.getType() != Material.CAMPFIRE && block2.getType() != Material.SOUL_CAMPFIRE) {
                this$0.clearKey($data.getPosition());
                return;
            }
            BlockData blockData = block2.getBlockData();
            Lightable lightable2 = lightable = blockData instanceof Lightable ? (Lightable)blockData : null;
            if (lightable == null) {
                this$0.clearKey($data.getPosition());
                return;
            }
            CampfireState state = new CampfireState($loc, lightable.isLit(), $data.getCuringStartTime(), null, 8, null);
            long l = System.currentTimeMillis();
            Long l2 = $data.getCuringStartTime();
            Intrinsics.checkNotNull(l2);
            long elapsed = l - l2;
            long remaining = 120000L - elapsed;
            if (remaining > 0L && lightable.isLit()) {
                ((Map)this$0.active).put(this$0.fix($loc), state);
                this$0.scheduleBurnout(state, remaining);
                Iterable $this$forEach$iv = this$0.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Listener it = (Listener)element$iv;
                    boolean bl = false;
                    it.onResumeTimerScheduled(state, remaining);
                }
                this$0.getAtom().getLogger().info("  \u2713 Resume (" + this$0.xyz(state) + ") " + remaining / (long)1000 + "s");
            } else {
                this$0.setLit($loc, false);
                Iterable $this$forEach$iv = this$0.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Listener it = (Listener)element$iv;
                    boolean bl = false;
                    it.onResumeTimerExpired(state);
                }
                this$0.clearPersistence(state);
                this$0.getAtom().getLogger().info("  \u2717 Expired (" + this$0.xyz(state) + ")");
            }
        }
        catch (Exception e) {
            this$0.getAtom().getLogger().warning("  \u2297 Error resuming campfire at (" + $data.getPosition().x() + "," + $data.getPosition().y() + "," + $data.getPosition().z() + "): " + e.getMessage());
        }
    }

    public static final /* synthetic */ Object access$cancelBurnout(CampfireRegistry $this, CampfireState state, Continuation $completion) {
        return $this.cancelBurnout(state, $completion);
    }

    public static final /* synthetic */ void access$setLit(CampfireRegistry $this, Location loc, boolean value) {
        $this.setLit(loc, value);
    }

    public static final /* synthetic */ List access$getListeners$p(CampfireRegistry $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ void access$clearPersistence(CampfireRegistry $this, CampfireState state) {
        $this.clearPersistence(state);
    }

    public static final /* synthetic */ Atom access$getAtom(CampfireRegistry $this) {
        return $this.getAtom();
    }

    public static final /* synthetic */ String access$xyz(CampfireRegistry $this, CampfireState s2) {
        return $this.xyz(s2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u00c6\u0003J:\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;", "", "location", "Lorg/bukkit/Location;", "lit", "", "startTime", "", "burnoutJob", "Lkotlinx/coroutines/Job;", "<init>", "(Lorg/bukkit/Location;ZLjava/lang/Long;Lkotlinx/coroutines/Job;)V", "getLocation", "()Lorg/bukkit/Location;", "getLit", "()Z", "setLit", "(Z)V", "getStartTime", "()Ljava/lang/Long;", "setStartTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getBurnoutJob", "()Lkotlinx/coroutines/Job;", "setBurnoutJob", "(Lkotlinx/coroutines/Job;)V", "component1", "component2", "component3", "component4", "copy", "(Lorg/bukkit/Location;ZLjava/lang/Long;Lkotlinx/coroutines/Job;)Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;", "equals", "other", "hashCode", "", "toString", "", "Atom"})
    public static final class CampfireState {
        @NotNull
        private final Location location;
        private boolean lit;
        @Nullable
        private Long startTime;
        @Nullable
        private Job burnoutJob;

        public CampfireState(@NotNull Location location, boolean lit, @Nullable Long startTime, @Nullable Job burnoutJob) {
            Intrinsics.checkNotNullParameter(location, "location");
            this.location = location;
            this.lit = lit;
            this.startTime = startTime;
            this.burnoutJob = burnoutJob;
        }

        public /* synthetic */ CampfireState(Location location, boolean bl, Long l, Job job2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                job2 = null;
            }
            this(location, bl, l, job2);
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        public final boolean getLit() {
            return this.lit;
        }

        public final void setLit(boolean bl) {
            this.lit = bl;
        }

        @Nullable
        public final Long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(@Nullable Long l) {
            this.startTime = l;
        }

        @Nullable
        public final Job getBurnoutJob() {
            return this.burnoutJob;
        }

        public final void setBurnoutJob(@Nullable Job job2) {
            this.burnoutJob = job2;
        }

        @NotNull
        public final Location component1() {
            return this.location;
        }

        public final boolean component2() {
            return this.lit;
        }

        @Nullable
        public final Long component3() {
            return this.startTime;
        }

        @Nullable
        public final Job component4() {
            return this.burnoutJob;
        }

        @NotNull
        public final CampfireState copy(@NotNull Location location, boolean lit, @Nullable Long startTime, @Nullable Job burnoutJob) {
            Intrinsics.checkNotNullParameter(location, "location");
            return new CampfireState(location, lit, startTime, burnoutJob);
        }

        public static /* synthetic */ CampfireState copy$default(CampfireState campfireState, Location location, boolean bl, Long l, Job job2, int n, Object object) {
            if ((n & 1) != 0) {
                location = campfireState.location;
            }
            if ((n & 2) != 0) {
                bl = campfireState.lit;
            }
            if ((n & 4) != 0) {
                l = campfireState.startTime;
            }
            if ((n & 8) != 0) {
                job2 = campfireState.burnoutJob;
            }
            return campfireState.copy(location, bl, l, job2);
        }

        @NotNull
        public String toString() {
            return "CampfireState(location=" + this.location + ", lit=" + this.lit + ", startTime=" + this.startTime + ", burnoutJob=" + this.burnoutJob + ")";
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result = result * 31 + Boolean.hashCode(this.lit);
            result = result * 31 + (this.startTime == null ? 0 : ((Object)this.startTime).hashCode());
            result = result * 31 + (this.burnoutJob == null ? 0 : this.burnoutJob.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CampfireState)) {
                return false;
            }
            CampfireState campfireState = (CampfireState)other;
            if (!Intrinsics.areEqual(this.location, campfireState.location)) {
                return false;
            }
            if (this.lit != campfireState.lit) {
                return false;
            }
            if (!Intrinsics.areEqual(this.startTime, campfireState.startTime)) {
                return false;
            }
            return Intrinsics.areEqual(this.burnoutJob, campfireState.burnoutJob);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$Companion;", "", "<init>", "()V", "BASE_BURN_MS", "", "WS_TYPE", "", "Atom"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0012\u00c0\u0006\u0003"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$Listener;", "", "onCampfirePlaced", "", "state", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;", "onCampfireLit", "onCampfireExtinguished", "reason", "", "onCampfireBroken", "onFuelAdded", "addedMs", "", "newEndTimeMs", "onResumeTimerScheduled", "remainingMs", "onResumeTimerExpired", "Atom"})
    public static interface Listener {
        default public void onCampfirePlaced(@NotNull CampfireState state) {
            Intrinsics.checkNotNullParameter(state, "state");
        }

        default public void onCampfireLit(@NotNull CampfireState state) {
            Intrinsics.checkNotNullParameter(state, "state");
        }

        default public void onCampfireExtinguished(@NotNull CampfireState state, @NotNull String reason) {
            Intrinsics.checkNotNullParameter(state, "state");
            Intrinsics.checkNotNullParameter(reason, "reason");
        }

        default public void onCampfireBroken(@NotNull CampfireState state) {
            Intrinsics.checkNotNullParameter(state, "state");
        }

        default public void onFuelAdded(@NotNull CampfireState state, long addedMs, long newEndTimeMs) {
            Intrinsics.checkNotNullParameter(state, "state");
        }

        default public void onResumeTimerScheduled(@NotNull CampfireState state, long remainingMs) {
            Intrinsics.checkNotNullParameter(state, "state");
        }

        default public void onResumeTimerExpired(@NotNull CampfireState state) {
            Intrinsics.checkNotNullParameter(state, "state");
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static void onCampfirePlaced(@NotNull Listener $this, @NotNull CampfireState state) {
                Intrinsics.checkNotNullParameter(state, "state");
                $this.onCampfirePlaced(state);
            }

            @Deprecated
            public static void onCampfireLit(@NotNull Listener $this, @NotNull CampfireState state) {
                Intrinsics.checkNotNullParameter(state, "state");
                $this.onCampfireLit(state);
            }

            @Deprecated
            public static void onCampfireExtinguished(@NotNull Listener $this, @NotNull CampfireState state, @NotNull String reason) {
                Intrinsics.checkNotNullParameter(state, "state");
                Intrinsics.checkNotNullParameter(reason, "reason");
                $this.onCampfireExtinguished(state, reason);
            }

            @Deprecated
            public static void onCampfireBroken(@NotNull Listener $this, @NotNull CampfireState state) {
                Intrinsics.checkNotNullParameter(state, "state");
                $this.onCampfireBroken(state);
            }

            @Deprecated
            public static void onFuelAdded(@NotNull Listener $this, @NotNull CampfireState state, long addedMs, long newEndTimeMs) {
                Intrinsics.checkNotNullParameter(state, "state");
                $this.onFuelAdded(state, addedMs, newEndTimeMs);
            }

            @Deprecated
            public static void onResumeTimerScheduled(@NotNull Listener $this, @NotNull CampfireState state, long remainingMs) {
                Intrinsics.checkNotNullParameter(state, "state");
                $this.onResumeTimerScheduled(state, remainingMs);
            }

            @Deprecated
            public static void onResumeTimerExpired(@NotNull Listener $this, @NotNull CampfireState state) {
                Intrinsics.checkNotNullParameter(state, "state");
                $this.onResumeTimerExpired(state);
            }
        }
    }
}

