/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.campfire;

import com.github.shynixn.mccoroutine.folia.MCCoroutineKt;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.shotrush.atom.Atom;
import org.shotrush.atom.UtilKt;
import org.shotrush.atom.content.workstation.campfire.CampfireRegistry;
import org.shotrush.atom.content.workstation.campfire.features.BurnoutFeature;
import org.shotrush.atom.content.workstation.campfire.features.MoldFiringFeature;
import org.shotrush.atom.content.workstation.campfire.features.UniversalFuelFeature;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.util.ActionBarManager;

@RegisterSystem(id="campfire_system", priority=5, toggleable=true, description="Unified campfire lifecycle (lighting, burnout, universal fuel, mold firing)", enabledByDefault=true)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!H\u0007J.\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170*H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0012\u001aB\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u0015 \u0014* \u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0014*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/CampfireSystem;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/Plugin;", "<init>", "(Lorg/bukkit/plugin/Plugin;)V", "registry", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry;", "burnout", "Lorg/shotrush/atom/content/workstation/campfire/features/BurnoutFeature;", "mold", "Lorg/shotrush/atom/content/workstation/campfire/features/MoldFiringFeature;", "universalFuel", "Lorg/shotrush/atom/content/workstation/campfire/features/UniversalFuelFeature;", "recentFuelAdditions", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "resumedWorlds", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "kotlin.jvm.PlatformType", "", "onWorldLoad", "", "event", "Lorg/bukkit/event/world/WorldLoadEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlace", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onInteract", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onBreak", "Lorg/bukkit/event/block/BlockBreakEvent;", "startStrikeTask", "player", "Lorg/bukkit/entity/Player;", "campfireLoc", "Lorg/bukkit/Location;", "strikesNeeded", "", "onSuccess", "Lkotlin/Function0;", "Atom"})
@SourceDebugExtension(value={"SMAP\nCampfireSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CampfireSystem.kt\norg/shotrush/atom/content/workstation/campfire/CampfireSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,243:1\n1869#2,2:244\n*S KotlinDebug\n*F\n+ 1 CampfireSystem.kt\norg/shotrush/atom/content/workstation/campfire/CampfireSystem\n*L\n167#1:244,2\n*E\n"})
public final class CampfireSystem
implements Listener {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final CampfireRegistry registry;
    @NotNull
    private final BurnoutFeature burnout;
    @NotNull
    private final MoldFiringFeature mold;
    @NotNull
    private final UniversalFuelFeature universalFuel;
    @NotNull
    private final ConcurrentHashMap<String, Long> recentFuelAdditions;
    private final ConcurrentHashMap.KeySetView<String, Boolean> resumedWorlds;

    public CampfireSystem(@NotNull Plugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.registry = new CampfireRegistry(this.plugin);
        this.burnout = new BurnoutFeature();
        this.mold = new MoldFiringFeature(0L, 1, null);
        this.universalFuel = new UniversalFuelFeature();
        this.recentFuelAdditions = new ConcurrentHashMap();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        this.registry.addListener(this.burnout);
        this.registry.addListener(this.universalFuel);
        this.registry.addListener(this.mold);
        this.resumedWorlds = ConcurrentHashMap.newKeySet();
        this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, arg_0 -> CampfireSystem._init_$lambda$1(arg_0 -> CampfireSystem._init_$lambda$0(this, arg_0), arg_0), 100L, 100L);
    }

    @EventHandler
    public final void onWorldLoad(@NotNull WorldLoadEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.resumedWorlds.add(event.getWorld().getName())) {
            MCCoroutineKt.launch$default(Atom.Companion.getInstance(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
                int label;
                final /* synthetic */ CampfireSystem this$0;
                final /* synthetic */ WorldLoadEvent $event;
                {
                    this.this$0 = $receiver;
                    this.$event = $event;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.label = 1;
                            v0 = DelayKt.delay(100L, this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            v1 = CampfireSystem.access$getRegistry$p(this.this$0);
                            v2 = this.$event.getWorld();
                            Intrinsics.checkNotNullExpressionValue(v2, "getWorld(...)");
                            v1.resumeFromDisk(v2);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    @EventHandler
    public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        World world = event.getPlayer().getWorld();
        Intrinsics.checkNotNullExpressionValue(world, "getWorld(...)");
        World world2 = world;
        if (this.resumedWorlds.add(world2.getName())) {
            MCCoroutineKt.launch$default(Atom.Companion.getInstance(), null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, world2, null){
                int label;
                final /* synthetic */ CampfireSystem this$0;
                final /* synthetic */ World $world;
                {
                    this.this$0 = $receiver;
                    this.$world = $world;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            this.label = 1;
                            v0 = DelayKt.delay(2000L, this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            CampfireSystem.access$getRegistry$p(this.this$0).resumeFromDisk(this.$world);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 3, null);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public final void onPlace(@NotNull BlockPlaceEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlockPlaced();
        Intrinsics.checkNotNullExpressionValue(block, "getBlockPlaced(...)");
        Block b = block;
        if (b.getType() != Material.CAMPFIRE && b.getType() != Material.SOUL_CAMPFIRE) {
            return;
        }
        BlockData blockData = b.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "getBlockData(...)");
        BlockData data = blockData;
        if (data instanceof Lightable) {
            ((Lightable)data).setLit(false);
            b.setBlockData(data);
        }
        Location location = b.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.registry.trackOnPlace(location, false);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void onInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Block block2 = block;
        if (block2.getType() != Material.CAMPFIRE && block2.getType() != Material.SOUL_CAMPFIRE) {
            return;
        }
        BlockData blockData = block2.getBlockData();
        Lightable lightable = blockData instanceof Lightable ? (Lightable)blockData : null;
        if (lightable == null) {
            return;
        }
        Lightable data = lightable;
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue(itemStack, "getItemInMainHand(...)");
        ItemStack item = itemStack;
        if (data.isLit()) {
            long lastAddition;
            String key = player2.getUniqueId() + ":" + block2.getLocation();
            long now = System.currentTimeMillis();
            Long l = this.recentFuelAdditions.get(key);
            long l2 = lastAddition = l != null ? l : 0L;
            if (now - lastAddition < 100L) {
                return;
            }
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            Long end = this.universalFuel.tryAddFuel(this.registry, location, item);
            if (end != null) {
                event.setCancelled(true);
                ((Map)this.recentFuelAdditions).put(key, now);
                item.subtract(1);
                long remaining = RangesKt.coerceAtLeast(end - System.currentTimeMillis(), 0L);
                int min2 = (int)(remaining / 60000L);
                int sec = (int)(remaining % 60000L / 1000L);
                Location location2 = block2.getLocation();
                Intrinsics.checkNotNullExpressionValue(location2, "getLocation(...)");
                List<UniversalFuelFeature.QueuedFuel> queueInfo = this.universalFuel.getFuelQueue(location2);
                String queueStatus = queueInfo.size() >= 4 ? " (Queue Full!)" : " (" + queueInfo.size() + "/4 in queue)";
                ActionBarManager.send(player2, "campfire", "<green>Added fuel! Time remaining:</green> <yellow>" + min2 + "m " + sec + "s</yellow>" + queueStatus);
            } else {
                Location location3 = block2.getLocation();
                Intrinsics.checkNotNullExpressionValue(location3, "getLocation(...)");
                if (this.universalFuel.isQueueFull(location3)) {
                    ActionBarManager.send(player2, "campfire", "<red>Fuel queue is full (max 4 items).</red>");
                } else {
                    ActionBarManager.send(player2, "campfire", "<red>Item is not valid fuel.</red>");
                }
            }
            return;
        }
        if (UtilKt.matches(item, "atom:pebble") && !data.isLit()) {
            int strikesNeeded = 10 + Random.Default.nextInt(6);
            Location location = block2.getLocation();
            Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
            this.startStrikeTask(player2, location, strikesNeeded, () -> CampfireSystem.onInteract$lambda$0(this, block2, player2));
            return;
        }
        Plugin plugin = Atom.Companion.getInstance();
        Plugin plugin2 = Atom.Companion.getInstance();
        Location location = block2.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        MCCoroutineKt.launch$default(plugin, MCCoroutineKt.regionDispatcher(plugin2, location), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(block2, this, null){
            int label;
            final /* synthetic */ Block $block;
            final /* synthetic */ CampfireSystem this$0;
            {
                this.$block = $block;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = DelayKt.delay(50L, this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = (var3_3 = this.$block.getLocation().getBlock().getBlockData()) instanceof Lightable != false ? (Lightable)var3_3 : null;
                        if (v1 == null) {
                            return Unit.INSTANCE;
                        }
                        updated = v1;
                        if (!updated.isLit()) {
                            v2 = CampfireSystem.access$getRegistry$p(this.this$0);
                            v3 = this.$block.getLocation();
                            Intrinsics.checkNotNullExpressionValue(v3, "getLocation(...)");
                            v2.extinguishAt(v3, "player");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public final void onBreak(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block b = block;
        if (b.getType() != Material.CAMPFIRE && b.getType() != Material.SOUL_CAMPFIRE) {
            return;
        }
        Location location = b.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        this.registry.brokenAt(location);
    }

    private final void startStrikeTask(Player player, Location campfireLoc, int strikesNeeded, Function0<Unit> onSuccess) {
        Atom atom = Atom.Companion.getInstance();
        MCCoroutineKt.launch$default(atom, MCCoroutineKt.regionDispatcher(atom, campfireLoc), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(player, strikesNeeded, campfireLoc, onSuccess, null){
            int I$0;
            Object L$0;
            int label;
            final /* synthetic */ Player $player;
            final /* synthetic */ int $strikesNeeded;
            final /* synthetic */ Location $campfireLoc;
            final /* synthetic */ Function0<Unit> $onSuccess;
            {
                this.$player = $player;
                this.$strikesNeeded = $strikesNeeded;
                this.$campfireLoc = $campfireLoc;
                this.$onSuccess = $onSuccess;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block17: {
                    var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            strikes = 0;
                            ActionBarManager.sendStatus(this.$player, "<gray>Lighting campfire... Strike repeatedly</gray>");
lbl7:
                            // 2 sources

                            while (strikes < this.$strikesNeeded) {
                                this.I$0 = strikes;
                                this.label = 1;
                                v0 = DelayKt.delay(MCCoroutineKt.getTicks(5), this);
                                if (v0 == var15_2) {
                                    return var15_2;
                                }
                                ** GOTO lbl19
                            }
                            break block17;
                        }
                        case 1: {
                            strikes = this.I$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl19:
                            // 2 sources

                            Intrinsics.checkNotNullExpressionValue(this.$campfireLoc.getBlock().getBlockData(), "getBlockData(...)");
                            if (data instanceof Lightable && ((Lightable)data).isLit()) {
                                return Unit.INSTANCE;
                            }
                            if (this.$player.isOnline() && Intrinsics.areEqual(this.$player.getLocation().getWorld(), this.$campfireLoc.getWorld()) && !(this.$player.getLocation().distance(this.$campfireLoc) > 5.0) && this.$player.hasActiveItem()) break;
                            ActionBarManager.sendStatus(this.$player, "<red>Lighting cancelled</red>");
                            this.L$0 = SpillingKt.nullOutSpilledVariable(data);
                            this.I$0 = strikes;
                            this.label = 2;
                            v1 = DelayKt.delay(800L, this);
                            if (v1 == var15_2) {
                                return var15_2;
                            }
                            ** GOTO lbl36
                        }
                        case 2: {
                            strikes = this.I$0;
                            data = (BlockData)this.L$0;
                            ResultKt.throwOnFailure($result);
                            v1 = $result;
lbl36:
                            // 2 sources

                            ActionBarManager.clearStatus(this.$player);
                            return Unit.INSTANCE;
                        }
                    }
                    this.$player.getWorld().playSound(this.$campfireLoc.clone().add(0.5, 0.5, 0.5), Sound.BLOCK_STONE_HIT, 1.0f, 1.5f);
                    this.$player.getWorld().spawnParticle(Particle.DUST_PLUME, this.$campfireLoc.clone().add(0.5, 0.5, 0.5), 3, 0.2, 0.2, 0.2, 0.02);
                    progress = (int)((float)(++strikes) / (float)this.$strikesNeeded * (float)100);
                    $this$invokeSuspend_u24lambda_u240 = var6_9 = new StringBuilder();
                    $i$a$-buildString-CampfireSystem$startStrikeTask$1$str$1 = false;
                    $this$invokeSuspend_u24lambda_u240.append("<yellow>" + progress + "%</yellow> ");
                    $this$invokeSuspend_u24lambda_u240.append("<dark_gray>[");
                    $this$invokeSuspend_u24lambda_u240.append("<green>");
                    total = 20;
                    bars = (int)((double)total * ((double)progress / 100.0));
                    var11_14 = 0;
                    while (var11_14 < bars) {
                        it = var11_14++;
                        $i$a$-repeat-CampfireSystem$startStrikeTask$1$str$1$1 = false;
                        $this$invokeSuspend_u24lambda_u240.append("|");
                    }
                    $this$invokeSuspend_u24lambda_u240.append("</green><gray>");
                    var11_14 = total - bars;
                    var12_15 = 0;
                    while (var12_15 < var11_14) {
                        it = var12_15++;
                        $i$a$-repeat-CampfireSystem$startStrikeTask$1$str$1$2 = false;
                        $this$invokeSuspend_u24lambda_u240.append("|");
                    }
                    $this$invokeSuspend_u24lambda_u240.append("</gray>");
                    $this$invokeSuspend_u24lambda_u240.append("]");
                    $this$invokeSuspend_u24lambda_u240.append("<dark_gray>");
                    str = var6_9.toString();
                    ActionBarManager.sendStatus(this.$player, str);
                    ** GOTO lbl7
                }
                ActionBarManager.clearStatus(this.$player);
                if (Random.Default.nextDouble() < 0.7) {
                    this.$onSuccess.invoke();
                    v2 = this.$campfireLoc.clone().add(0.5, 0.5, 0.5);
                    Intrinsics.checkNotNullExpressionValue(v2, "add(...)");
                    center = v2;
                    v3 = center.getWorld();
                    if (v3 != null) {
                        v3.playSound(center, Sound.ITEM_FIRECHARGE_USE, 1.0f, 1.0f);
                    }
                    v4 = center.getWorld();
                    if (v4 != null) {
                        v4.spawnParticle(Particle.FLAME, center, 20, 0.3, 0.3, 0.3, 0.02);
                    }
                } else {
                    v5 = this.$campfireLoc.clone().add(0.5, 0.5, 0.5);
                    Intrinsics.checkNotNullExpressionValue(v5, "add(...)");
                    center = v5;
                    v6 = center.getWorld();
                    if (v6 != null) {
                        v6.playSound(center, Sound.BLOCK_FIRE_EXTINGUISH, 0.5f, 2.0f);
                    }
                    v7 = center.getWorld();
                    if (v7 != null) {
                        v7.spawnParticle(Particle.SMOKE, center, 10, 0.2, 0.2, 0.2, 0.02);
                    }
                    ActionBarManager.send(this.$player, "campfire", "<red>Failed to light the campfire. Try again!</red>");
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private static final Unit onInteract$lambda$0(CampfireSystem this$0, Block $block, Player $player) {
        CampfireRegistry campfireRegistry = this$0.registry;
        Location location = $block.getLocation();
        Intrinsics.checkNotNullExpressionValue(location, "getLocation(...)");
        campfireRegistry.lightAt(location);
        ActionBarManager.send($player, "campfire", "<green>Successfully lit the campfire!</green>");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(CampfireSystem this$0, BukkitTask bukkitTask) {
        Iterable $this$forEach$iv = this$0.registry.getAllStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CampfireRegistry.CampfireState state = (CampfireRegistry.CampfireState)element$iv;
            boolean bl = false;
            if (!state.getLit()) continue;
            this$0.universalFuel.processFuelQueue(state.getLocation(), this$0.registry);
        }
        long now = System.currentTimeMillis();
        this$0.recentFuelAdditions.entrySet().removeIf(arg_0 -> CampfireSystem.lambda$0$2(arg_0 -> CampfireSystem.lambda$0$1(now, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$1(long $now, Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object v = it.getValue();
        Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
        return $now - ((Number)v).longValue() > 1000L;
    }

    private static final boolean lambda$0$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ CampfireRegistry access$getRegistry$p(CampfireSystem $this) {
        return $this.registry;
    }
}

