/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.campfire.features;

import com.github.shynixn.mccoroutine.folia.MCCoroutineKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Lightable;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.systems.groundstorage.GroundItemDisplayUtils;
import org.shotrush.atom.content.systems.groundstorage.GroundItemUtils;
import org.shotrush.atom.content.workstation.campfire.CampfireRegistry;
import org.shotrush.atom.item.MoldShape;
import org.shotrush.atom.item.MoldType;
import org.shotrush.atom.item.Molds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J.\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u001e\u0010 \u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001a\u001a\u00020\bH\u0002J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001a\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/features/MoldFiringFeature;", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$Listener;", "firingMs", "", "<init>", "(J)V", "active", "", "Lorg/bukkit/Location;", "Lorg/shotrush/atom/content/workstation/campfire/features/MoldFiringFeature$FiringJob;", "atom", "Lorg/shotrush/atom/Atom;", "getAtom", "()Lorg/shotrush/atom/Atom;", "onCampfireLit", "", "state", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;", "onCampfireExtinguished", "reason", "", "onCampfireBroken", "onResumeTimerScheduled", "remainingMs", "onResumeTimerExpired", "scheduleFiring", "strawLoc", "items", "", "", "remaining", "startedAt", "completeFiring", "findValidClayMoldItem", "findAllValidClayMoldItems", "FiringJob", "Atom"})
@SourceDebugExtension(value={"SMAP\nMoldFiringFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoldFiringFeature.kt\norg/shotrush/atom/content/workstation/campfire/features/MoldFiringFeature\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1563#2:188\n1634#2,3:189\n*S KotlinDebug\n*F\n+ 1 MoldFiringFeature.kt\norg/shotrush/atom/content/workstation/campfire/features/MoldFiringFeature\n*L\n85#1:188\n85#1:189,3\n*E\n"})
public final class MoldFiringFeature
implements CampfireRegistry.Listener {
    private final long firingMs;
    @NotNull
    private final Map<Location, FiringJob> active;

    public MoldFiringFeature(long firingMs) {
        this.firingMs = firingMs;
        this.active = new LinkedHashMap();
    }

    public /* synthetic */ MoldFiringFeature(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 300000L;
        }
        this(l);
    }

    private final Atom getAtom() {
        return Atom.Companion.getInstance();
    }

    @Override
    public void onCampfireLit(@NotNull CampfireRegistry.CampfireState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        Location location = state.getLocation().clone().add(0.0, -1.0, 0.0);
        Intrinsics.checkNotNullExpressionValue(location, "add(...)");
        Location strawLoc = location;
        MCCoroutineKt.launch$default(this.getAtom(), MCCoroutineKt.regionDispatcher(this.getAtom(), strawLoc), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, strawLoc, state, null){
            int label;
            final /* synthetic */ MoldFiringFeature this$0;
            final /* synthetic */ Location $strawLoc;
            final /* synthetic */ CampfireRegistry.CampfireState $state;
            {
                this.this$0 = $receiver;
                this.$strawLoc = $strawLoc;
                this.$state = $state;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        List items = MoldFiringFeature.access$findAllValidClayMoldItems(this.this$0, this.$strawLoc);
                        if (items.isEmpty()) {
                            return Unit.INSTANCE;
                        }
                        Long l = this.$state.getStartTime();
                        long start = l != null ? l : System.currentTimeMillis();
                        long remaining = MoldFiringFeature.access$getFiringMs$p(this.this$0) - (System.currentTimeMillis() - start);
                        if (remaining > 0L) {
                            MoldFiringFeature.access$scheduleFiring(this.this$0, this.$strawLoc, items, remaining, start);
                        } else {
                            MoldFiringFeature.access$completeFiring(this.this$0, this.$strawLoc, items);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    @Override
    public void onCampfireExtinguished(@NotNull CampfireRegistry.CampfireState state, @NotNull String reason) {
        block0: {
            Intrinsics.checkNotNullParameter(state, "state");
            Intrinsics.checkNotNullParameter(reason, "reason");
            Location location = state.getLocation().clone().add(0.0, -1.0, 0.0);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location strawLoc = location;
            Object object = this.active.remove(strawLoc);
            if (object == null || (object = ((FiringJob)object).getJob()) == null) break block0;
            Job.DefaultImpls.cancel$default((Job)object, null, 1, null);
        }
    }

    @Override
    public void onCampfireBroken(@NotNull CampfireRegistry.CampfireState state) {
        block0: {
            Intrinsics.checkNotNullParameter(state, "state");
            Location location = state.getLocation().clone().add(0.0, -1.0, 0.0);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location strawLoc = location;
            Object object = this.active.remove(strawLoc);
            if (object == null || (object = ((FiringJob)object).getJob()) == null) break block0;
            Job.DefaultImpls.cancel$default((Job)object, null, 1, null);
        }
    }

    @Override
    public void onResumeTimerScheduled(@NotNull CampfireRegistry.CampfireState state, long remainingMs) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.onCampfireLit(state);
    }

    @Override
    public void onResumeTimerExpired(@NotNull CampfireRegistry.CampfireState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        this.onCampfireExtinguished(state, "expired-on-resume");
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleFiring(Location strawLoc, List<? extends Object> items, long remaining, long startedAt) {
        void $this$mapTo$iv$iv;
        Object object = this.active.remove(strawLoc);
        if (object != null && (object = ((FiringJob)object).getJob()) != null) {
            Job.DefaultImpls.cancel$default((Job)object, null, 1, null);
        }
        Job job2 = MCCoroutineKt.launch$default(this.getAtom(), MCCoroutineKt.regionDispatcher(this.getAtom(), strawLoc), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(remaining, strawLoc, this, items, null){
            int label;
            final /* synthetic */ long $remaining;
            final /* synthetic */ Location $strawLoc;
            final /* synthetic */ MoldFiringFeature this$0;
            final /* synthetic */ List<Object> $items;
            {
                this.$remaining = $remaining;
                this.$strawLoc = $strawLoc;
                this.this$0 = $receiver;
                this.$items = $items;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        this.label = 1;
                        v0 = DelayKt.delay(this.$remaining, this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        v1 = this.$strawLoc.clone().add(0.0, 1.0, 0.0).getBlock();
                        Intrinsics.checkNotNullExpressionValue(v1, "getBlock(...)");
                        camp = v1;
                        var4_4 = camp.getBlockData();
                        v2 = data = var4_4 instanceof Lightable != false ? (Lightable)var4_4 : null;
                        if ((camp.getType() == Material.CAMPFIRE || camp.getType() == Material.SOUL_CAMPFIRE) && data != null && data.isLit() && ((Collection)MoldFiringFeature.access$findAllValidClayMoldItems(this.this$0, this.$strawLoc)).isEmpty() == false) {
                            MoldFiringFeature.access$completeFiring(this.this$0, this.$strawLoc, this.$items);
                        }
                        MoldFiringFeature.access$getActive$p(this.this$0).remove(this.$strawLoc);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        Iterable $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void item;
            Object item$iv$iv;
            Object t2 = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var18_15 = item;
            collection.add(var18_15 instanceof ItemFrame ? ((ItemFrame)item).getLocation() : (var18_15 instanceof ItemDisplay ? ((ItemDisplay)item).getLocation() : strawLoc));
        }
        List itemLocs = (List)destination$iv$iv;
        this.active.put(strawLoc, new FiringJob(job2, startedAt, itemLocs));
        Atom.Companion.getInstance().getLogger().info("Mold firing scheduled for " + items.size() + " molds at " + strawLoc.getBlockX() + "," + strawLoc.getBlockY() + "," + strawLoc.getBlockZ() + " " + remaining / (long)1000 + "s");
    }

    private final void completeFiring(Location strawLoc, List<? extends Object> items) {
        World world = strawLoc.getWorld();
        if (world == null) {
            return;
        }
        World world2 = world;
        for (Object object : items) {
            ItemStack moldItem;
            Object object2 = object;
            Object object3 = object2 instanceof ItemFrame ? GroundItemUtils.INSTANCE.getGroundItem((ItemFrame)object) : (object2 instanceof ItemDisplay ? GroundItemDisplayUtils.INSTANCE.getGroundItem((ItemDisplay)object) : null);
            if (object3 == null || !Molds.INSTANCE.isMold(moldItem = object3)) continue;
            MoldShape shape = Molds.INSTANCE.getMoldShape(moldItem);
            ItemStack fired = (ItemStack)Molds.INSTANCE.getMold(shape, MoldType.Fired).buildItemStack();
            Object object32 = object;
            if (object32 instanceof ItemFrame) {
                GroundItemUtils.INSTANCE.setGroundItem((ItemFrame)object, fired, false);
                continue;
            }
            if (!(object32 instanceof ItemDisplay)) continue;
            GroundItemDisplayUtils.INSTANCE.setGroundItem((ItemDisplay)object, fired, false);
        }
        world2.playSound(strawLoc, Sound.BLOCK_LAVA_EXTINGUISH, 1.0f, 1.2f);
        world2.spawnParticle(Particle.FLAME, strawLoc, 20, 0.3, 0.3, 0.3, 0.02);
        Atom.Companion.getInstance().getLogger().info("Mold firing completed for " + items.size() + " molds at " + strawLoc.getBlockX() + "," + strawLoc.getBlockY() + "," + strawLoc.getBlockZ());
    }

    private final Object findValidClayMoldItem(Location strawLoc) {
        ItemStack item;
        ItemDisplay display = GroundItemDisplayUtils.findClosestGroundItem$default(GroundItemDisplayUtils.INSTANCE, strawLoc, 0.0, 2, null);
        if (display != null && (item = GroundItemDisplayUtils.isObstructed$default(GroundItemDisplayUtils.INSTANCE, display, null, Key.of((String)"atom:straw"), 2, null)) != null && Molds.INSTANCE.isMold(item) && Molds.INSTANCE.getMoldType(item) == MoldType.Clay) {
            Block block = strawLoc.clone().add(0.0, 1.0, 0.0).getBlock();
            Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
            Block camp = block;
            if (camp.getType() != Material.CAMPFIRE && camp.getType() != Material.SOUL_CAMPFIRE) {
                return null;
            }
            BlockData blockData = camp.getBlockData();
            Lightable lightable = blockData instanceof Lightable ? (Lightable)blockData : null;
            if (lightable == null) {
                return null;
            }
            Lightable data = lightable;
            if (!data.isLit()) {
                return null;
            }
            return display;
        }
        ItemFrame itemFrame = GroundItemUtils.findClosestGroundItem$default(GroundItemUtils.INSTANCE, strawLoc, 0.0, 2, null);
        if (itemFrame == null) {
            return null;
        }
        ItemFrame frame = itemFrame;
        ItemStack itemStack = GroundItemUtils.isObstructed$default(GroundItemUtils.INSTANCE, frame, null, Key.of((String)"atom:straw"), 2, null);
        if (itemStack == null) {
            return null;
        }
        ItemStack item2 = itemStack;
        if (!Molds.INSTANCE.isMold(item2) || Molds.INSTANCE.getMoldType(item2) != MoldType.Clay) {
            return null;
        }
        Block block = strawLoc.clone().add(0.0, 1.0, 0.0).getBlock();
        Intrinsics.checkNotNullExpressionValue(block, "getBlock(...)");
        Block camp = block;
        if (camp.getType() != Material.CAMPFIRE && camp.getType() != Material.SOUL_CAMPFIRE) {
            return null;
        }
        BlockData blockData = camp.getBlockData();
        Lightable lightable = blockData instanceof Lightable ? (Lightable)blockData : null;
        if (lightable == null) {
            return null;
        }
        Lightable data = lightable;
        if (!data.isLit()) {
            return null;
        }
        return frame;
    }

    private final List<Object> findAllValidClayMoldItems(Location strawLoc) {
        List validItems = new ArrayList();
        List<ItemDisplay> displays = GroundItemDisplayUtils.INSTANCE.findAllGroundItems(strawLoc);
        for (ItemDisplay display : displays) {
            Lightable data;
            Block camp;
            ItemStack item = GroundItemDisplayUtils.isObstructed$default(GroundItemDisplayUtils.INSTANCE, display, null, Key.of((String)"atom:straw"), 2, null);
            if (item == null || !Molds.INSTANCE.isMold(item) || Molds.INSTANCE.getMoldType(item) != MoldType.Clay) continue;
            Intrinsics.checkNotNullExpressionValue(strawLoc.clone().add(0.0, 1.0, 0.0).getBlock(), "getBlock(...)");
            if (camp.getType() != Material.CAMPFIRE && camp.getType() != Material.SOUL_CAMPFIRE) continue;
            BlockData blockData = camp.getBlockData();
            Lightable lightable = blockData instanceof Lightable ? (Lightable)blockData : null;
            if (lightable == null || !(data = lightable).isLit()) continue;
            validItems.add(display);
        }
        if (!((Collection)validItems).isEmpty()) {
            return validItems;
        }
        List<ItemFrame> frames = GroundItemUtils.INSTANCE.findAllGroundItems(strawLoc);
        for (ItemFrame frame : frames) {
            Lightable data;
            Block camp;
            ItemStack item;
            if (GroundItemUtils.isObstructed$default(GroundItemUtils.INSTANCE, frame, null, Key.of((String)"atom:straw"), 2, null) == null || !Molds.INSTANCE.isMold(item) || Molds.INSTANCE.getMoldType(item) != MoldType.Clay) continue;
            Intrinsics.checkNotNullExpressionValue(strawLoc.clone().add(0.0, 1.0, 0.0).getBlock(), "getBlock(...)");
            if (camp.getType() != Material.CAMPFIRE && camp.getType() != Material.SOUL_CAMPFIRE) continue;
            BlockData blockData = camp.getBlockData();
            Lightable lightable = blockData instanceof Lightable ? (Lightable)blockData : null;
            if (lightable == null || !(data = lightable).isLit()) continue;
            validItems.add(frame);
        }
        return validItems;
    }

    public MoldFiringFeature() {
        this(0L, 1, null);
    }

    public static final /* synthetic */ List access$findAllValidClayMoldItems(MoldFiringFeature $this, Location strawLoc) {
        return $this.findAllValidClayMoldItems(strawLoc);
    }

    public static final /* synthetic */ long access$getFiringMs$p(MoldFiringFeature $this) {
        return $this.firingMs;
    }

    public static final /* synthetic */ void access$scheduleFiring(MoldFiringFeature $this, Location strawLoc, List items, long remaining, long startedAt) {
        $this.scheduleFiring(strawLoc, items, remaining, startedAt);
    }

    public static final /* synthetic */ void access$completeFiring(MoldFiringFeature $this, Location strawLoc, List items) {
        $this.completeFiring(strawLoc, items);
    }

    public static final /* synthetic */ Map access$getActive$p(MoldFiringFeature $this) {
        return $this.active;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/features/MoldFiringFeature$FiringJob;", "", "job", "Lkotlinx/coroutines/Job;", "startedAt", "", "items", "", "Lorg/bukkit/Location;", "<init>", "(Lkotlinx/coroutines/Job;JLjava/util/List;)V", "getJob", "()Lkotlinx/coroutines/Job;", "getStartedAt", "()J", "getItems", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Atom"})
    public static final class FiringJob {
        @NotNull
        private final Job job;
        private final long startedAt;
        @NotNull
        private final List<Location> items;

        public FiringJob(@NotNull Job job2, long startedAt, @NotNull List<? extends Location> items) {
            Intrinsics.checkNotNullParameter(job2, "job");
            Intrinsics.checkNotNullParameter(items, "items");
            this.job = job2;
            this.startedAt = startedAt;
            this.items = items;
        }

        @NotNull
        public final Job getJob() {
            return this.job;
        }

        public final long getStartedAt() {
            return this.startedAt;
        }

        @NotNull
        public final List<Location> getItems() {
            return this.items;
        }

        @NotNull
        public final Job component1() {
            return this.job;
        }

        public final long component2() {
            return this.startedAt;
        }

        @NotNull
        public final List<Location> component3() {
            return this.items;
        }

        @NotNull
        public final FiringJob copy(@NotNull Job job2, long startedAt, @NotNull List<? extends Location> items) {
            Intrinsics.checkNotNullParameter(job2, "job");
            Intrinsics.checkNotNullParameter(items, "items");
            return new FiringJob(job2, startedAt, items);
        }

        public static /* synthetic */ FiringJob copy$default(FiringJob firingJob, Job job2, long l, List list, int n, Object object) {
            if ((n & 1) != 0) {
                job2 = firingJob.job;
            }
            if ((n & 2) != 0) {
                l = firingJob.startedAt;
            }
            if ((n & 4) != 0) {
                list = firingJob.items;
            }
            return firingJob.copy(job2, l, list);
        }

        @NotNull
        public String toString() {
            return "FiringJob(job=" + this.job + ", startedAt=" + this.startedAt + ", items=" + this.items + ")";
        }

        public int hashCode() {
            int result = this.job.hashCode();
            result = result * 31 + Long.hashCode(this.startedAt);
            result = result * 31 + ((Object)this.items).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FiringJob)) {
                return false;
            }
            FiringJob firingJob = (FiringJob)other;
            if (!Intrinsics.areEqual(this.job, firingJob.job)) {
                return false;
            }
            if (this.startedAt != firingJob.startedAt) {
                return false;
            }
            return Intrinsics.areEqual(this.items, firingJob.items);
        }
    }
}

