/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.campfire.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.momirealms.craftengine.bukkit.item.DataComponentTypes;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Campfire;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.UtilKt;
import org.shotrush.atom.content.workstation.campfire.CampfireRegistry;
import org.shotrush.atom.content.workstation.core.WorkstationDataManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0002%&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\nH\u0016J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u0006J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u0006H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/features/UniversalFuelFeature;", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$Listener;", "<init>", "()V", "fuelQueues", "", "Lorg/bukkit/Location;", "", "Lorg/shotrush/atom/content/workstation/campfire/features/UniversalFuelFeature$QueuedFuel;", "tryAddFuel", "", "registry", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry;", "loc", "item", "Lorg/bukkit/inventory/ItemStack;", "(Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry;Lorg/bukkit/Location;Lorg/bukkit/inventory/ItemStack;)Ljava/lang/Long;", "getBurnTimeFromItem", "", "(Lorg/bukkit/inventory/ItemStack;)Ljava/lang/Integer;", "onCampfireExtinguished", "", "state", "Lorg/shotrush/atom/content/workstation/campfire/CampfireRegistry$CampfireState;", "reason", "", "onCampfireBroken", "onResumeTimerScheduled", "remainingMs", "processFuelQueue", "getFuelQueue", "", "isQueueFull", "", "persistFuelQueue", "loadFuelQueue", "clearPersistence", "QueuedFuel", "Companion", "Atom"})
@SourceDebugExtension(value={"SMAP\nUniversalFuelFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UniversalFuelFeature.kt\norg/shotrush/atom/content/workstation/campfire/features/UniversalFuelFeature\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n382#2,7:199\n1563#3:206\n1634#3,3:207\n774#3:211\n865#3,2:212\n1563#3:214\n1634#3,3:215\n1#4:210\n*S KotlinDebug\n*F\n+ 1 UniversalFuelFeature.kt\norg/shotrush/atom/content/workstation/campfire/features/UniversalFuelFeature\n*L\n41#1:199,7\n160#1:206\n160#1:207,3\n168#1:211\n168#1:212,2\n168#1:214\n168#1:215,3\n*E\n"})
public final class UniversalFuelFeature
implements CampfireRegistry.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Location, List<QueuedFuel>> fuelQueues = new LinkedHashMap();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Long tryAddFuel(@NotNull CampfireRegistry registry, @NotNull Location loc, @NotNull ItemStack item) {
        List queue;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(item, "item");
        Object object2 = loc.getBlock().getState();
        Campfire campfire = object2 instanceof Campfire ? (Campfire)object2 : null;
        if (campfire == null) {
            return null;
        }
        Campfire campfire2 = campfire;
        object2 = this.fuelQueues;
        Location key$iv = loc;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((queue = (List)object).size() >= 4) {
            return null;
        }
        Integer n = this.getBurnTimeFromItem(item);
        if (n == null) {
            return null;
        }
        int burnTimeSeconds = n;
        long burnTimeMs = (long)burnTimeSeconds * 1000L;
        queue.add(new QueuedFuel(burnTimeSeconds, System.currentTimeMillis()));
        this.persistFuelQueue(loc);
        Long endTime = registry.addFuel(loc, burnTimeMs);
        return endTime;
    }

    private final Integer getBurnTimeFromItem(ItemStack item) {
        Item item2 = CraftEngine.instance().itemManager().wrap((Object)item);
        Intrinsics.checkNotNullExpressionValue(item2, "wrap(...)");
        Item wrappedItem = item2;
        try {
            int burnTime;
            Tag burnTimeTag;
            Tag customData = wrappedItem.getSparrowNBTComponent(DataComponentTypes.CUSTOM_DATA);
            if (customData instanceof CompoundTag && (burnTimeTag = ((CompoundTag)customData).get("campfire_burn_time_seconds")) instanceof NumericTag && (burnTime = ((NumericTag)burnTimeTag).getAsInt()) > 0) {
                return burnTime;
            }
        }
        catch (Exception exception) {
        }
        return UtilKt.matches(item, "atom:straw") ? Integer.valueOf(90) : null;
    }

    @Override
    public void onCampfireExtinguished(@NotNull CampfireRegistry.CampfireState state, @NotNull String reason) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(reason, "reason");
        this.fuelQueues.remove(state.getLocation());
        this.clearPersistence(state.getLocation());
    }

    @Override
    public void onCampfireBroken(@NotNull CampfireRegistry.CampfireState state) {
        Intrinsics.checkNotNullParameter(state, "state");
        List<QueuedFuel> list = this.fuelQueues.remove(state.getLocation());
        if (list != null) {
            list.clear();
        }
        this.clearPersistence(state.getLocation());
    }

    @Override
    public void onResumeTimerScheduled(@NotNull CampfireRegistry.CampfireState state, long remainingMs) {
        Intrinsics.checkNotNullParameter(state, "state");
        List<QueuedFuel> queue = this.loadFuelQueue(state.getLocation());
        if (!((Collection)queue).isEmpty()) {
            this.fuelQueues.put(state.getLocation(), CollectionsKt.toMutableList((Collection)queue));
        }
    }

    public final void processFuelQueue(@NotNull Location loc, @NotNull CampfireRegistry registry) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(registry, "registry");
        List<QueuedFuel> list = this.fuelQueues.get(loc);
        if (list == null) {
            return;
        }
        List<QueuedFuel> queue = list;
        if (queue.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean hasChanges = false;
        Iterator<QueuedFuel> iterator2 = queue.iterator();
        while (iterator2.hasNext()) {
            QueuedFuel fuel = iterator2.next();
            long elapsed = now - fuel.getAddedAt();
            if (elapsed < (long)fuel.getBurnTimeSeconds() * 1000L) continue;
            iterator2.remove();
            hasChanges = true;
        }
        if (hasChanges) {
            this.persistFuelQueue(loc);
            if (queue.isEmpty()) {
                registry.extinguishAt(loc, "fuel_queue_empty");
            }
        }
    }

    @NotNull
    public final List<QueuedFuel> getFuelQueue(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        List<QueuedFuel> list = this.fuelQueues.get(loc);
        if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isQueueFull(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        List<QueuedFuel> list = this.fuelQueues.get(loc);
        return (list != null ? list.size() : 0) >= 4;
    }

    /*
     * WARNING - void declaration
     */
    private final void persistFuelQueue(Location loc) {
        Object object;
        WorkstationDataManager.WorkstationData workstationData;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                WorkstationDataManager.WorkstationData data;
                BlockPos pos = new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                workstationData = data = WorkstationDataManager.INSTANCE.getWorkstationData(pos, "campfire");
                object = this.fuelQueues.get(loc);
                if (object == null) break block3;
                Iterable iterable = (Iterable)object;
                WorkstationDataManager.WorkstationData workstationData2 = workstationData;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    QueuedFuel queuedFuel = (QueuedFuel)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getBurnTimeSeconds() + "," + it.getAddedAt());
                }
                workstationData = workstationData2;
                object = CollectionsKt.joinToString$default((List)destination$iv$iv, ";", null, null, 0, null, null, 62, null);
                if (object != null) break block4;
            }
            object = "";
        }
        workstationData.setFuelQueue((String)object);
    }

    /*
     * WARNING - void declaration
     */
    private final List<QueuedFuel> loadFuelQueue(Location loc) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        String string;
        Object v0;
        Iterable iterable;
        block4: {
            BlockPos pos = new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            iterable = WorkstationDataManager.INSTANCE.getAllWorkstations().values();
            for (Object t2 : iterable) {
                WorkstationDataManager.WorkstationData it2 = (WorkstationDataManager.WorkstationData)t2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it2.getPosition(), pos)) continue;
                v0 = t2;
                break block4;
            }
            v0 = null;
        }
        String[] stringArray = v0;
        if (stringArray == null || (string = stringArray.getFuelQueue()) == null) {
            return CollectionsKt.emptyList();
        }
        String dataString = string;
        stringArray = new String[]{";"};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)dataString, stringArray, false, 0, 6, null);
        boolean $i$f$filter = false;
        iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{","};
            List parts = StringsKt.split$default((CharSequence)entry, stringArray2, false, 0, 6, null);
            collection.add(parts.size() == 2 ? new QueuedFuel(Integer.parseInt((String)parts.get(0)), Long.parseLong((String)parts.get(1))) : null);
        }
        return CollectionsKt.filterNotNull((List)destination$iv$iv);
    }

    private final void clearPersistence(Location loc) {
        BlockPos pos = new BlockPos(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        WorkstationDataManager.WorkstationData data = WorkstationDataManager.INSTANCE.getWorkstationData(pos, "campfire");
        data.setFuelQueue("");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/features/UniversalFuelFeature$Companion;", "", "<init>", "()V", "createFuelItem", "Lorg/bukkit/inventory/ItemStack;", "baseItem", "burnTimeSeconds", "", "Atom"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ItemStack createFuelItem(@NotNull ItemStack baseItem, int burnTimeSeconds) {
            Intrinsics.checkNotNullParameter(baseItem, "baseItem");
            ItemStack itemStack = baseItem.clone();
            Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
            ItemStack item = itemStack;
            item.editPersistentDataContainer(arg_0 -> Companion.createFuelItem$lambda$0(burnTimeSeconds, arg_0));
            return item;
        }

        private static final void createFuelItem$lambda$0(int $burnTimeSeconds, PersistentDataContainer container) {
            container.set(new NamespacedKey("atom", "campfire_burn_time_seconds"), PersistentDataType.STRING, (Object)String.valueOf($burnTimeSeconds));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/shotrush/atom/content/workstation/campfire/features/UniversalFuelFeature$QueuedFuel;", "", "burnTimeSeconds", "", "addedAt", "", "<init>", "(IJ)V", "getBurnTimeSeconds", "()I", "getAddedAt", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "Atom"})
    public static final class QueuedFuel {
        private final int burnTimeSeconds;
        private final long addedAt;

        public QueuedFuel(int burnTimeSeconds, long addedAt) {
            this.burnTimeSeconds = burnTimeSeconds;
            this.addedAt = addedAt;
        }

        public final int getBurnTimeSeconds() {
            return this.burnTimeSeconds;
        }

        public final long getAddedAt() {
            return this.addedAt;
        }

        public final int component1() {
            return this.burnTimeSeconds;
        }

        public final long component2() {
            return this.addedAt;
        }

        @NotNull
        public final QueuedFuel copy(int burnTimeSeconds, long addedAt) {
            return new QueuedFuel(burnTimeSeconds, addedAt);
        }

        public static /* synthetic */ QueuedFuel copy$default(QueuedFuel queuedFuel, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = queuedFuel.burnTimeSeconds;
            }
            if ((n2 & 2) != 0) {
                l = queuedFuel.addedAt;
            }
            return queuedFuel.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "QueuedFuel(burnTimeSeconds=" + this.burnTimeSeconds + ", addedAt=" + this.addedAt + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.burnTimeSeconds);
            result = result * 31 + Long.hashCode(this.addedAt);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof QueuedFuel)) {
                return false;
            }
            QueuedFuel queuedFuel = (QueuedFuel)other;
            if (this.burnTimeSeconds != queuedFuel.burnTimeSeconds) {
                return false;
            }
            return this.addedAt == queuedFuel.addedAt;
        }
    }
}

