/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.clay_cauldron;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.entity.player.InteractionResult;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.Position;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.Vec3i;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Campfire;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.UtilKt;
import org.shotrush.atom.content.base.AtomBlockEntity;
import org.shotrush.atom.content.workstation.Workstations;
import org.shotrush.atom.content.workstation.clay_cauldron.ClayCauldronDynamicRenderer;
import org.shotrush.atom.item.Material;
import org.shotrush.atom.item.MoldShape;
import org.shotrush.atom.item.MoldType;
import org.shotrush.atom.item.Molds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u000207J\u0010\u00108\u001a\u0002032\u0006\u00104\u001a\u000205H\u0014J\b\u00109\u001a\u000203H\u0016J\u000e\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\u000eJ\u000e\u0010<\u001a\u00020\u00162\u0006\u0010;\u001a\u00020\u000eJ\u0006\u0010=\u001a\u000203J\u0006\u0010>\u001a\u000203J\u000e\u0010?\u001a\u0002032\u0006\u0010@\u001a\u00020\u000eJ&\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010;\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0015R\u0011\u0010\u001f\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0019R\u0014\u0010!\u001a\u00020\u0016X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u0011\u0010#\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0019R\u0011\u0010%\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u0011\u0010'\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0019R$\u0010)\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0019\"\u0004\b+\u0010\u001bR(\u0010-\u001a\u0004\u0018\u00010,2\b\u0010\u0011\u001a\u0004\u0018\u00010,@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u0006I"}, d2={"Lorg/shotrush/atom/content/workstation/clay_cauldron/ClayCauldronBlockEntity;", "Lorg/shotrush/atom/content/base/AtomBlockEntity;", "pos", "Lnet/momirealms/craftengine/core/world/BlockPos;", "blockState", "Lnet/momirealms/craftengine/core/block/ImmutableBlockState;", "<init>", "(Lnet/momirealms/craftengine/core/world/BlockPos;Lnet/momirealms/craftengine/core/block/ImmutableBlockState;)V", "allowedItems", "", "", "getAllowedItems", "()Ljava/util/List;", "fluidAsItem", "Lorg/bukkit/inventory/ItemStack;", "getFluidAsItem", "()Lorg/bukkit/inventory/ItemStack;", "value", "currentlyConsuming", "getCurrentlyConsuming", "setCurrentlyConsuming", "(Lorg/bukkit/inventory/ItemStack;)V", "", "consumingProgress", "getConsumingProgress", "()I", "setConsumingProgress", "(I)V", "storedItem", "getStoredItem", "setStoredItem", "TICKS_TO_MELT", "getTICKS_TO_MELT", "FLUID_PER_RAW", "getFLUID_PER_RAW", "FLUID_PER_TICK", "getFLUID_PER_TICK", "FLUID_PER_INGOT", "getFLUID_PER_INGOT", "MAX_FLUID", "getMAX_FLUID", "fluidStored", "getFluidStored", "setFluidStored", "Lorg/shotrush/atom/item/Material;", "fluid", "getFluid", "()Lorg/shotrush/atom/item/Material;", "setFluid", "(Lorg/shotrush/atom/item/Material;)V", "loadCustomData", "", "tag", "Lnet/momirealms/craftengine/libraries/nbt/CompoundTag;", "isLitCampfireUnderneath", "", "saveCustomData", "preRemove", "canStoreItem", "item", "amountToStore", "tickConsumption", "tick", "storeItem", "clone", "fillMold", "Lnet/momirealms/craftengine/core/entity/player/InteractionResult;", "player", "Lorg/bukkit/entity/Player;", "type", "Lorg/shotrush/atom/item/MoldType;", "shape", "Lorg/shotrush/atom/item/MoldShape;", "Atom"})
@SourceDebugExtension(value={"SMAP\nClayCauldronBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClayCauldronBlockEntity.kt\norg/shotrush/atom/content/workstation/clay_cauldron/ClayCauldronBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n2746#2,3:192\n*S KotlinDebug\n*F\n+ 1 ClayCauldronBlockEntity.kt\norg/shotrush/atom/content/workstation/clay_cauldron/ClayCauldronBlockEntity\n*L\n126#1:192,3\n*E\n"})
public final class ClayCauldronBlockEntity
extends AtomBlockEntity {
    @NotNull
    private final List<String> allowedItems;
    @NotNull
    private ItemStack currentlyConsuming;
    private int consumingProgress;
    @NotNull
    private ItemStack storedItem;
    private final int TICKS_TO_MELT;
    private final int FLUID_PER_RAW;
    private final int FLUID_PER_TICK;
    private final int FLUID_PER_INGOT;
    private final int MAX_FLUID;
    private int fluidStored;
    @Nullable
    private Material fluid;

    public ClayCauldronBlockEntity(@NotNull BlockPos pos, @NotNull ImmutableBlockState blockState) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        super(Workstations.INSTANCE.getCLAY_CAULDRON(), pos, blockState);
        String[] stringArray = new String[]{"minecraft:raw_iron", "minecraft:raw_copper"};
        this.allowedItems = CollectionsKt.listOf(stringArray);
        ItemStack itemStack = ItemStack.empty();
        Intrinsics.checkNotNullExpressionValue(itemStack, "empty(...)");
        this.currentlyConsuming = itemStack;
        ItemStack itemStack2 = ItemStack.empty();
        Intrinsics.checkNotNullExpressionValue(itemStack2, "empty(...)");
        this.storedItem = itemStack2;
        this.TICKS_TO_MELT = 200;
        this.FLUID_PER_RAW = 1000;
        this.FLUID_PER_TICK = this.FLUID_PER_RAW / this.TICKS_TO_MELT;
        this.FLUID_PER_INGOT = this.FLUID_PER_RAW * 9;
        this.MAX_FLUID = this.FLUID_PER_INGOT * 4;
        this.blockEntityRenderer = new ClayCauldronDynamicRenderer(this);
    }

    @NotNull
    public final List<String> getAllowedItems() {
        return this.allowedItems;
    }

    @NotNull
    public final ItemStack getFluidAsItem() {
        ItemStack itemStack;
        ItemStack itemStack2;
        if (this.fluid == null) {
            ItemStack itemStack3 = ItemStack.empty();
            Intrinsics.checkNotNullExpressionValue(itemStack3, "empty(...)");
            return itemStack3;
        }
        Material material = this.fluid;
        CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)(switch (material == null ? -1 : WhenMappings.$EnumSwitchMapping$0[material.ordinal()]) {
            case 1 -> "atom:copper_fluid_layer";
            case 2 -> "atom:iron_fluid_layer";
            default -> "atom:lava_fluid_layer";
        })));
        if (customItem != null && (itemStack2 = (ItemStack)customItem.buildItemStack()) != null) {
            itemStack = itemStack2;
        } else {
            ItemStack itemStack4 = ItemStack.empty();
            itemStack = itemStack4;
            Intrinsics.checkNotNullExpressionValue(itemStack4, "empty(...)");
        }
        return itemStack;
    }

    @NotNull
    public final ItemStack getCurrentlyConsuming() {
        return this.currentlyConsuming;
    }

    private final void setCurrentlyConsuming(ItemStack value) {
        this.currentlyConsuming = value;
        this.markDirty(false);
    }

    public final int getConsumingProgress() {
        return this.consumingProgress;
    }

    private final void setConsumingProgress(int value) {
        this.consumingProgress = value;
        this.markDirty(false);
    }

    @NotNull
    public final ItemStack getStoredItem() {
        ItemStack itemStack;
        if (this.storedItem.isEmpty()) {
            ItemStack itemStack2 = ItemStack.empty();
            itemStack = itemStack2;
            Intrinsics.checkNotNullExpressionValue(itemStack2, "empty(...)");
        } else {
            itemStack = this.storedItem;
        }
        return itemStack;
    }

    private final void setStoredItem(ItemStack value) {
        this.storedItem = value;
        AtomBlockEntity.markDirty$default(this, false, 1, null);
    }

    public final int getTICKS_TO_MELT() {
        return this.TICKS_TO_MELT;
    }

    public final int getFLUID_PER_RAW() {
        return this.FLUID_PER_RAW;
    }

    public final int getFLUID_PER_TICK() {
        return this.FLUID_PER_TICK;
    }

    public final int getFLUID_PER_INGOT() {
        return this.FLUID_PER_INGOT;
    }

    public final int getMAX_FLUID() {
        return this.MAX_FLUID;
    }

    public final int getFluidStored() {
        return this.fluidStored;
    }

    private final void setFluidStored(int value) {
        this.fluidStored = value;
        AtomBlockEntity.markDirty$default(this, false, 1, null);
    }

    @Nullable
    public final Material getFluid() {
        return this.fluid;
    }

    private final void setFluid(Material value) {
        this.fluid = value;
        AtomBlockEntity.markDirty$default(this, false, 1, null);
    }

    public void loadCustomData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        if (tag.containsKey("storedItem")) {
            this.setStoredItem(UtilKt.getItemStack(tag, "storedItem"));
        }
        this.setFluidStored(tag.getInt("fluidStored"));
        this.setConsumingProgress(tag.getInt("consumingProgress"));
        if (tag.containsKey("fluid")) {
            String string = tag.getString("fluid");
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            this.setFluid(Material.Companion.byId(string));
        }
        if (tag.containsKey("currentlyConsuming")) {
            this.setCurrentlyConsuming(UtilKt.getItemStack(tag, "currentlyConsuming"));
        }
    }

    public final boolean isLitCampfireUnderneath() {
        Object object = this.world.world.platformWorld();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bukkit.World");
        Block block = ((World)object).getBlockAt(this.pos.x(), this.pos.y() - 1, this.pos.z());
        Intrinsics.checkNotNullExpressionValue(block, "getBlockAt(...)");
        Block blockState = block;
        BlockData blockData = blockState.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "getBlockData(...)");
        BlockData data = blockData;
        if (!(data instanceof Campfire)) {
            return false;
        }
        return ((Campfire)data).isLit();
    }

    protected void saveCustomData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        if (!this.getStoredItem().isEmpty()) {
            UtilKt.putItemStack(tag, "storedItem", this.getStoredItem());
        }
        tag.putInt("fluidStored", this.fluidStored);
        tag.putInt("consumingProgress", this.consumingProgress);
        if (this.fluid != null) {
            Material material = this.fluid;
            Intrinsics.checkNotNull((Object)material);
            tag.putString("fluid", material.getId());
        }
        if (!this.currentlyConsuming.isEmpty()) {
            UtilKt.putItemStack(tag, "currentlyConsuming", this.currentlyConsuming);
        }
    }

    public void preRemove() {
        Vec3d pos = Vec3d.atCenterOf((Vec3i)((Vec3i)this.pos));
        if (!this.getStoredItem().isEmpty()) {
            this.world.world().dropItemNaturally((Position)pos, BukkitItemManager.instance().wrap(this.getStoredItem()));
        }
    }

    public final boolean canStoreItem(@NotNull ItemStack item) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter(item, "item");
            if (item.isEmpty()) {
                return false;
            }
            Iterable $this$none$iv = this.allowedItems;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!UtilKt.matches(item, it)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        if (this.fluid != null) {
            if (this.fluid == Material.Copper && !UtilKt.matches(item, "minecraft:raw_copper")) {
                return false;
            }
            if (this.fluid == Material.Iron && !UtilKt.matches(item, "minecraft:raw_iron")) {
                return false;
            }
        }
        return this.getStoredItem().isEmpty() || this.getStoredItem().isSimilar(item) && this.getStoredItem().getAmount() != this.getStoredItem().getMaxStackSize();
    }

    public final int amountToStore(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(item, "item");
        if (item.isEmpty()) {
            return 0;
        }
        if (this.getStoredItem().isEmpty()) {
            return RangesKt.coerceAtMost(item.getMaxStackSize(), item.getAmount());
        }
        if (!this.getStoredItem().isSimilar(item)) {
            return 0;
        }
        return RangesKt.coerceAtMost(this.getStoredItem().getMaxStackSize() - this.getStoredItem().getAmount(), item.getAmount());
    }

    /*
     * WARNING - void declaration
     */
    public final void tickConsumption() {
        if (this.currentlyConsuming.isEmpty()) {
            void $this$tickConsumption_u24lambda_u240;
            ItemStack itemStack;
            if (this.getStoredItem().isEmpty()) {
                return;
            }
            ItemStack itemStack2 = this.getStoredItem().clone();
            Intrinsics.checkNotNullExpressionValue(itemStack2, "clone(...)");
            ItemStack itemStack3 = itemStack = itemStack2;
            ClayCauldronBlockEntity clayCauldronBlockEntity = this;
            boolean bl = false;
            $this$tickConsumption_u24lambda_u240.setAmount(1);
            clayCauldronBlockEntity.setCurrentlyConsuming(itemStack);
            itemStack = this.getStoredItem();
            int n = itemStack.getAmount();
            itemStack.setAmount(n + -1);
            AtomBlockEntity.markDirty$default(this, false, 1, null);
            return;
        }
        if (this.fluidStored + this.FLUID_PER_TICK >= this.MAX_FLUID) {
            return;
        }
        if (this.consumingProgress >= this.TICKS_TO_MELT) {
            this.setConsumingProgress(0);
            ItemStack itemStack = this.currentlyConsuming;
            int n = itemStack.getAmount();
            itemStack.setAmount(n + -1);
        } else {
            int n = this.consumingProgress;
            this.setConsumingProgress(n + 1);
            this.setFluid(UtilKt.matches(this.currentlyConsuming, "minecraft:raw_copper") ? Material.Copper : Material.Iron);
            this.setFluidStored(this.fluidStored + this.FLUID_PER_TICK);
        }
    }

    public final void tick() {
        if (this.isLitCampfireUnderneath()) {
            this.tickConsumption();
        }
    }

    public final void storeItem(@NotNull ItemStack clone) {
        Intrinsics.checkNotNullParameter(clone, "clone");
        if (clone.isEmpty()) {
            return;
        }
        if (this.getStoredItem().isEmpty()) {
            this.setStoredItem(clone);
            return;
        }
        if (this.getStoredItem().isSimilar(clone)) {
            ItemStack itemStack = this.getStoredItem();
            itemStack.setAmount(itemStack.getAmount() + clone.getAmount());
            AtomBlockEntity.markDirty$default(this, false, 1, null);
        }
    }

    @NotNull
    public final InteractionResult fillMold(@NotNull Player player, @NotNull ItemStack item, @NotNull MoldType type, @NotNull MoldShape shape) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter((Object)shape, "shape");
        if (this.fluid == null) {
            return InteractionResult.PASS;
        }
        if (this.fluidStored < this.FLUID_PER_INGOT) {
            return InteractionResult.PASS;
        }
        int n = item.getAmount();
        item.setAmount(n + -1);
        this.setFluidStored(this.fluidStored - this.FLUID_PER_INGOT);
        Material material = this.fluid;
        Intrinsics.checkNotNull((Object)material);
        ItemStack filledMold = Molds.INSTANCE.getFilledMold(shape, type, material);
        ItemStack[] itemStackArray = new ItemStack[]{filledMold};
        player.getInventory().addItem(itemStackArray);
        if (this.fluidStored <= 0) {
            this.setFluid(null);
        }
        return InteractionResult.SUCCESS;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Material.values().length];
            try {
                nArray[Material.Copper.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.Iron.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

