/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.core;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.BlockPos;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.shotrush.atom.Atom;
import org.shotrush.atom.content.workstation.core.PlacedItem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u001eJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#J\b\u0010$\u001a\u00020\u0014H\u0002J\u0006\u0010%\u001a\u00020\u0014J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010'\u001a\u00020\u0014R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/shotrush/atom/content/workstation/core/WorkstationDataManager;", "", "<init>", "()V", "dataFile", "Ljava/io/File;", "getDataFile", "()Ljava/io/File;", "dataFile$delegate", "Lkotlin/Lazy;", "config", "Lorg/bukkit/configuration/file/YamlConfiguration;", "getConfig", "()Lorg/bukkit/configuration/file/YamlConfiguration;", "config$delegate", "workstationData", "", "", "Lorg/shotrush/atom/content/workstation/core/WorkstationDataManager$WorkstationData;", "initialize", "", "getWorkstationData", "pos", "Lnet/momirealms/craftengine/core/world/BlockPos;", "type", "removeWorkstationData", "getPlacedItems", "", "Lorg/shotrush/atom/content/workstation/core/PlacedItem;", "getAllWorkstations", "", "hasWorkstation", "", "updatePlacedItems", "items", "", "loadData", "saveData", "positionKey", "cleanupOrphanedData", "WorkstationData", "Atom"})
@SourceDebugExtension(value={"SMAP\nWorkstationDataManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkstationDataManager.kt\norg/shotrush/atom/content/workstation/core/WorkstationDataManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,272:1\n382#2,7:273\n1869#3,2:280\n1878#3,3:283\n1869#3,2:288\n1#4:282\n216#5,2:286\n*S KotlinDebug\n*F\n+ 1 WorkstationDataManager.kt\norg/shotrush/atom/content/workstation/core/WorkstationDataManager\n*L\n51#1:273,7\n63#1:280,2\n191#1:283,3\n253#1:288,2\n242#1:286,2\n*E\n"})
public final class WorkstationDataManager {
    @NotNull
    public static final WorkstationDataManager INSTANCE = new WorkstationDataManager();
    @NotNull
    private static final Lazy dataFile$delegate = LazyKt.lazy(WorkstationDataManager::dataFile_delegate$lambda$0);
    @NotNull
    private static final Lazy config$delegate = LazyKt.lazy(WorkstationDataManager::config_delegate$lambda$0);
    @NotNull
    private static final Map<String, WorkstationData> workstationData = new LinkedHashMap();

    private WorkstationDataManager() {
    }

    private final File getDataFile() {
        Lazy lazy = dataFile$delegate;
        return (File)lazy.getValue();
    }

    private final YamlConfiguration getConfig() {
        Lazy lazy = config$delegate;
        return (YamlConfiguration)lazy.getValue();
    }

    public final void initialize() {
        block0: {
            this.loadData();
            Atom atom = Atom.Companion.getInstance();
            if (atom == null) break block0;
            Atom plugin = atom;
            boolean bl = false;
            Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)plugin, WorkstationDataManager::initialize$lambda$0$0, 5L, 5L, TimeUnit.MINUTES);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> WorkstationDataManager.initialize$lambda$0$1(plugin)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final WorkstationData getWorkstationData(@NotNull BlockPos pos, @NotNull String type) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(type, "type");
        String key = this.positionKey(pos);
        Map<String, WorkstationData> map2 = workstationData;
        String key$iv = key;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            WorkstationData answer$iv = new WorkstationData(pos, type, new ArrayList(), null, null, 16, null);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (WorkstationData)object;
    }

    public final void removeWorkstationData(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        String key = this.positionKey(pos);
        WorkstationData data = workstationData.remove(key);
        this.getConfig().set(key, null);
        Object object = data;
        if (object != null && (object = ((WorkstationData)object).getPlacedItems()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UUID uuid;
                PlacedItem placedItem = (PlacedItem)element$iv;
                boolean bl = false;
                if (placedItem.getDisplayUUID() == null) continue;
                boolean bl2 = false;
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null) continue;
                entity.remove();
            }
        }
        Atom.Companion.getInstance().getLogger().info("Removed workstation data for " + key);
    }

    @NotNull
    public final List<PlacedItem> getPlacedItems(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        String key = this.positionKey(pos);
        Object object = workstationData.get(key);
        if (object == null || (object = ((WorkstationData)object).getPlacedItems()) == null) {
            object = new ArrayList();
        }
        return object;
    }

    @NotNull
    public final Map<String, WorkstationData> getAllWorkstations() {
        return MapsKt.toMap(workstationData);
    }

    public final boolean hasWorkstation(@NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        String key = this.positionKey(pos);
        return workstationData.containsKey(key);
    }

    public final void updatePlacedItems(@NotNull BlockPos pos, @NotNull List<PlacedItem> items) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(items, "items");
        String key = this.positionKey(pos);
        WorkstationData data = workstationData.get(key);
        if (data != null) {
            data.getPlacedItems().clear();
            data.getPlacedItems().addAll((Collection<PlacedItem>)items);
        } else {
            String type = StringsKt.substringBefore$default(StringsKt.substringAfter$default(key, "_", null, 2, null), "_", null, 2, null);
            workstationData.put(key, new WorkstationData(pos, "unknown", CollectionsKt.toMutableList((Collection)items), null, null, 16, null));
        }
    }

    private final void loadData() {
        workstationData.clear();
        for (String key : this.getConfig().getKeys(false)) {
            String type;
            Object itemKey2;
            ConfigurationSection section;
            if (this.getConfig().getConfigurationSection(key) == null || section.getString("type") == null) continue;
            String string = section.getString("world");
            if (string == null) {
                string = "world";
            }
            String worldName = string;
            int x = section.getInt("x");
            int y = section.getInt("y");
            int z = section.getInt("z");
            BlockPos pos = new BlockPos(x, y, z);
            List placedItems = new ArrayList();
            ConfigurationSection itemsSection = section.getConfigurationSection("items");
            if (itemsSection != null) {
                for (Object itemKey2 : itemsSection.getKeys(false)) {
                    UUID uUID;
                    ItemStack item;
                    ItemStack itemStack;
                    ItemStack itemStack2;
                    ConfigurationSection itemSection;
                    if (itemsSection.getConfigurationSection((String)itemKey2) == null || itemSection.getString("material") == null) continue;
                    int amount = itemSection.getInt("amount", 1);
                    String customItemId = itemSection.getString("custom_item_id");
                    float posX = (float)itemSection.getDouble("pos_x", 0.0);
                    float posY = (float)itemSection.getDouble("pos_y", 0.0);
                    float posZ = (float)itemSection.getDouble("pos_z", 0.0);
                    float yaw = (float)itemSection.getDouble("yaw", 0.0);
                    String displayUuidString = itemSection.getString("display_uuid");
                    if (customItemId != null) {
                        ItemStack itemStack3;
                        CustomItem customItem = CraftEngineItems.byId((Key)Key.of((String)customItemId));
                        if (customItem != null && (itemStack3 = (ItemStack)customItem.buildItemStack()) != null) {
                            ItemStack itemStack4;
                            ItemStack $this$loadData_u24lambda_u240 = itemStack4 = itemStack3;
                            boolean bl = false;
                            $this$loadData_u24lambda_u240.setAmount(amount);
                            itemStack2 = itemStack4;
                        } else {
                            itemStack2 = null;
                        }
                    } else {
                        itemStack2 = itemStack = null;
                    }
                    if (itemStack2 == null) {
                        String material;
                        WorkstationDataManager $this$loadData_u24lambda_u241 = this;
                        boolean bl = false;
                        Material bukkitMaterial = Material.getMaterial((String)material);
                        itemStack = bukkitMaterial != null ? new ItemStack(bukkitMaterial, amount) : null;
                    }
                    if ((item = itemStack) == null) continue;
                    Vector3f position = new Vector3f(posX, posY, posZ);
                    if (displayUuidString != null) {
                        String it;
                        boolean bl = false;
                        uUID = UUID.fromString(it);
                    } else {
                        uUID = null;
                    }
                    UUID displayUuid = uUID;
                    placedItems.add(new PlacedItem(item, position, yaw, displayUuid));
                }
            }
            itemKey2 = section.getLong("curing_start_time", 0L);
            long it = ((Number)itemKey2).longValue();
            boolean bl = false;
            Object curingStartTime = it > 0L ? itemKey2 : null;
            String string2 = section.getString("fuel_queue", "");
            if (string2 == null) {
                string2 = "";
            }
            String fuelQueue = string2;
            workstationData.put(key, new WorkstationData(pos, type, placedItems, (Long)curingStartTime, fuelQueue));
        }
        Atom.Companion.getInstance().getLogger().info("Loaded " + workstationData.size() + " workstation data entries");
    }

    /*
     * WARNING - void declaration
     */
    public final void saveData() {
        for (String entry : this.getConfig().getKeys(false)) {
            this.getConfig().set(entry, null);
        }
        for (Map.Entry entry : workstationData.entrySet()) {
            ConfigurationSection section;
            String key = (String)entry.getKey();
            WorkstationData data = (WorkstationData)entry.getValue();
            Intrinsics.checkNotNullExpressionValue(this.getConfig().createSection(key), "createSection(...)");
            section.set("type", (Object)data.getType());
            section.set("world", (Object)"world");
            section.set("x", (Object)data.getPosition().x());
            section.set("y", (Object)data.getPosition().y());
            section.set("z", (Object)data.getPosition().z());
            if (!((Collection)data.getPlacedItems()).isEmpty()) {
                Intrinsics.checkNotNullExpressionValue(section.createSection("items"), "createSection(...)");
                Iterable $this$forEachIndexed$iv = data.getPlacedItems();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void placedItem;
                    ConfigurationSection itemSection;
                    ConfigurationSection itemsSection;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    PlacedItem placedItem2 = (PlacedItem)item$iv;
                    int index = n;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue(itemsSection.createSection("item_" + index), "createSection(...)");
                    itemSection.set("material", (Object)placedItem.getItem().getType().name());
                    itemSection.set("amount", (Object)placedItem.getItem().getAmount());
                    Key customItemId = CraftEngineItems.getCustomItemId((ItemStack)placedItem.getItem());
                    if (customItemId != null) {
                        itemSection.set("custom_item_id", (Object)customItemId.value());
                    }
                    itemSection.set("pos_x", (Object)placedItem.getPosition().x);
                    itemSection.set("pos_y", (Object)placedItem.getPosition().y);
                    itemSection.set("pos_z", (Object)placedItem.getPosition().z);
                    itemSection.set("yaw", (Object)placedItem.getYaw());
                    if (placedItem.getDisplayUUID() != null) {
                        UUID it;
                        boolean bl2 = false;
                        itemSection.set("display_uuid", (Object)it.toString());
                    }
                }
            }
            Long l = data.getCuringStartTime();
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                section.set("curing_start_time", (Object)it);
            }
            if (!(((CharSequence)data.getFuelQueue()).length() > 0)) continue;
            section.set("fuel_queue", (Object)data.getFuelQueue());
        }
        try {
            this.getConfig().save(this.getDataFile());
        }
        catch (Exception e) {
            Atom.Companion.getInstance().getLogger().severe("Failed to save workstation data: " + e.getMessage());
        }
    }

    private final String positionKey(BlockPos pos) {
        return "world_" + pos.x() + "_" + pos.y() + "_" + pos.z();
    }

    public final void cleanupOrphanedData() {
        Map.Entry<String, WorkstationData> element$iv;
        World world = Bukkit.getWorld((String)"world");
        if (world == null) {
            return;
        }
        World world2 = world;
        List toRemove = new ArrayList();
        Object $this$forEach$iv = workstationData;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, WorkstationData>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Block block;
            Map.Entry<String, WorkstationData> entry = element$iv = iterator2.next();
            boolean bl = false;
            String key = entry.getKey();
            WorkstationData data = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(world2.getBlockAt(data.getPosition().x(), data.getPosition().y(), data.getPosition().z()), "getBlockAt(...)");
            ImmutableBlockState state = CraftEngineBlocks.getCustomBlockState((Block)block);
            if (state != null && state.owner().matchesKey(Key.of((String)("atom:" + data.getType())))) continue;
            toRemove.add(data.getPosition());
            Atom.Companion.getInstance().getLogger().info("Found orphaned workstation data at " + data.getPosition() + ", cleaning up");
        }
        $this$forEach$iv = toRemove;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            BlockPos pos = (BlockPos)element$iv;
            boolean bl = false;
            INSTANCE.removeWorkstationData(pos);
        }
        if (!((Collection)toRemove).isEmpty()) {
            this.saveData();
            Atom.Companion.getInstance().getLogger().info("Cleaned up " + toRemove.size() + " orphaned workstation entries");
        }
    }

    private static final File dataFile_delegate$lambda$0() {
        File file;
        File $this$dataFile_delegate_u24lambda_u240_u240 = file = new File(Atom.Companion.getInstance().getDataFolder(), "workstations.yml");
        boolean bl = false;
        if (!$this$dataFile_delegate_u24lambda_u240_u240.exists()) {
            File file2 = $this$dataFile_delegate_u24lambda_u240_u240.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            $this$dataFile_delegate_u24lambda_u240_u240.createNewFile();
        }
        return file;
    }

    private static final YamlConfiguration config_delegate$lambda$0() {
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)INSTANCE.getDataFile());
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        return yamlConfiguration;
    }

    private static final void initialize$lambda$0$0(ScheduledTask scheduledTask) {
        INSTANCE.saveData();
    }

    private static final void initialize$lambda$0$1(Atom $plugin) {
        INSTANCE.saveData();
        $plugin.getLogger().info("Saved workstation data on shutdown");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0015J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003JH\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lorg/shotrush/atom/content/workstation/core/WorkstationDataManager$WorkstationData;", "", "position", "Lnet/momirealms/craftengine/core/world/BlockPos;", "type", "", "placedItems", "", "Lorg/shotrush/atom/content/workstation/core/PlacedItem;", "curingStartTime", "", "fuelQueue", "<init>", "(Lnet/momirealms/craftengine/core/world/BlockPos;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;Ljava/lang/String;)V", "getPosition", "()Lnet/momirealms/craftengine/core/world/BlockPos;", "getType", "()Ljava/lang/String;", "getPlacedItems", "()Ljava/util/List;", "getCuringStartTime", "()Ljava/lang/Long;", "setCuringStartTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getFuelQueue", "setFuelQueue", "(Ljava/lang/String;)V", "component1", "component2", "component3", "component4", "component5", "copy", "(Lnet/momirealms/craftengine/core/world/BlockPos;Ljava/lang/String;Ljava/util/List;Ljava/lang/Long;Ljava/lang/String;)Lorg/shotrush/atom/content/workstation/core/WorkstationDataManager$WorkstationData;", "equals", "", "other", "hashCode", "", "toString", "Atom"})
    public static final class WorkstationData {
        @NotNull
        private final BlockPos position;
        @NotNull
        private final String type;
        @NotNull
        private final List<PlacedItem> placedItems;
        @Nullable
        private Long curingStartTime;
        @NotNull
        private String fuelQueue;

        public WorkstationData(@NotNull BlockPos position, @NotNull String type, @NotNull List<PlacedItem> placedItems, @Nullable Long curingStartTime, @NotNull String fuelQueue) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(type, "type");
            Intrinsics.checkNotNullParameter(placedItems, "placedItems");
            Intrinsics.checkNotNullParameter(fuelQueue, "fuelQueue");
            this.position = position;
            this.type = type;
            this.placedItems = placedItems;
            this.curingStartTime = curingStartTime;
            this.fuelQueue = fuelQueue;
        }

        public /* synthetic */ WorkstationData(BlockPos blockPos, String string, List list, Long l, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                l = null;
            }
            if ((n & 0x10) != 0) {
                string2 = "";
            }
            this(blockPos, string, list, l, string2);
        }

        @NotNull
        public final BlockPos getPosition() {
            return this.position;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final List<PlacedItem> getPlacedItems() {
            return this.placedItems;
        }

        @Nullable
        public final Long getCuringStartTime() {
            return this.curingStartTime;
        }

        public final void setCuringStartTime(@Nullable Long l) {
            this.curingStartTime = l;
        }

        @NotNull
        public final String getFuelQueue() {
            return this.fuelQueue;
        }

        public final void setFuelQueue(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.fuelQueue = string;
        }

        @NotNull
        public final BlockPos component1() {
            return this.position;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final List<PlacedItem> component3() {
            return this.placedItems;
        }

        @Nullable
        public final Long component4() {
            return this.curingStartTime;
        }

        @NotNull
        public final String component5() {
            return this.fuelQueue;
        }

        @NotNull
        public final WorkstationData copy(@NotNull BlockPos position, @NotNull String type, @NotNull List<PlacedItem> placedItems, @Nullable Long curingStartTime, @NotNull String fuelQueue) {
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(type, "type");
            Intrinsics.checkNotNullParameter(placedItems, "placedItems");
            Intrinsics.checkNotNullParameter(fuelQueue, "fuelQueue");
            return new WorkstationData(position, type, placedItems, curingStartTime, fuelQueue);
        }

        public static /* synthetic */ WorkstationData copy$default(WorkstationData workstationData, BlockPos blockPos, String string, List list, Long l, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = workstationData.position;
            }
            if ((n & 2) != 0) {
                string = workstationData.type;
            }
            if ((n & 4) != 0) {
                list = workstationData.placedItems;
            }
            if ((n & 8) != 0) {
                l = workstationData.curingStartTime;
            }
            if ((n & 0x10) != 0) {
                string2 = workstationData.fuelQueue;
            }
            return workstationData.copy(blockPos, string, list, l, string2);
        }

        @NotNull
        public String toString() {
            return "WorkstationData(position=" + this.position + ", type=" + this.type + ", placedItems=" + this.placedItems + ", curingStartTime=" + this.curingStartTime + ", fuelQueue=" + this.fuelQueue + ")";
        }

        public int hashCode() {
            int result = this.position.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + ((Object)this.placedItems).hashCode();
            result = result * 31 + (this.curingStartTime == null ? 0 : ((Object)this.curingStartTime).hashCode());
            result = result * 31 + this.fuelQueue.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WorkstationData)) {
                return false;
            }
            WorkstationData workstationData = (WorkstationData)other;
            if (!Intrinsics.areEqual(this.position, workstationData.position)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.type, workstationData.type)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.placedItems, workstationData.placedItems)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.curingStartTime, workstationData.curingStartTime)) {
                return false;
            }
            return Intrinsics.areEqual(this.fuelQueue, workstationData.fuelQueue);
        }
    }
}

