/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.knapping;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.content.workstation.knapping.KnappingMaterial;
import org.shotrush.atom.content.workstation.knapping.KnappingRecipe;
import org.shotrush.atom.content.workstation.knapping.KnappingRecipesKt;
import org.shotrush.atom.content.workstation.knapping.Pattern;
import org.shotrush.atom.content.workstation.knapping.PatternSetBuilder;
import org.shotrush.atom.item.MoldShape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\u0002\b\u0018J'\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\u0002\b\u0018J\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000b2\u0006\u0010\u001c\u001a\u00020\u0014R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/shotrush/atom/content/workstation/knapping/KnappingRecipes;", "", "<init>", "()V", "recipes", "", "", "Lorg/shotrush/atom/content/workstation/knapping/KnappingRecipe;", "getRecipes", "()Ljava/util/Map;", "allRecipes", "", "getAllRecipes", "()Ljava/util/List;", "register", "", "shape", "Lorg/shotrush/atom/item/MoldShape;", "allowed", "", "Lorg/shotrush/atom/content/workstation/knapping/KnappingMaterial;", "block", "Lkotlin/Function1;", "Lorg/shotrush/atom/content/workstation/knapping/PatternSetBuilder;", "Lkotlin/ExtensionFunctionType;", "getResult", "gridColumnMajor", "", "material", "Atom"})
public final class KnappingRecipes {
    @NotNull
    public static final KnappingRecipes INSTANCE = new KnappingRecipes();
    @NotNull
    private static final Map<String, KnappingRecipe> recipes = new LinkedHashMap();

    private KnappingRecipes() {
    }

    @NotNull
    public final Map<String, KnappingRecipe> getRecipes() {
        return recipes;
    }

    @NotNull
    public final List<KnappingRecipe> getAllRecipes() {
        return CollectionsKt.toList((Iterable)recipes.values());
    }

    public final void register(@NotNull MoldShape shape, @NotNull Set<? extends KnappingMaterial> allowed, @NotNull Function1<? super PatternSetBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)shape, "shape");
        Intrinsics.checkNotNullParameter(allowed, "allowed");
        Intrinsics.checkNotNullParameter(block, "block");
        List<Pattern> pats = KnappingRecipesKt.patternSet(block);
        Map<String, KnappingRecipe> map2 = recipes;
        String string = shape.getId();
        Object object = shape.getId();
        object = new KnappingRecipe((String)object, pats, shape, allowed);
        map2.put(string, (KnappingRecipe)object);
    }

    public final void register(@NotNull MoldShape shape, @NotNull Function1<? super PatternSetBuilder, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)shape, "shape");
        Intrinsics.checkNotNullParameter(block, "block");
        this.register(shape, KnappingMaterial.Companion.getALL(), block);
    }

    @Nullable
    public final MoldShape getResult(@NotNull List<Boolean> gridColumnMajor, @NotNull KnappingMaterial material) {
        Intrinsics.checkNotNullParameter(gridColumnMajor, "gridColumnMajor");
        Intrinsics.checkNotNullParameter((Object)material, "material");
        for (KnappingRecipe recipe : recipes.values()) {
            if (!recipe.getAllowed().contains((Object)material)) continue;
            for (Pattern pattern : recipe.getPatterns()) {
                boolean bl = pattern.getHeight() == 5 && pattern.getWidth() == 5 ? KnappingRecipesKt.access$matchesAt(gridColumnMajor, pattern, 0, 0, SetsKt.setOf(Character.valueOf('#'))) && KnappingRecipesKt.access$outsideRegionEmpty(gridColumnMajor, 0, 0, 5, 5) : KnappingRecipesKt.matchesPatternAnywhere(gridColumnMajor, pattern, SetsKt.setOf(Character.valueOf('#')));
                boolean ok = bl;
                if (!ok) continue;
                return recipe.getResult();
            }
        }
        return null;
    }

    private static final Unit _init_$lambda$0(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{"   # ", " ####", "#####", " ####", "   # "};
        $this$register.rows(stringArray);
        $this$register.transform(KnappingRecipesKt.getInvertX());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{" ### ", "#   #"};
        $this$register.rows(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{" # ", "###", "###", "###"};
        $this$register.rows(stringArray);
        $this$register.transform(KnappingRecipesKt.getInvertY());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{"   ##", "  ###", " ### ", "###  ", "##   "};
        $this$register.rows(stringArray);
        $this$register.transform(KnappingRecipesKt.getInvertX());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{"#####", "  ###"};
        $this$register.rows(stringArray);
        $this$register.transform(KnappingRecipesKt.getInvertX());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{"#   #", "#####"};
        $this$register.rows(stringArray);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$6(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{" #", "##", "##", "##"};
        $this$register.rows(stringArray);
        $this$register.transform(KnappingRecipesKt.getInvertX());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$7(PatternSetBuilder $this$register) {
        Intrinsics.checkNotNullParameter($this$register, "$this$register");
        String[] stringArray = new String[]{"##  ", " ###", "  ##", "   #"};
        $this$register.rows(stringArray);
        $this$register.transform(KnappingRecipesKt.getInvertX());
        return Unit.INSTANCE;
    }

    static {
        INSTANCE.register(MoldShape.Axe, KnappingRecipes::_init_$lambda$0);
        INSTANCE.register(MoldShape.Pickaxe, KnappingRecipes::_init_$lambda$1);
        INSTANCE.register(MoldShape.Shovel, KnappingRecipes::_init_$lambda$2);
        INSTANCE.register(MoldShape.Sword, KnappingRecipes::_init_$lambda$3);
        INSTANCE.register(MoldShape.Hoe, KnappingRecipes::_init_$lambda$4);
        INSTANCE.register(MoldShape.Ingot, KnappingMaterial.Companion.getMOLDS_ONLY(), KnappingRecipes::_init_$lambda$5);
        INSTANCE.register(MoldShape.Knife, KnappingRecipes::_init_$lambda$6);
        INSTANCE.register(MoldShape.Saw, KnappingRecipes::_init_$lambda$7);
    }
}

