/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.content.workstation.leatherbed;

import com.github.shynixn.mccoroutine.folia.MCCoroutineKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.properties.Property;
import net.momirealms.craftengine.core.entity.player.InteractionResult;
import net.momirealms.craftengine.core.util.HorizontalDirection;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.Position;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.Vec3i;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import org.bukkit.Color;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.shotrush.atom.Atom;
import org.shotrush.atom.UtilKt;
import org.shotrush.atom.content.AnimalProduct;
import org.shotrush.atom.content.AnimalType;
import org.shotrush.atom.content.base.AtomBlockEntity;
import org.shotrush.atom.content.foraging.items.SharpenedFlint;
import org.shotrush.atom.content.workstation.Workstations;
import org.shotrush.atom.content.workstation.leatherbed.LeatherBedBlockBehavior;
import org.shotrush.atom.content.workstation.leatherbed.LeatherBedBlockDynamicRenderer;
import org.shotrush.atom.core.util.ActionBarManager;
import org.shotrush.atom.item.Items;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u00014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rJ\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010,\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rJ\u0016\u0010.\u001a\u00020-2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rJ\u0006\u0010/\u001a\u00020\u001aJ\u0010\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u001aH\u0002R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00065"}, d2={"Lorg/shotrush/atom/content/workstation/leatherbed/LeatherBedBlockEntity;", "Lorg/shotrush/atom/content/base/AtomBlockEntity;", "pos", "Lnet/momirealms/craftengine/core/world/BlockPos;", "blockState", "Lnet/momirealms/craftengine/core/block/ImmutableBlockState;", "<init>", "(Lnet/momirealms/craftengine/core/world/BlockPos;Lnet/momirealms/craftengine/core/block/ImmutableBlockState;)V", "rotation", "Lnet/momirealms/craftengine/core/util/HorizontalDirection;", "getRotation", "()Lnet/momirealms/craftengine/core/util/HorizontalDirection;", "value", "Lorg/bukkit/inventory/ItemStack;", "storedItem", "getStoredItem", "()Lorg/bukkit/inventory/ItemStack;", "setStoredItem", "(Lorg/bukkit/inventory/ItemStack;)V", "timeCuring", "", "getTimeCuring", "()J", "setTimeCuring", "(J)V", "loadCustomData", "", "tag", "Lnet/momirealms/craftengine/libraries/nbt/CompoundTag;", "saveCustomData", "preRemove", "dropLocation", "Lorg/bukkit/Location;", "getDropLocation", "()Lorg/bukkit/Location;", "hasItem", "", "startScraping", "player", "Lorg/bukkit/entity/Player;", "item", "finishScraping", "tool", "playScrapingEffects", "tryPlaceItem", "Lnet/momirealms/craftengine/core/entity/player/InteractionResult;", "tryEmptyItems", "tick", "spawnCuringParticles", "progress", "", "spawnCompletionParticles", "Companion", "Atom"})
public final class LeatherBedBlockEntity
extends AtomBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ItemStack storedItem;
    private long timeCuring;
    private static final long CURING_TIME = UtilKt.getInWholeTicks-LRDsOJo(DurationKt.toDuration(10, DurationUnit.MINUTES));
    private static final long PARTICLE_INTERVAL = 15L;

    public LeatherBedBlockEntity(@NotNull BlockPos pos, @NotNull ImmutableBlockState blockState) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(blockState, "blockState");
        super(Workstations.INSTANCE.getLEATHER_BED(), pos, blockState);
        ItemStack itemStack = ItemStack.empty();
        Intrinsics.checkNotNullExpressionValue(itemStack, "empty(...)");
        this.storedItem = itemStack;
        this.blockEntityRenderer = new LeatherBedBlockDynamicRenderer(this);
    }

    @NotNull
    public final HorizontalDirection getRotation() {
        ImmutableBlockState immutableBlockState = this.blockState();
        Collection collection = this.blockState().getProperties();
        Intrinsics.checkNotNullExpressionValue(collection, "getProperties(...)");
        Object t2 = CollectionsKt.first(collection);
        Intrinsics.checkNotNull(t2, "null cannot be cast to non-null type net.momirealms.craftengine.core.block.properties.Property<net.momirealms.craftengine.core.util.HorizontalDirection>");
        Comparable comparable = immutableBlockState.get((Property)t2);
        Intrinsics.checkNotNullExpressionValue(comparable, "get(...)");
        return (HorizontalDirection)comparable;
    }

    @NotNull
    public final ItemStack getStoredItem() {
        return this.storedItem;
    }

    private final void setStoredItem(ItemStack value) {
        this.storedItem = value;
        AtomBlockEntity.markDirty$default(this, false, 1, null);
    }

    public final long getTimeCuring() {
        return this.timeCuring;
    }

    public final void setTimeCuring(long l) {
        this.timeCuring = l;
    }

    public void loadCustomData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.setStoredItem(UtilKt.getItemStack(tag, "storedItem"));
        this.timeCuring = tag.getLong("timeCuring");
    }

    protected void saveCustomData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        UtilKt.putItemStack(tag, "storedItem", this.storedItem);
        tag.putLong("timeCuring", this.timeCuring);
    }

    public void preRemove() {
        Vec3d pos = Vec3d.atCenterOf((Vec3i)((Vec3i)this.pos));
        if (!this.storedItem.isEmpty()) {
            this.world.world().dropItemNaturally((Position)pos, BukkitItemManager.instance().wrap(this.storedItem));
        }
    }

    @NotNull
    public final Location getDropLocation() {
        HorizontalDirection rot = this.getRotation();
        Object object = this.world.world.platformWorld();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type org.bukkit.World");
        return new Location((World)object, (double)this.pos.x() + (double)rot.stepX(), (double)this.pos.y() + (double)0.5f, (double)this.pos.z() + (double)rot.stepZ());
    }

    public final boolean hasItem() {
        return !this.storedItem.isEmpty();
    }

    public final void startScraping(@NotNull Player player, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        Atom atom = Atom.Companion.getInstance();
        MCCoroutineKt.launch$default(atom, MCCoroutineKt.regionDispatcher(atom, this.getLocation()), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(player, this, atom, item, null){
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Player $player;
            final /* synthetic */ LeatherBedBlockEntity this$0;
            final /* synthetic */ Atom $atom;
            final /* synthetic */ ItemStack $item;
            {
                this.$player = $player;
                this.this$0 = $receiver;
                this.$atom = $atom;
                this.$item = $item;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block14: {
                    var2_2 = (CoroutineScope)this.L$0;
                    var16_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure($result);
                            strokeCount = 20 + Random.Default.nextInt(11);
                            currentStroke = 0;
                            ActionBarManager.send(this.$player, "leather_bed", "<gray>Scraping leather...</gray>");
lbl9:
                            // 2 sources

                            while (currentStroke < strokeCount && CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                this.L$0 = $this$launch;
                                this.I$0 = strokeCount;
                                this.I$1 = currentStroke;
                                this.label = 1;
                                v0 = DelayKt.delay(250L, this);
                                if (v0 == var16_3) {
                                    return var16_3;
                                }
                                ** GOTO lbl24
                            }
                            break;
                        }
                        case 1: {
                            currentStroke = this.I$1;
                            strokeCount = this.I$0;
                            ResultKt.throwOnFailure($result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            if (this.$player.isHandRaised()) {
                                v1 = this.$player.getActiveItem();
                                Intrinsics.checkNotNullExpressionValue(v1, "getActiveItem(...)");
                                if (LeatherBedBlockBehavior.Companion.isScrapingTool(v1)) break;
                            }
                            ActionBarManager.send(this.$player, "leather_bed", "<red>Scraping cancelled</red>");
                            this.L$0 = SpillingKt.nullOutSpilledVariable($this$launch);
                            this.I$0 = strokeCount;
                            this.I$1 = currentStroke;
                            this.label = 2;
                            v2 = DelayKt.delay(1000L, this);
                            if (v2 == var16_3) {
                                return var16_3;
                            }
                            break;
                        }
                        case 2: {
                            currentStroke = this.I$1;
                            strokeCount = this.I$0;
                            ResultKt.throwOnFailure($result);
                            v2 = $result;
                            break;
                        }
                    }
                    if (!this.$player.isOnline() || this.$player.getLocation().distance(this.this$0.getLocation()) > 5.0) break block14;
                    this.L$0 = $this$launch;
                    this.I$0 = strokeCount;
                    this.I$1 = currentStroke;
                    this.label = 3;
                    v3 = BuildersKt.withContext(MCCoroutineKt.entityDispatcher(this.$atom, (Entity)this.$player), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$player, null){
                        int label;
                        final /* synthetic */ LeatherBedBlockEntity this$0;
                        final /* synthetic */ Player $player;
                        {
                            this.this$0 = $receiver;
                            this.$player = $player;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure($result);
                                    LeatherBedBlockEntity.access$playScrapingEffects(this.this$0, this.$player);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, this);
                    if (v3 == var16_3) {
                        return var16_3;
                    }
                    ** GOTO lbl57
                    {
                        case 3: {
                            currentStroke = this.I$1;
                            strokeCount = this.I$0;
                            ResultKt.throwOnFailure($result);
                            v3 = $result;
lbl57:
                            // 2 sources

                            prog = (int)((float)(++currentStroke) / (float)strokeCount * (float)100);
                            $this$invokeSuspend_u24lambda_u240 = var7_8 = new StringBuilder();
                            $i$a$-buildString-LeatherBedBlockEntity$startScraping$1$str$1 = false;
                            $this$invokeSuspend_u24lambda_u240.append("<yellow>" + prog + "%</yellow> ");
                            $this$invokeSuspend_u24lambda_u240.append("<dark_gray>[");
                            $this$invokeSuspend_u24lambda_u240.append("<green>");
                            total = 20;
                            bars = (int)((double)total * ((double)prog / 100.0));
                            var12_13 = 0;
                            while (var12_13 < bars) {
                                it = var12_13++;
                                $i$a$-repeat-LeatherBedBlockEntity$startScraping$1$str$1$1 = false;
                                $this$invokeSuspend_u24lambda_u240.append("|");
                            }
                            $this$invokeSuspend_u24lambda_u240.append("</green><gray>");
                            var12_13 = total - bars;
                            var13_14 = 0;
                            while (var13_14 < var12_13) {
                                it = var13_14++;
                                $i$a$-repeat-LeatherBedBlockEntity$startScraping$1$str$1$2 = false;
                                $this$invokeSuspend_u24lambda_u240.append("|");
                            }
                            $this$invokeSuspend_u24lambda_u240.append("</gray>]<dark_gray>");
                            str = var7_8.toString();
                            ActionBarManager.sendStatus(this.$player, str);
                            ** GOTO lbl9
                        }
                    }
                }
                if (currentStroke >= strokeCount) {
                    LeatherBedBlockEntity.access$finishScraping(this.this$0, this.$player, this.$item);
                }
                ActionBarManager.clearStatus(this.$player);
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void finishScraping(Player player, ItemStack tool) {
        Location center = this.getDropLocation();
        AnimalProduct storedProduct = Items.INSTANCE.getAnimalProductFromItem(this.storedItem);
        if (storedProduct == AnimalProduct.RawLeather) {
            AnimalType animalType = Items.INSTANCE.getAnimalFromProduct(this.storedItem);
            center.getWorld().dropItemNaturally(center, (ItemStack)Items.INSTANCE.getAnimalProduct(animalType, AnimalProduct.RawMeat).buildItemStack());
            Object object = Items.INSTANCE.getAnimalProduct(animalType, AnimalProduct.Leather).buildItemStack();
            Intrinsics.checkNotNullExpressionValue(object, "buildItemStack(...)");
            this.setStoredItem((ItemStack)object);
            ActionBarManager.send(player, "<green>Scraped the meat off! Leather will now stabilize over time...</green>");
        } else {
            center.getWorld().dropItemNaturally(center, this.storedItem);
            ItemStack itemStack = ItemStack.empty();
            Intrinsics.checkNotNullExpressionValue(itemStack, "empty(...)");
            this.setStoredItem(itemStack);
            ActionBarManager.send(player, "<green>Removed the leather from the bed</green>");
        }
        if (SharpenedFlint.INSTANCE.isSharpenedFlint(tool)) {
            SharpenedFlint.INSTANCE.damageItem(tool, player, 0.3);
        }
        player.playSound(player.getLocation(), Sound.BLOCK_WOOL_BREAK, 1.0f, 1.0f);
    }

    private final void playScrapingEffects(Player player) {
        block1: {
            Location location = this.getLocation().add(0.5, 1.0, 0.5);
            Intrinsics.checkNotNullExpressionValue(location, "add(...)");
            Location location2 = location;
            World world = location2.getWorld();
            if (world != null) {
                world.playSound(location2, Sound.ITEM_BRUSH_BRUSHING_GENERIC, 1.0f, 1.0f);
            }
            Particle.DustOptions dustOptions = new Particle.DustOptions(Color.fromRGB((int)139, (int)69, (int)19), 1.0f);
            World world2 = location2.getWorld();
            if (world2 == null) break block1;
            world2.spawnParticle(Particle.DUST, location2, 10, 0.2, 0.2, 0.2, 0.0, (Object)dustOptions);
        }
    }

    @NotNull
    public final InteractionResult tryPlaceItem(@NotNull Player player, @NotNull ItemStack item) {
        boolean subtract;
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        if (!this.storedItem.isEmpty()) {
            return InteractionResult.FAIL;
        }
        boolean bl = subtract = player.getGameMode() != GameMode.CREATIVE;
        if (!Items.INSTANCE.isAnimalProduct(item)) {
            return InteractionResult.FAIL;
        }
        AnimalProduct product = Items.INSTANCE.getAnimalProductFromItem(item);
        if (product == AnimalProduct.Leather) {
            ItemStack itemStack = item.clone();
            Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
            ItemStack clone = itemStack;
            if (subtract) {
                item.subtract(1);
            }
            clone.setAmount(1);
            this.setStoredItem(clone);
            return InteractionResult.SUCCESS;
        }
        if (product == AnimalProduct.RawLeather) {
            ItemStack itemStack = item.clone();
            Intrinsics.checkNotNullExpressionValue(itemStack, "clone(...)");
            ItemStack clone = itemStack;
            if (subtract) {
                item.subtract(1);
            }
            clone.setAmount(1);
            this.setStoredItem(clone);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    public final InteractionResult tryEmptyItems(@NotNull Player player, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter(player, "player");
        Intrinsics.checkNotNullParameter(item, "item");
        if (this.storedItem.isEmpty()) {
            return InteractionResult.FAIL;
        }
        this.getLocation().getWorld().dropItemNaturally(this.getDropLocation(), this.storedItem);
        ItemStack itemStack = ItemStack.empty();
        Intrinsics.checkNotNullExpressionValue(itemStack, "empty(...)");
        this.setStoredItem(itemStack);
        return InteractionResult.SUCCESS;
    }

    public final void tick() {
        if (Items.INSTANCE.isAnimalProduct(this.storedItem)) {
            AnimalProduct type = Items.INSTANCE.getAnimalProductFromItem(this.storedItem);
            if (type == AnimalProduct.Leather) {
                if (this.timeCuring >= CURING_TIME) {
                    AnimalType animal = Items.INSTANCE.getAnimalFromProduct(this.storedItem);
                    Object object = Items.INSTANCE.getAnimalProduct(animal, AnimalProduct.CuredLeather).buildItemStack();
                    Intrinsics.checkNotNullExpressionValue(object, "buildItemStack(...)");
                    this.setStoredItem((ItemStack)object);
                    this.timeCuring = 0L;
                    this.spawnCompletionParticles();
                } else {
                    long l = this.timeCuring;
                    this.timeCuring = l + 1L;
                    if (this.timeCuring % 15L == 0L) {
                        this.spawnCuringParticles((float)this.timeCuring / (float)CURING_TIME);
                    }
                }
            }
        } else {
            this.timeCuring = 0L;
        }
    }

    private final void spawnCuringParticles(float progress) {
        int baseCount = 2;
        int extraByProgress = (int)(progress * 4.0f);
        int count2 = baseCount + extraByProgress;
        Particle particle = Particle.SMOKE;
        Particle secondary = Particle.DRIPPING_WATER;
        int n = 0;
        while (n < count2) {
            int it = n++;
            boolean bl = false;
            double x = (double)this.pos.x() + 0.5 + (Random.Default.nextDouble() - 0.5) * 0.6;
            double y = (double)this.pos.y() + 0.9 + Random.Default.nextDouble() * 0.2;
            double z = (double)this.pos.z() + 0.5 + (Random.Default.nextDouble() - 0.5) * 0.6;
            double vx = (Random.Default.nextDouble() - 0.5) * 0.01;
            double vy = 0.02 + Random.Default.nextDouble() * 0.02;
            double vz = (Random.Default.nextDouble() - 0.5) * 0.01;
            this.getBukkitWorld().spawnParticle(particle, x, y, z, 1, vx, vy, vz, 0.0);
        }
        if (this.getBukkitWorld().getGameTime() % 40L == 0L) {
            double x = (double)this.pos.x() + 0.5 + (Random.Default.nextDouble() - 0.5) * 0.3;
            double y = (double)this.pos.y() + 0.8;
            double z = (double)this.pos.z() + 0.5 + (Random.Default.nextDouble() - 0.5) * 0.3;
            this.getBukkitWorld().spawnParticle(secondary, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private final void spawnCompletionParticles() {
        int n = 8;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            double x = (double)this.pos.x() + 0.5 + (Random.Default.nextDouble() - 0.5) * 0.8;
            double y = (double)this.pos.y() + 1.0 + Random.Default.nextDouble() * 0.3;
            double z = (double)this.pos.z() + 0.5 + (Random.Default.nextDouble() - 0.5) * 0.8;
            double vx = (Random.Default.nextDouble() - 0.5) * 0.03;
            double vy = 0.05 + Random.Default.nextDouble() * 0.05;
            double vz = (Random.Default.nextDouble() - 0.5) * 0.03;
            this.getBukkitWorld().spawnParticle(Particle.HAPPY_VILLAGER, x, y, z, 1, vx, vy, vz, 0.0);
        }
    }

    public static final /* synthetic */ void access$playScrapingEffects(LeatherBedBlockEntity $this, Player player) {
        $this.playScrapingEffects(player);
    }

    public static final /* synthetic */ void access$finishScraping(LeatherBedBlockEntity $this, Player player, ItemStack tool) {
        $this.finishScraping(player, tool);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/shotrush/atom/content/workstation/leatherbed/LeatherBedBlockEntity$Companion;", "", "<init>", "()V", "CURING_TIME", "", "getCURING_TIME", "()J", "PARTICLE_INTERVAL", "Atom"})
    public static final class Companion {
        private Companion() {
        }

        public final long getCURING_TIME() {
            return CURING_TIME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

