/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.PaperCommandManager;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.age.Age;
import org.shotrush.atom.core.age.AgeManager;
import org.shotrush.atom.core.age.AgeProvider;
import org.shotrush.atom.core.age.annotation.AutoRegisterAge;
import org.shotrush.atom.core.blocks.BlockType;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.blocks.CustomBlockRegistry;
import org.shotrush.atom.core.blocks.annotation.AutoRegister;
import org.shotrush.atom.core.items.CustomItem;
import org.shotrush.atom.core.items.CustomItemRegistry;
import org.shotrush.atom.core.systems.annotation.AutoRegisterSystem;

public class AutoRegisterManager {
    public static void registerItems(Plugin plugin, CustomItemRegistry itemRegistry) {
        Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(org.shotrush.atom.core.items.annotation.AutoRegister.class);
        ArrayList sortedClasses = new ArrayList(annotatedClasses);
        sortedClasses.sort(Comparator.comparingInt(cls -> cls.getAnnotation(org.shotrush.atom.core.items.annotation.AutoRegister.class).priority()));
        for (Class clazz : sortedClasses) {
            if (!CustomItem.class.isAssignableFrom(clazz)) continue;
            try {
                Constructor constructor = clazz.getConstructor(Plugin.class);
                CustomItem item = (CustomItem)constructor.newInstance(plugin);
                itemRegistry.register(item);
            }
            catch (Exception e) {
                plugin.getLogger().warning("Failed to auto-register item: " + clazz.getName());
                e.printStackTrace();
            }
        }
    }

    public static void registerBlocks(Plugin plugin, CustomBlockRegistry blockRegistry) {
        Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegister.class);
        ArrayList sortedClasses = new ArrayList(annotatedClasses);
        sortedClasses.sort(Comparator.comparingInt(cls -> cls.getAnnotation(AutoRegister.class).priority()));
        for (Class clazz : sortedClasses) {
            if (!BlockType.class.isAssignableFrom(clazz)) continue;
            try {
                BlockType blockType;
                Constructor constructor;
                if (CustomBlock.class.isAssignableFrom(clazz)) {
                    blockRegistry.register(clazz, plugin);
                    continue;
                }
                try {
                    constructor = clazz.getConstructor(Atom.class);
                    blockType = (BlockType)constructor.newInstance(plugin);
                }
                catch (NoSuchMethodException e) {
                    constructor = clazz.getConstructor(Plugin.class);
                    blockType = (BlockType)constructor.newInstance(plugin);
                }
                blockRegistry.register(blockType.getIdentifier(), blockType);
            }
            catch (Exception e) {
                plugin.getLogger().warning("Failed to auto-register block type: " + clazz.getName());
                e.printStackTrace();
            }
        }
    }

    public static void registerCommands(Plugin plugin, PaperCommandManager commandManager) {
        Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(org.shotrush.atom.commands.annotation.AutoRegister.class);
        ArrayList sortedClasses = new ArrayList(annotatedClasses);
        sortedClasses.sort(Comparator.comparingInt(cls -> cls.getAnnotation(org.shotrush.atom.commands.annotation.AutoRegister.class).priority()));
        for (Class clazz : sortedClasses) {
            if (!BaseCommand.class.isAssignableFrom(clazz)) continue;
            try {
                BaseCommand command2;
                Constructor constructor;
                try {
                    constructor = clazz.getConstructor(Plugin.class);
                    BaseCommand command3 = (BaseCommand)constructor.newInstance(plugin);
                }
                catch (NoSuchMethodException e) {
                    constructor = clazz.getConstructor(new Class[0]);
                    command2 = (BaseCommand)constructor.newInstance(new Object[0]);
                }
                commandManager.registerCommand(command2);
                plugin.getLogger().info("Auto-registered command: " + clazz.getSimpleName());
            }
            catch (Exception e) {
                plugin.getLogger().warning("Failed to auto-register command: " + clazz.getName());
                e.printStackTrace();
            }
        }
    }

    public static void registerAges(Plugin plugin, AgeManager ageManager) {
        Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegisterAge.class);
        ArrayList sortedClasses = new ArrayList(annotatedClasses);
        sortedClasses.sort(Comparator.comparingInt(cls -> cls.getAnnotation(AutoRegisterAge.class).order()));
        ArrayList<Age> ages = new ArrayList<Age>();
        for (Class clazz : sortedClasses) {
            if (!AgeProvider.class.isAssignableFrom(clazz)) continue;
            try {
                AgeProvider provider = (AgeProvider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                Age age = provider.createAge();
                ages.add(age);
                plugin.getLogger().info("Auto-registered age: " + age.getDisplayName() + " (order: " + age.getOrder() + ")");
            }
            catch (Exception e) {
                plugin.getLogger().warning("Failed to auto-register age: " + clazz.getName());
                e.printStackTrace();
            }
        }
        if (!ages.isEmpty()) {
            ageManager.registerAges(ages.toArray(new Age[0]));
            ageManager.setAge((Age)ages.get(0));
        }
    }

    public static void registerSystems(Plugin plugin) {
        Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(AutoRegisterSystem.class);
        ArrayList sortedClasses = new ArrayList(annotatedClasses);
        sortedClasses.sort(Comparator.comparingInt(cls -> cls.getAnnotation(AutoRegisterSystem.class).priority()));
        for (Class clazz : sortedClasses) {
            try {
                Object instance;
                Constructor constructor;
                try {
                    constructor = clazz.getConstructor(Plugin.class);
                    instance = constructor.newInstance(plugin);
                }
                catch (NoSuchMethodException e) {
                    constructor = clazz.getConstructor(new Class[0]);
                    instance = constructor.newInstance(new Object[0]);
                }
                if (instance instanceof Listener) {
                    Listener listener = (Listener)instance;
                    plugin.getServer().getPluginManager().registerEvents(listener, plugin);
                }
                plugin.getLogger().info("Auto-registered system: " + clazz.getSimpleName());
            }
            catch (Exception e) {
                plugin.getLogger().warning("Failed to auto-register system: " + clazz.getName());
                e.printStackTrace();
            }
        }
    }
}

