/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.age;

import lombok.Generated;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;

public class Age {
    @NonNull
    private final String id;
    @NonNull
    private final String displayName;
    private final int year;
    private final boolean isBC;
    private final int order;
    private final TextColor titleColor;
    private final TextColor subtitleColor;
    private final String description;

    public String getYearDisplay() {
        return Math.abs(this.year) + " " + (this.isBC ? "BC" : "AD");
    }

    public Component getTitleComponent() {
        return Component.text("The " + this.displayName + " Age").color(this.titleColor);
    }

    public Component getSubtitleComponent() {
        return Component.text("Year: " + this.getYearDisplay()).color(this.subtitleColor);
    }

    public Component getAnnouncementComponent() {
        return ((TextComponent)Component.text("We are in the ").append(Component.text(this.displayName).color(this.titleColor))).append(Component.text(" age now. Year: " + this.getYearDisplay()));
    }

    public boolean isAfter(Age other) {
        return this.order > other.order;
    }

    public boolean isBefore(Age other) {
        return this.order < other.order;
    }

    @Generated
    private static int $default$year() {
        return 0;
    }

    @Generated
    private static boolean $default$isBC() {
        return true;
    }

    @Generated
    private static int $default$order() {
        return 0;
    }

    @Generated
    private static TextColor $default$titleColor() {
        return TextColor.color(255, 215, 0);
    }

    @Generated
    private static TextColor $default$subtitleColor() {
        return TextColor.color(200, 200, 200);
    }

    @Generated
    Age(@NonNull String id, @NonNull String displayName, int year, boolean isBC, int order, TextColor titleColor, TextColor subtitleColor, String description) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        this.id = id;
        this.displayName = displayName;
        this.year = year;
        this.isBC = isBC;
        this.order = order;
        this.titleColor = titleColor;
        this.subtitleColor = subtitleColor;
        this.description = description;
    }

    @Generated
    public static AgeBuilder builder() {
        return new AgeBuilder();
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public int getYear() {
        return this.year;
    }

    @Generated
    public boolean isBC() {
        return this.isBC;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public TextColor getTitleColor() {
        return this.titleColor;
    }

    @Generated
    public TextColor getSubtitleColor() {
        return this.subtitleColor;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public static class AgeBuilder {
        @Generated
        private String id;
        @Generated
        private String displayName;
        @Generated
        private boolean year$set;
        @Generated
        private int year$value;
        @Generated
        private boolean isBC$set;
        @Generated
        private boolean isBC$value;
        @Generated
        private boolean order$set;
        @Generated
        private int order$value;
        @Generated
        private boolean titleColor$set;
        @Generated
        private TextColor titleColor$value;
        @Generated
        private boolean subtitleColor$set;
        @Generated
        private TextColor subtitleColor$value;
        @Generated
        private String description;

        @Generated
        AgeBuilder() {
        }

        @Generated
        public AgeBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @Generated
        public AgeBuilder displayName(@NonNull String displayName) {
            if (displayName == null) {
                throw new NullPointerException("displayName is marked non-null but is null");
            }
            this.displayName = displayName;
            return this;
        }

        @Generated
        public AgeBuilder year(int year) {
            this.year$value = year;
            this.year$set = true;
            return this;
        }

        @Generated
        public AgeBuilder isBC(boolean isBC) {
            this.isBC$value = isBC;
            this.isBC$set = true;
            return this;
        }

        @Generated
        public AgeBuilder order(int order) {
            this.order$value = order;
            this.order$set = true;
            return this;
        }

        @Generated
        public AgeBuilder titleColor(TextColor titleColor) {
            this.titleColor$value = titleColor;
            this.titleColor$set = true;
            return this;
        }

        @Generated
        public AgeBuilder subtitleColor(TextColor subtitleColor) {
            this.subtitleColor$value = subtitleColor;
            this.subtitleColor$set = true;
            return this;
        }

        @Generated
        public AgeBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public Age build() {
            int year$value = this.year$value;
            if (!this.year$set) {
                year$value = Age.$default$year();
            }
            boolean isBC$value = this.isBC$value;
            if (!this.isBC$set) {
                isBC$value = Age.$default$isBC();
            }
            int order$value = this.order$value;
            if (!this.order$set) {
                order$value = Age.$default$order();
            }
            TextColor titleColor$value = this.titleColor$value;
            if (!this.titleColor$set) {
                titleColor$value = Age.$default$titleColor();
            }
            TextColor subtitleColor$value = this.subtitleColor$value;
            if (!this.subtitleColor$set) {
                subtitleColor$value = Age.$default$subtitleColor();
            }
            return new Age(this.id, this.displayName, year$value, isBC$value, order$value, titleColor$value, subtitleColor$value, this.description);
        }

        @Generated
        public String toString() {
            return "Age.AgeBuilder(id=" + this.id + ", displayName=" + this.displayName + ", year$value=" + this.year$value + ", isBC$value=" + this.isBC$value + ", order$value=" + this.order$value + ", titleColor$value=" + String.valueOf(this.titleColor$value) + ", subtitleColor$value=" + String.valueOf(this.subtitleColor$value) + ", description=" + this.description + ")";
        }
    }
}

