/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.age;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.shotrush.atom.core.age.Age;
import org.shotrush.atom.core.age.AgeProgressEvent;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.storage.DataStorage;

public class AgeManager {
    private final Plugin plugin;
    private final DataStorage storage;
    private final Map<String, Age> ages = new ConcurrentHashMap<String, Age>();
    private final List<Age> orderedAges = new ArrayList<Age>();
    private Age currentAge;

    public AgeManager(Plugin plugin, DataStorage storage) {
        this.plugin = plugin;
        this.storage = storage;
        this.loadCurrentAge();
    }

    public void registerAge(@NotNull Age age) {
        this.ages.put(age.getId(), age);
        this.orderedAges.add(age);
        this.orderedAges.sort(Comparator.comparingInt(Age::getOrder));
    }

    public void registerAges(Age ... ages) {
        for (Age age : ages) {
            this.registerAge(age);
        }
    }

    public Optional<Age> getAge(String id) {
        return Optional.ofNullable(this.ages.get(id));
    }

    public List<Age> getAllAges() {
        return Collections.unmodifiableList(this.orderedAges);
    }

    public Optional<Age> getNextAge() {
        if (this.currentAge == null) {
            return this.orderedAges.isEmpty() ? Optional.empty() : Optional.of(this.orderedAges.get(0));
        }
        int currentIndex = this.orderedAges.indexOf(this.currentAge);
        if (currentIndex < 0 || currentIndex >= this.orderedAges.size() - 1) {
            return Optional.empty();
        }
        return Optional.of(this.orderedAges.get(currentIndex + 1));
    }

    public Optional<Age> getPreviousAge() {
        if (this.currentAge == null) {
            return Optional.empty();
        }
        int currentIndex = this.orderedAges.indexOf(this.currentAge);
        if (currentIndex <= 0) {
            return Optional.empty();
        }
        return Optional.of(this.orderedAges.get(currentIndex - 1));
    }

    public boolean progressToAge(@NotNull String ageId, @Nullable Player trigger) {
        return this.getAge(ageId).map(age -> this.progressToAge((Age)age, trigger)).orElse(false);
    }

    public boolean progressToAge(@NotNull Age newAge, @Nullable Player trigger) {
        AgeProgressEvent event = new AgeProgressEvent(this.currentAge, newAge, trigger);
        event.callEvent();
        if (event.isCancelled()) {
            return false;
        }
        Age previousAge = this.currentAge;
        this.currentAge = newAge;
        this.saveCurrentAge();
        this.broadcastAgeChange(previousAge, newAge, trigger);
        return true;
    }

    public boolean progressToNextAge(@Nullable Player trigger) {
        return this.getNextAge().map(age -> this.progressToAge((Age)age, trigger)).orElse(false);
    }

    public void setAge(@NotNull Age age) {
        this.currentAge = age;
        this.saveCurrentAge();
    }

    public void setAge(@NotNull String ageId) {
        this.getAge(ageId).ifPresent(this::setAge);
    }

    private void saveCurrentAge() {
        if (this.currentAge == null) {
            return;
        }
        YamlConfiguration config = this.storage.getServerData();
        config.set("current_age", (Object)this.currentAge.getId());
        this.storage.saveServerData(config);
    }

    private void loadCurrentAge() {
        YamlConfiguration config = this.storage.getServerData();
        String ageId = config.getString("current_age");
        if (ageId != null) {
            SchedulerAPI.runGlobalTaskLater(() -> this.getAge(ageId).ifPresent(age -> {
                this.currentAge = age;
                this.plugin.getLogger().info("Loaded current age: " + age.getDisplayName());
            }), 1L);
        }
    }

    private void broadcastAgeChange(@Nullable Age previousAge, @NotNull Age newAge, @Nullable Player trigger) {
        Title title = Title.title(newAge.getTitleComponent(), newAge.getSubtitleComponent(), Title.Times.times(Duration.ofMillis(500L), Duration.ofSeconds(3L), Duration.ofSeconds(1L)));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.showTitle(title);
        }
        Component announcement = newAge.getAnnouncementComponent();
        if (trigger != null) {
            announcement = announcement.append(Component.text(" (Triggered by " + trigger.getName() + ")"));
        }
        Bukkit.broadcast((Component)announcement);
    }

    public void broadcastCurrentAge() {
        if (this.currentAge == null) {
            return;
        }
        this.broadcastAgeChange(null, this.currentAge, null);
    }

    public boolean canProgress() {
        return this.getNextAge().isPresent();
    }

    public boolean isInAge(@NotNull String ageId) {
        return this.currentAge != null && this.currentAge.getId().equals(ageId);
    }

    public boolean isInAge(@NotNull Age age) {
        return this.currentAge != null && this.currentAge.equals(age);
    }

    public int getCurrentAgeIndex() {
        return this.currentAge == null ? -1 : this.orderedAges.indexOf(this.currentAge);
    }

    public int getTotalAges() {
        return this.orderedAges.size();
    }

    @Generated
    public Age getCurrentAge() {
        return this.currentAge;
    }
}

