/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.api;

import co.aikar.commands.PaperCommandManager;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.AutoRegisterManager;
import org.shotrush.atom.core.age.AgeManager;
import org.shotrush.atom.core.api.BlockBreakSpeedAPI;
import org.shotrush.atom.core.api.combat.ArmorProtectionAPI;
import org.shotrush.atom.core.api.combat.TemperatureEffectsAPI;
import org.shotrush.atom.core.api.item.ItemQualityAPI;
import org.shotrush.atom.core.api.item.QualityInheritanceAPI;
import org.shotrush.atom.core.api.player.AttributeModifierAPI;
import org.shotrush.atom.core.api.player.PlayerDataAPI;
import org.shotrush.atom.core.api.registry.SystemRegistry;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.api.world.EnvironmentalFactorAPI;
import org.shotrush.atom.core.blocks.CustomBlockManager;
import org.shotrush.atom.core.items.CustomItemRegistry;
import org.shotrush.atom.core.storage.DataStorage;

public final class AtomAPI {
    private static SystemRegistry systemRegistry;
    private static Plugin plugin;
    public static DataStorage dataStorage;
    public static AgeManager ageManager;
    public static CustomItemRegistry itemRegistry;
    public static CustomBlockManager blockManager;

    private AtomAPI() {
    }

    public static void initialize(Plugin pluginInstance) {
        plugin = pluginInstance;
        plugin.getLogger().info("=== AtomAPI Initialization ===");
        plugin.getLogger().info("Initializing core APIs...");
        SchedulerAPI.init(plugin);
        BlockBreakSpeedAPI.initialize(plugin);
        plugin.getLogger().info("Initializing core components...");
        dataStorage = new DataStorage(plugin);
        ageManager = new AgeManager(plugin, dataStorage);
        itemRegistry = new CustomItemRegistry(plugin);
        blockManager = new CustomBlockManager((Atom)plugin);
        systemRegistry = new SystemRegistry(plugin);
        plugin.getLogger().info("AtomAPI initialization complete!");
        plugin.getLogger().info("==============================");
    }

    public static void registerSystems() {
        if (systemRegistry == null) {
            throw new IllegalStateException("AtomAPI not initialized! Call initialize() first.");
        }
        systemRegistry.discoverAndRegister();
    }

    public static void registerAges() {
        if (ageManager == null) {
            throw new IllegalStateException("AtomAPI not initialized!");
        }
        plugin.getLogger().info("Registering ages...");
        AutoRegisterManager.registerAges(plugin, ageManager);
    }

    public static void registerItems() {
        if (itemRegistry == null) {
            throw new IllegalStateException("AtomAPI not initialized!");
        }
        plugin.getLogger().info("Registering items...");
        AutoRegisterManager.registerItems(plugin, itemRegistry);
    }

    public static void registerBlocks() {
        if (blockManager == null) {
            throw new IllegalStateException("AtomAPI not initialized!");
        }
        plugin.getLogger().info("Registering blocks...");
        AutoRegisterManager.registerBlocks(plugin, blockManager.getRegistry());
    }

    public static void registerCommands(PaperCommandManager commandManager) {
        if (plugin == null) {
            throw new IllegalStateException("AtomAPI not initialized!");
        }
        plugin.getLogger().info("Registering commands...");
    }

    public static void shutdown() {
        if (plugin == null) {
            return;
        }
        plugin.getLogger().info("=== AtomAPI Shutdown ===");
        if (blockManager != null) {
            plugin.getLogger().info("Cleaning up block manager...");
            blockManager.stopGlobalUpdate();
            blockManager.cleanupAllDisplays();
            blockManager.saveBlocks();
        }
        plugin.getLogger().info("AtomAPI shutdown complete!");
        plugin.getLogger().info("========================");
        systemRegistry = null;
        dataStorage = null;
        ageManager = null;
        itemRegistry = null;
        blockManager = null;
        plugin = null;
    }

    @Generated
    public static DataStorage getDataStorage() {
        return dataStorage;
    }

    @Generated
    public static AgeManager getAgeManager() {
        return ageManager;
    }

    @Generated
    public static CustomItemRegistry getItemRegistry() {
        return itemRegistry;
    }

    @Generated
    public static CustomBlockManager getBlockManager() {
        return blockManager;
    }

    public static final class Scheduler {
        public static ScheduledTask runTask(Entity entity, Runnable task) {
            return SchedulerAPI.runTask(entity, task);
        }

        public static ScheduledTask runTaskLater(Entity entity, Runnable task, long delay) {
            return SchedulerAPI.runTaskLater(entity, task, delay);
        }

        public static ScheduledTask runTaskTimer(Entity entity, Runnable task, long delay, long period) {
            return SchedulerAPI.runTaskTimer(entity, task, delay, period);
        }

        public static ScheduledTask runTask(Location location, Runnable task) {
            return SchedulerAPI.runTask(location, task);
        }

        public static ScheduledTask runTaskLater(Location location, Runnable task, long delay) {
            return SchedulerAPI.runTaskLater(location, task, delay);
        }

        public static ScheduledTask runGlobalTask(Runnable task) {
            return SchedulerAPI.runGlobalTask(task);
        }

        public static ScheduledTask runAsync(Runnable task) {
            return SchedulerAPI.runAsync(task);
        }
    }

    public static final class Systems {
        public static Object get(String id) {
            return systemRegistry != null ? systemRegistry.getSystem(id) : null;
        }

        public static Object getService(String serviceName) {
            return systemRegistry != null ? systemRegistry.getService(serviceName) : null;
        }

        public static <T> T getService(String serviceName, Class<T> type) {
            return systemRegistry != null ? (T)systemRegistry.getService(serviceName, type) : null;
        }

        public static Set<String> list() {
            return systemRegistry != null ? systemRegistry.getSystemIds() : Collections.emptySet();
        }

        public static List<SystemRegistry.SystemStatus> status() {
            return systemRegistry != null ? systemRegistry.getSystemStatuses() : Collections.emptyList();
        }

        public static boolean enable(String id) {
            return systemRegistry != null && systemRegistry.enableSystem(id);
        }

        public static boolean disable(String id) {
            return systemRegistry != null && systemRegistry.disableSystem(id);
        }

        public static void setEnabled(String id, boolean enabled) {
            if (systemRegistry != null) {
                systemRegistry.setEnabled(id, enabled);
            }
        }
    }

    public static final class Combat {
        public static ArmorProtectionAPI Armor = null;
        public static TemperatureEffectsAPI Temperature = null;
    }

    public static final class World {
        public static EnvironmentalFactorAPI Environment = null;
    }

    public static final class Item {
        public static ItemQualityAPI Quality = null;
        public static QualityInheritanceAPI Inheritance = null;
    }

    public static final class Player {
        public static PlayerDataAPI Data = null;
        public static AttributeModifierAPI Attributes = null;
    }
}

