/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.api.combat;

import java.awt.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class TemperatureEffectsAPI {
    public static void applyHeatDamage(Player player, double temperature, boolean hasProtection) {
        if (hasProtection) {
            return;
        }
        if (temperature >= 100.0) {
            player.setFireTicks(40);
            TemperatureEffectsAPI.spawnSweatParticles(player, 3);
        } else if (temperature >= 50.0) {
            player.setFireTicks(20);
            TemperatureEffectsAPI.spawnSweatParticles(player, 1);
        }
    }

    public static void applyColdDamage(Player player, double temperature, boolean hasProtection) {
        if (hasProtection) {
            return;
        }
        if (temperature <= -20.0) {
            player.damage(2.0);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 1, false, false));
            TemperatureEffectsAPI.spawnColdParticles(player, 3);
        } else if (temperature <= -10.0) {
            player.damage(1.0);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 0, false, false));
            TemperatureEffectsAPI.spawnColdParticles(player, 1);
        }
    }

    public static void applyBodyTemperatureEffects(Player player, double bodyTemp) {
        if (bodyTemp >= 41.0) {
            player.damage(0.5);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 1, false, false));
            player.addPotionEffect(new PotionEffect(PotionEffectType.NAUSEA, 100, 0, false, false));
            TemperatureEffectsAPI.spawnSweatParticles(player, 5);
        } else if (bodyTemp >= 39.0) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 0, false, false));
            TemperatureEffectsAPI.spawnSweatParticles(player, 2);
        } else if (bodyTemp >= 38.0) {
            TemperatureEffectsAPI.spawnSweatParticles(player, 1);
        } else if (bodyTemp <= 33.0) {
            player.damage(0.5);
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 2, false, false));
            player.setFreezeTicks(Math.min(player.getFreezeTicks() + 10, 140));
            TemperatureEffectsAPI.spawnColdParticles(player, 5);
        } else if (bodyTemp <= 34.5) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 1, false, false));
            player.setFreezeTicks(Math.min(player.getFreezeTicks() + 5, 140));
            TemperatureEffectsAPI.spawnColdParticles(player, 3);
        } else if (bodyTemp <= 35.5) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 40, 0, false, false));
            TemperatureEffectsAPI.spawnColdParticles(player, 1);
        }
    }

    private static int[] hsv(float h2, float s2, float v) {
        int rgb = Color.HSBtoRGB(h2, s2, v);
        int r = rgb >> 16 & 0xFF;
        int g2 = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new int[]{r, g2, b};
    }

    public static String getBodyTempDisplay(double temp) {
        float hue;
        double MIN_TEMP = 32.0;
        double MAX_TEMP = 40.0;
        double OPTIMAL_MIN = 36.0;
        double OPTIMAL_MAX = 37.5;
        if ((temp = Math.max(32.0, Math.min(40.0, temp))) < 36.0) {
            t = (temp - 32.0) / 4.0;
            hue = (float)(0.6666666666666666 - t * 0.3333333333333333);
        } else if (temp > 37.5) {
            t = (temp - 37.5) / 2.5;
            hue = (float)(0.3333333333333333 - t * 0.3333333333333333);
        } else {
            hue = 0.33333334f;
        }
        int[] rgb = TemperatureEffectsAPI.hsv(hue, 1.0f, 1.0f);
        String hex = String.format("#%02X%02X%02X", rgb[0], rgb[1], rgb[2]);
        String text = String.format("%.1f\u00b0C", temp);
        return "<" + hex + ">" + text + "</" + hex + ">";
    }

    private static void spawnSweatParticles(Player player, int count2) {
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        player.getWorld().spawnParticle(Particle.DRIPPING_WATER, loc, count2, 0.3, 0.3, 0.3, 0.05);
    }

    private static void spawnColdParticles(Player player, int count2) {
        Location loc = player.getLocation().add(0.0, 1.5, 0.0);
        Vector direction = player.getEyeLocation().getDirection();
        loc.add(direction.multiply(0.4));
        player.getWorld().spawnParticle(Particle.CLOUD, loc, count2, 0.15, 0.08, 0.15, 0.01);
    }
}

