/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.api.item;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.shotrush.atom.core.data.PersistentData;
import org.shotrush.atom.core.items.ItemQuality;

public class ItemQualityAPI {
    public static ItemQuality getQuality(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        String qualityName = PersistentData.getString((PersistentDataHolder)item.getItemMeta(), "item_quality", null);
        if (qualityName == null) {
            return null;
        }
        try {
            return ItemQuality.valueOf(qualityName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void setQuality(ItemStack item, ItemQuality quality) {
        if (item == null || quality == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentData.set((PersistentDataHolder)meta, "item_quality", quality.name());
        ItemQualityAPI.updateLore(meta, quality);
        item.setItemMeta(meta);
    }

    public static boolean hasQuality(ItemStack item) {
        return ItemQualityAPI.getQuality(item) != null;
    }

    public static void removeQuality(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentData.remove((PersistentDataHolder)meta, "item_quality");
        List lore = meta.hasLore() ? meta.getLore() : new ArrayList();
        lore.removeIf(line -> line.contains("Quality"));
        meta.setLore(lore);
        item.setItemMeta(meta);
    }

    private static void updateLore(ItemMeta meta, ItemQuality quality) {
        ArrayList<String> lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
        lore.removeIf(line -> line.contains("Quality"));
        lore.add("");
        lore.add(quality.getDisplayName());
        meta.setLore(lore);
    }

    public static double getEfficiencyMultiplier(ItemStack item) {
        ItemQuality quality = ItemQualityAPI.getQuality(item);
        return quality != null ? quality.getEfficiencyMultiplier() : 1.0;
    }

    public static double getDurabilityMultiplier(ItemStack item) {
        ItemQuality quality = ItemQualityAPI.getQuality(item);
        return quality != null ? quality.getDurabilityMultiplier() : 1.0;
    }

    public static double getProcessingCostMultiplier(ItemStack item) {
        ItemQuality quality = ItemQualityAPI.getQuality(item);
        return quality != null ? quality.getProcessingCostMultiplier() : 1.0;
    }
}

