/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.api.item;

import java.util.ArrayList;
import org.bukkit.inventory.ItemStack;
import org.shotrush.atom.core.api.item.ItemQualityAPI;
import org.shotrush.atom.core.items.ItemQuality;

public class QualityInheritanceAPI {
    public static ItemQuality inheritQuality(ItemStack ... ingredients) {
        if (ingredients == null || ingredients.length == 0) {
            return null;
        }
        ArrayList<ItemQuality> qualities = new ArrayList<ItemQuality>();
        for (ItemStack ingredient : ingredients) {
            ItemQuality quality;
            if (ingredient == null || (quality = ItemQualityAPI.getQuality(ingredient)) == null) continue;
            qualities.add(quality);
        }
        if (qualities.isEmpty()) {
            return null;
        }
        return ItemQuality.average(qualities.toArray(new ItemQuality[0]));
    }

    public static void applyInheritedQuality(ItemStack result, ItemStack ... ingredients) {
        ItemQuality inherited = QualityInheritanceAPI.inheritQuality(ingredients);
        if (inherited != null) {
            ItemQualityAPI.setQuality(result, inherited);
        }
    }

    public static int getModifiedDurability(ItemStack item, int baseDurability) {
        ItemQuality quality = ItemQualityAPI.getQuality(item);
        if (quality == null) {
            return baseDurability;
        }
        return (int)((double)baseDurability * quality.getDurabilityMultiplier());
    }

    public static double getModifiedEfficiency(ItemStack item, double baseEfficiency) {
        ItemQuality quality = ItemQualityAPI.getQuality(item);
        if (quality == null) {
            return baseEfficiency;
        }
        return baseEfficiency * quality.getEfficiencyMultiplier();
    }

    public static int getProcessingCost(ItemStack item, int baseCost) {
        ItemQuality quality = ItemQualityAPI.getQuality(item);
        if (quality == null) {
            return baseCost;
        }
        return (int)Math.ceil((double)baseCost * quality.getProcessingCostMultiplier());
    }

    public static int getSmeltingTime(ItemStack item, int baseTime) {
        return QualityInheritanceAPI.getProcessingCost(item, baseTime);
    }

    public static int getFoodCost(ItemStack item, int baseFoodCost) {
        return QualityInheritanceAPI.getProcessingCost(item, baseFoodCost);
    }

    public static int getThirstCost(ItemStack item, int baseThirstCost) {
        return QualityInheritanceAPI.getProcessingCost(item, baseThirstCost);
    }

    public static int getEnergyCost(ItemStack item, int baseEnergyCost) {
        return QualityInheritanceAPI.getProcessingCost(item, baseEnergyCost);
    }
}

