/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.api.player;

import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataHolder;
import org.shotrush.atom.core.data.PersistentData;

public class PlayerDataAPI {
    public static int getInt(Player player, String key, int defaultValue) {
        return PersistentData.getInt((PersistentDataHolder)player, key, defaultValue);
    }

    public static void setInt(Player player, String key, int value) {
        PersistentData.set((PersistentDataHolder)player, key, value);
    }

    public static void incrementInt(Player player, String key, int defaultValue) {
        PlayerDataAPI.setInt(player, key, PlayerDataAPI.getInt(player, key, defaultValue) + 1);
    }

    public static double getDouble(Player player, String key, double defaultValue) {
        return PersistentData.getDouble((PersistentDataHolder)player, key, defaultValue);
    }

    public static void setDouble(Player player, String key, double value) {
        PersistentData.set((PersistentDataHolder)player, key, value);
    }

    public static boolean getBoolean(Player player, String key, boolean defaultValue) {
        return PersistentData.getBoolean((PersistentDataHolder)player, key, defaultValue);
    }

    public static void setBoolean(Player player, String key, boolean value) {
        PersistentData.set((PersistentDataHolder)player, key, value);
    }

    public static String getString(Player player, String key, String defaultValue) {
        return PersistentData.getString((PersistentDataHolder)player, key, defaultValue);
    }

    public static void setString(Player player, String key, String value) {
        PersistentData.set((PersistentDataHolder)player, key, value);
    }

    public static BatchUpdate batch(Player player) {
        return new BatchUpdate(player);
    }

    public static class BatchUpdate {
        private final Player player;

        private BatchUpdate(Player player) {
            this.player = player;
        }

        public BatchUpdate setInt(String key, int value) {
            PersistentData.set((PersistentDataHolder)this.player, key, value);
            return this;
        }

        public BatchUpdate setDouble(String key, double value) {
            PersistentData.set((PersistentDataHolder)this.player, key, value);
            return this;
        }

        public BatchUpdate setBoolean(String key, boolean value) {
            PersistentData.set((PersistentDataHolder)this.player, key, value);
            return this;
        }

        public BatchUpdate setString(String key, String value) {
            PersistentData.set((PersistentDataHolder)this.player, key, value);
            return this;
        }

        public BatchUpdate increment(String key, int defaultValue) {
            int current = PersistentData.getInt((PersistentDataHolder)this.player, key, defaultValue);
            PersistentData.set((PersistentDataHolder)this.player, key, current + 1);
            return this;
        }

        public void save() {
        }
    }
}

