/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.api.registry;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.shotrush.atom.core.api.annotation.RegisterSystem;

public class SystemRegistry {
    private final Plugin plugin;
    private final Map<String, RegisteredSystem> systems = new LinkedHashMap<String, RegisteredSystem>();
    private final Map<String, Boolean> featureFlags = new HashMap<String, Boolean>();
    private final Map<String, Object> services = new HashMap<String, Object>();

    public SystemRegistry(Plugin plugin) {
        this.plugin = plugin;
    }

    public void discoverAndRegister() {
        this.plugin.getLogger().info("=== AtomAPI System Registration ===");
        try {
            Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
            Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(RegisterSystem.class);
            ArrayList<SystemInfo> systemInfos = new ArrayList<SystemInfo>();
            for (Class<?> clazz : annotatedClasses) {
                RegisterSystem annotation = clazz.getAnnotation(RegisterSystem.class);
                String id = annotation.id().isEmpty() ? this.toSnakeCase(clazz.getSimpleName()) : annotation.id();
                systemInfos.add(new SystemInfo(id, clazz, annotation));
            }
            systemInfos.sort(Comparator.comparingInt(s2 -> s2.annotation.priority()));
            for (SystemInfo info : systemInfos) {
                this.registerSystem(info);
            }
            this.plugin.getLogger().info("Registered " + this.systems.size() + " systems through AtomAPI");
            this.plugin.getLogger().info("===================================");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to discover systems: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void registerSystem(SystemInfo info) {
        String id = info.id;
        RegisterSystem annotation = info.annotation;
        if (annotation.toggleable() && !this.isEnabled(id, annotation.enabledByDefault())) {
            this.plugin.getLogger().info("  [SKIP] " + id + " (disabled in config)");
            return;
        }
        for (String string : annotation.dependencies()) {
            if (!this.systems.containsKey(string)) {
                this.plugin.getLogger().warning("  [SKIP] " + id + " (missing dependency: " + string + ")");
                return;
            }
            if (this.systems.get((Object)string).enabled) continue;
            this.plugin.getLogger().warning("  [SKIP] " + id + " (dependency disabled: " + string + ")");
            return;
        }
        for (String string : annotation.requires()) {
            if (this.services.containsKey(string)) continue;
            this.plugin.getLogger().warning("  [SKIP] " + id + " (missing required service: " + string + ")");
            return;
        }
        try {
            Constructor<?> constructor = info.clazz.getConstructor(Plugin.class);
            Object instance = constructor.newInstance(this.plugin);
            if (instance instanceof Listener) {
                this.plugin.getServer().getPluginManager().registerEvents((Listener)instance, this.plugin);
            }
            RegisteredSystem system = new RegisteredSystem(id, instance, annotation, true);
            this.systems.put(id, system);
            for (String service : annotation.provides()) {
                this.services.put(service, instance);
                this.plugin.getLogger().info("    \u2192 Provides service: " + service);
            }
            String string = annotation.description().isEmpty() ? "" : " - " + annotation.description();
            String toggle = annotation.toggleable() ? " [toggleable]" : " [core]";
            String serviceInfo = annotation.provides().length > 0 ? " [provides: " + String.join((CharSequence)", ", annotation.provides()) + "]" : "";
            this.plugin.getLogger().info("  [OK] " + id + " (priority: " + annotation.priority() + ")" + toggle + serviceInfo + string);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("  [FAIL] " + id + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean isEnabled(String id, boolean defaultValue) {
        return this.featureFlags.getOrDefault(id, defaultValue);
    }

    public void setEnabled(String id, boolean enabled) {
        this.featureFlags.put(id, enabled);
    }

    public Object getSystem(String id) {
        RegisteredSystem system = this.systems.get(id);
        return system != null ? system.instance : null;
    }

    public Object getService(String serviceName) {
        return this.services.get(serviceName);
    }

    public <T> T getService(String serviceName, Class<T> type) {
        Object service = this.services.get(serviceName);
        if (service != null && type.isInstance(service)) {
            return (T)service;
        }
        return null;
    }

    public Set<String> getSystemIds() {
        return new HashSet<String>(this.systems.keySet());
    }

    public boolean disableSystem(String id) {
        RegisteredSystem system = this.systems.get(id);
        if (system == null || !system.annotation.toggleable()) {
            return false;
        }
        if (system.instance instanceof Listener) {
            HandlerList.unregisterAll((Listener)((Listener)system.instance));
        }
        system.enabled = false;
        this.plugin.getLogger().info("Disabled system: " + id);
        return true;
    }

    public boolean enableSystem(String id) {
        RegisteredSystem system = this.systems.get(id);
        if (system == null || !system.annotation.toggleable()) {
            return false;
        }
        if (system.instance instanceof Listener) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)system.instance, this.plugin);
        }
        system.enabled = true;
        this.plugin.getLogger().info("Enabled system: " + id);
        return true;
    }

    public List<SystemStatus> getSystemStatuses() {
        return this.systems.entrySet().stream().map(e -> new SystemStatus((String)e.getKey(), ((RegisteredSystem)e.getValue()).instance.getClass().getSimpleName(), ((RegisteredSystem)e.getValue()).enabled, ((RegisteredSystem)e.getValue()).annotation.toggleable(), ((RegisteredSystem)e.getValue()).annotation.description())).collect(Collectors.toList());
    }

    private String toSnakeCase(String str) {
        return str.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    private static class SystemInfo {
        final String id;
        final Class<?> clazz;
        final RegisterSystem annotation;

        SystemInfo(String id, Class<?> clazz, RegisterSystem annotation) {
            this.id = id;
            this.clazz = clazz;
            this.annotation = annotation;
        }
    }

    private static class RegisteredSystem {
        final String id;
        final Object instance;
        final RegisterSystem annotation;
        boolean enabled;

        RegisteredSystem(String id, Object instance, RegisterSystem annotation, boolean enabled) {
            this.id = id;
            this.instance = instance;
            this.annotation = annotation;
            this.enabled = enabled;
        }
    }

    public static class SystemStatus {
        public final String id;
        public final String className;
        public final boolean enabled;
        public final boolean toggleable;
        public final String description;

        public SystemStatus(String id, String className, boolean enabled, boolean toggleable, String description) {
            this.id = id;
            this.className = className;
            this.enabled = enabled;
            this.toggleable = toggleable;
            this.description = description;
        }
    }
}

