/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.api.world;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.Lightable;
import org.bukkit.entity.Player;

public class EnvironmentalFactorAPI {
    public static double getBiomeTemperature(Biome biome) {
        if (biome == Biome.SNOWY_PLAINS || biome == Biome.SNOWY_TAIGA || biome == Biome.SNOWY_BEACH || biome == Biome.SNOWY_SLOPES || biome == Biome.FROZEN_PEAKS || biome == Biome.FROZEN_RIVER || biome == Biome.FROZEN_OCEAN || biome == Biome.DEEP_FROZEN_OCEAN || biome == Biome.ICE_SPIKES) {
            return -8.0;
        }
        if (biome == Biome.COLD_OCEAN || biome == Biome.DEEP_COLD_OCEAN || biome == Biome.TAIGA || biome == Biome.OLD_GROWTH_PINE_TAIGA || biome == Biome.OLD_GROWTH_SPRUCE_TAIGA) {
            return -5.0;
        }
        if (biome == Biome.DESERT || biome == Biome.BADLANDS || biome == Biome.ERODED_BADLANDS || biome == Biome.WOODED_BADLANDS || biome == Biome.SAVANNA || biome == Biome.SAVANNA_PLATEAU || biome == Biome.WINDSWEPT_SAVANNA) {
            return 12.0;
        }
        if (biome == Biome.NETHER_WASTES || biome == Biome.CRIMSON_FOREST || biome == Biome.WARPED_FOREST || biome == Biome.SOUL_SAND_VALLEY || biome == Biome.BASALT_DELTAS) {
            return 50.0;
        }
        return 0.0;
    }

    public static double getDayNightModifier(World world) {
        long time = world.getTime();
        boolean isNight = time >= 13000L && time <= 23000L;
        return isNight ? -2.0 : 1.0;
    }

    public static double getLightLevelModifier(Location location) {
        byte lightLevel = location.getBlock().getLightLevel();
        return (double)(lightLevel - 7) * 0.02;
    }

    public static double getWaterIceModifier(Player player, Location location) {
        Block blockBelow;
        double modifier = 0.0;
        if (player.isInWater()) {
            Biome biome = location.getBlock().getBiome();
            modifier = biome == Biome.SNOWY_PLAINS || biome == Biome.SNOWY_TAIGA || biome == Biome.SNOWY_BEACH || biome == Biome.SNOWY_SLOPES || biome == Biome.FROZEN_PEAKS || biome == Biome.FROZEN_RIVER || biome == Biome.FROZEN_OCEAN || biome == Biome.DEEP_FROZEN_OCEAN || biome == Biome.ICE_SPIKES ? (modifier -= 5.5) : (biome == Biome.COLD_OCEAN || biome == Biome.DEEP_COLD_OCEAN || biome == Biome.TAIGA || biome == Biome.OLD_GROWTH_PINE_TAIGA || biome == Biome.OLD_GROWTH_SPRUCE_TAIGA ? (modifier -= 3.3) : (biome == Biome.DESERT || biome == Biome.BADLANDS || biome == Biome.ERODED_BADLANDS || biome == Biome.WOODED_BADLANDS || biome == Biome.SAVANNA || biome == Biome.SAVANNA_PLATEAU || biome == Biome.WINDSWEPT_SAVANNA ? (modifier -= 0.55) : (biome == Biome.NETHER_WASTES || biome == Biome.CRIMSON_FOREST || biome == Biome.WARPED_FOREST || biome == Biome.SOUL_SAND_VALLEY || biome == Biome.BASALT_DELTAS ? (modifier += 10.0) : (modifier -= 3.0))));
        }
        if ((blockBelow = location.clone().add(0.0, -1.0, 0.0).getBlock()).getType() == Material.ICE || blockBelow.getType() == Material.PACKED_ICE || blockBelow.getType() == Material.BLUE_ICE) {
            modifier -= 0.85;
        } else if (blockBelow.getType() == Material.SNOW || blockBelow.getType() == Material.SNOW_BLOCK) {
            modifier -= 0.55;
        }
        return modifier;
    }

    public static double getNearbyHeatSources(Location location, int radius) {
        double heatChange = 0.0;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    Block block = location.clone().add((double)x, (double)y, (double)z).getBlock();
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (distance == 0.0) continue;
                    double influence = 1.0 / (distance * distance);
                    Material type = block.getType();
                    if (type == Material.FIRE || type == Material.SOUL_FIRE) {
                        heatChange += 5.5 * influence;
                        continue;
                    }
                    if (type == Material.LAVA) {
                        heatChange += 11.0 * influence;
                        continue;
                    }
                    if (type == Material.MAGMA_BLOCK) {
                        heatChange += 3.3 * influence;
                        continue;
                    }
                    if (type == Material.CAMPFIRE || type == Material.SOUL_CAMPFIRE) {
                        Lightable campfire = (Lightable)block.getBlockData();
                        if (!campfire.isLit() || !(distance < 2.0)) continue;
                        heatChange += 2.2 * influence;
                        continue;
                    }
                    if (type == Material.WATER || type == Material.BUBBLE_COLUMN) {
                        if (!(distance < 1.5)) continue;
                        heatChange -= 0.15 * influence;
                        continue;
                    }
                    if (type == Material.ICE || type == Material.PACKED_ICE || type == Material.BLUE_ICE) {
                        if (!(distance < 1.5)) continue;
                        heatChange -= 0.4 * influence;
                        continue;
                    }
                    if (type != Material.SNOW && type != Material.SNOW_BLOCK && type != Material.POWDER_SNOW || !(distance < 1.5)) continue;
                    heatChange -= 0.25 * influence;
                }
            }
        }
        return heatChange;
    }

    public static double calculateEnvironmentalTemperatureChange(Player player, Location location, double multiplier) {
        double tempChange = 0.0;
        tempChange += location.getBlock().getTemperature() * 16.0;
        tempChange += EnvironmentalFactorAPI.getDayNightModifier(location.getWorld());
        tempChange += EnvironmentalFactorAPI.getLightLevelModifier(location);
        tempChange += EnvironmentalFactorAPI.getWaterIceModifier(player, location);
        return (tempChange += EnvironmentalFactorAPI.getNearbyHeatSources(location, 6)) * multiplier;
    }
}

