/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.RegionAccessor;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.api.scheduler.SchedulerAPI;
import org.shotrush.atom.core.blocks.BlockType;
import org.shotrush.atom.core.blocks.CustomBlockManager;
import org.shotrush.atom.core.blocks.util.BlockRotationUtil;
import org.shotrush.atom.core.util.ItemUtil;

public abstract class CustomBlock
implements BlockType {
    protected final Location spawnLocation;
    protected final Location blockLocation;
    protected final BlockFace blockFace;
    protected UUID interactionUUID;
    protected UUID displayUUID;

    public CustomBlock(Location spawnLocation, Location blockLocation, BlockFace blockFace) {
        this.spawnLocation = spawnLocation.clone();
        this.blockLocation = blockLocation.clone();
        this.blockFace = blockFace;
    }

    public CustomBlock(Location spawnLocation, BlockFace blockFace) {
        this.spawnLocation = spawnLocation.clone();
        this.blockLocation = new Location(spawnLocation.getWorld(), (double)spawnLocation.getBlockX(), (double)spawnLocation.getBlockY(), (double)spawnLocation.getBlockZ());
        this.blockFace = blockFace;
    }

    public void spawn(Atom plugin) {
        if (this.spawnLocation.getWorld() == null) {
            plugin.getLogger().warning("Cannot spawn block at " + String.valueOf(this.spawnLocation) + " - world is null");
            return;
        }
        SchedulerAPI.runTask(this.spawnLocation, () -> this.spawn(plugin, (RegionAccessor)this.spawnLocation.getWorld()));
    }

    public abstract void spawn(Atom var1, RegionAccessor var2);

    public abstract void update(float var1);

    public void remove() {
        this.removeEntities();
        this.blockLocation.getBlock().setType(Material.AIR);
    }

    protected void removeEntities() {
        if (this.spawnLocation.getWorld() == null) {
            return;
        }
        SchedulerAPI.runTask(this.spawnLocation, () -> {
            Entity interaction;
            Entity display;
            if (this.displayUUID != null && (display = Bukkit.getEntity((UUID)this.displayUUID)) != null) {
                display.remove();
            }
            if (this.interactionUUID != null && (interaction = Bukkit.getEntity((UUID)this.interactionUUID)) != null) {
                interaction.remove();
            }
            for (Entity entity : this.spawnLocation.getWorld().getNearbyEntities(this.spawnLocation, 1.5, 1.5, 1.5)) {
                double distance;
                if (!(entity instanceof ItemDisplay) && !(entity instanceof Interaction) || !((distance = entity.getLocation().distance(this.spawnLocation)) < 0.5)) continue;
                entity.remove();
            }
        });
    }

    protected void cleanupExistingEntities() {
        if (this.spawnLocation.getWorld() == null) {
            return;
        }
        for (Entity entity : this.spawnLocation.getWorld().getNearbyEntities(this.spawnLocation, 0.5, 0.5, 0.5)) {
            if (!(entity instanceof ItemDisplay) && !(entity instanceof Interaction) || !(entity.getLocation().distance(this.spawnLocation) < 0.1)) continue;
            entity.remove();
        }
    }

    public boolean isValid() {
        if (this.spawnLocation.getWorld() == null) {
            return false;
        }
        if (this.interactionUUID != null && this.displayUUID != null) {
            Entity interaction = Bukkit.getEntity((UUID)this.interactionUUID);
            Entity display = Bukkit.getEntity((UUID)this.displayUUID);
            if (interaction != null && display != null && !interaction.isDead() && !display.isDead()) {
                return true;
            }
        }
        for (Entity entity : this.spawnLocation.getWorld().getNearbyEntities(this.spawnLocation, 0.5, 0.5, 0.5)) {
            double distance;
            if (!(entity instanceof Interaction) && !(entity instanceof ItemDisplay) || !((distance = entity.getLocation().distance(this.spawnLocation)) < 0.1)) continue;
            return true;
        }
        return false;
    }

    public boolean onWrenchInteract(Player player, boolean sneaking) {
        return false;
    }

    public boolean onInteract(Player player, boolean sneaking) {
        return false;
    }

    public void onPlaced() {
    }

    public void onRemoved() {
    }

    protected String serializeAdditionalData() {
        return "";
    }

    protected String deserializeAdditionalData(String[] parts, int startIndex) {
        return null;
    }

    @Override
    public abstract String getIdentifier();

    @Override
    public abstract String getDisplayName();

    @Override
    public abstract Material getItemMaterial();

    @Override
    public abstract String[] getLore();

    @Override
    public CustomBlock createBlock(Location spawnLocation, Location blockLocation, BlockFace blockFace) {
        try {
            return (CustomBlock)this.getClass().getConstructor(Location.class, Location.class, BlockFace.class).newInstance(spawnLocation, blockLocation, blockFace);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create block instance", e);
        }
    }

    @Override
    public abstract CustomBlock deserialize(String var1);

    protected Object[] parseDeserializeData(String data) {
        try {
            String[] parts = data.split(";");
            World world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                Atom.getInstance().getLogger().warning("World '" + parts[0] + "' not loaded, skipping " + this.getIdentifier() + " deserialization");
                return null;
            }
            Location location = new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
            BlockFace face = BlockFace.valueOf((String)parts[4]);
            return new Object[]{world, location, face};
        }
        catch (Exception e) {
            Atom.getInstance().getLogger().warning("Failed to deserialize " + this.getIdentifier() + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean requiresUpdate() {
        return false;
    }

    @Override
    public ItemStack getDropItem() {
        Atom plugin = Atom.getInstance();
        CustomBlockManager manager = plugin.getBlockManager();
        ItemStack item = manager.createBlockItem(this.getIdentifier());
        if (item == null) {
            plugin.getLogger().warning("Failed to create drop item for " + this.getIdentifier());
        }
        return item;
    }

    public String getBlockType() {
        return this.getIdentifier();
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.spawnLocation.getWorld().getName()).append(";");
        sb.append(this.spawnLocation.getX()).append(";");
        sb.append(this.spawnLocation.getY()).append(";");
        sb.append(this.spawnLocation.getZ()).append(";");
        sb.append(this.blockFace.name());
        String additionalData = this.serializeAdditionalData();
        if (!additionalData.isEmpty()) {
            sb.append(";").append(additionalData);
        }
        return sb.toString();
    }

    protected ItemStack createItemWithCustomModel(Material material, String modelName) {
        return ItemUtil.createItemWithCustomModel(material, modelName);
    }

    protected void spawnDisplay(ItemDisplay display, Atom plugin, ItemStack itemStack, Vector3f translation, AxisAngle4f initialRotation, Vector3f scale, boolean placeBarrier, float interactionWidth, float interactionHeight) {
        plugin.getLogger().info("[CustomBlock] spawnDisplay called for: " + this.getIdentifier());
        plugin.getLogger().info("[CustomBlock] ItemStack: " + String.valueOf(itemStack.getType()) + ", Display UUID: " + String.valueOf(display.getUniqueId()));
        if (placeBarrier) {
            this.blockLocation.getBlock().setType(Material.BLACK_STAINED_GLASS);
            plugin.getLogger().info("[CustomBlock] Placed black stained glass at: " + String.valueOf(this.blockLocation));
        }
        display.setItemStack(itemStack);
        display.setInterpolationDuration(0);
        display.setInterpolationDelay(0);
        display.setTransformation(new Transformation(translation, initialRotation, scale, new AxisAngle4f()));
        display.setGravity(false);
        plugin.getLogger().info("[CustomBlock] Display configured, spawning interaction...");
        Interaction interaction = (Interaction)this.spawnLocation.getWorld().spawnEntity(this.spawnLocation, EntityType.INTERACTION);
        interaction.setInteractionWidth(interactionWidth);
        interaction.setInteractionHeight(interactionHeight);
        interaction.setResponsive(true);
        interaction.setInvulnerable(true);
        interaction.setGravity(false);
        this.interactionUUID = interaction.getUniqueId();
        this.displayUUID = display.getUniqueId();
    }

    protected void updateDisplayRotation(float globalAngle, int rotationDirection, Vector3f translation, Vector3f scale) {
        if (this.displayUUID == null) {
            return;
        }
        Entity entity = Bukkit.getEntity((UUID)this.displayUUID);
        if (!(entity instanceof ItemDisplay)) {
            return;
        }
        ItemDisplay display = (ItemDisplay)entity;
        if (display.isDead() || !display.isValid()) {
            return;
        }
        display.getScheduler().run((Plugin)Atom.getInstance(), task -> {
            AxisAngle4f baseRotation = BlockRotationUtil.getInitialRotationFromFace(this.blockFace);
            AxisAngle4f spinRotation = new AxisAngle4f(globalAngle * (float)rotationDirection, 0.0f, 1.0f, 0.0f);
            AxisAngle4f combinedRotation = BlockRotationUtil.combineRotations(baseRotation, spinRotation);
            Transformation transformation = new Transformation(translation, combinedRotation, scale, new AxisAngle4f());
            display.setTransformation(transformation);
        }, null);
    }

    @Generated
    public Location getSpawnLocation() {
        return this.spawnLocation;
    }

    @Generated
    public Location getBlockLocation() {
        return this.blockLocation;
    }

    @Generated
    public BlockFace getBlockFace() {
        return this.blockFace;
    }

    @Generated
    public void setInteractionUUID(UUID interactionUUID) {
        this.interactionUUID = interactionUUID;
    }

    @Generated
    public UUID getInteractionUUID() {
        return this.interactionUUID;
    }

    @Generated
    public void setDisplayUUID(UUID displayUUID) {
        this.displayUUID = displayUUID;
    }

    @Generated
    public UUID getDisplayUUID() {
        return this.displayUUID;
    }
}

