/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.blocks.BlockType;
import org.shotrush.atom.core.blocks.CustomBlock;
import org.shotrush.atom.core.blocks.CustomBlockRegistry;

public class CustomBlockDataManager {
    private final Atom plugin;
    private final CustomBlockRegistry registry;
    private final File dataFile;
    private FileConfiguration dataConfig;

    public CustomBlockDataManager(Atom plugin, CustomBlockRegistry registry) {
        this.plugin = plugin;
        this.registry = registry;
        this.dataFile = new File(plugin.getDataFolder(), "blocks.yml");
        this.loadConfig();
    }

    private void loadConfig() {
        if (!this.dataFile.exists()) {
            this.plugin.getDataFolder().mkdirs();
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create blocks.yml!");
                e.printStackTrace();
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void saveBlocks(List<CustomBlock> blocks) {
        this.dataConfig.set("blocks", null);
        HashMap<String, List> blocksByType = new HashMap<String, List>();
        for (CustomBlock customBlock : blocks) {
            if (!customBlock.isValid()) continue;
            String type = customBlock.getBlockType();
            String data = customBlock.serialize();
            blocksByType.computeIfAbsent(type, k -> new ArrayList()).add(data);
        }
        for (Map.Entry entry : blocksByType.entrySet()) {
            this.dataConfig.set("blocks." + (String)entry.getKey(), entry.getValue());
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save blocks.yml!");
            e.printStackTrace();
        }
    }

    public List<CustomBlock> loadBlocks() {
        ArrayList<CustomBlock> blocks = new ArrayList<CustomBlock>();
        if (!this.dataConfig.contains("blocks")) {
            return blocks;
        }
        for (String typeId : this.dataConfig.getConfigurationSection("blocks").getKeys(false)) {
            BlockType blockType = this.registry.getBlockType(typeId);
            if (blockType == null) {
                this.plugin.getLogger().warning("Unknown block type: " + typeId);
                continue;
            }
            List blockData = this.dataConfig.getStringList("blocks." + typeId);
            for (String data : blockData) {
                try {
                    CustomBlock block = blockType.deserialize(data);
                    if (block == null) continue;
                    blocks.add(block);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Could not load block: " + data);
                    e.printStackTrace();
                }
            }
        }
        return blocks;
    }
}

