/*
 * Decompiled with CFR 0.152.
 */
package org.shotrush.atom.core.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.shotrush.atom.Atom;
import org.shotrush.atom.core.api.annotation.RegisterSystem;
import org.shotrush.atom.core.blocks.annotation.CustomBlockDrops;

@RegisterSystem(id="custom_block_drop_handler", priority=8, toggleable=false, description="Handles custom block drops from @CustomBlockDrops annotation")
public class CustomBlockDropHandler
implements Listener {
    private static final Map<Material, List<DropConfigWithAge>> customDrops = new HashMap<Material, List<DropConfigWithAge>>();
    private static final Random random = new Random();

    public CustomBlockDropHandler(Plugin plugin) {
        this.scanForCustomDrops();
    }

    private void scanForCustomDrops() {
        try {
            Reflections reflections = new Reflections("org.shotrush.atom", new Scanner[0]);
            Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(CustomBlockDrops.class);
            for (Class<?> clazz : annotatedClasses) {
                CustomBlockDrops annotation = clazz.getAnnotation(CustomBlockDrops.class);
                if (annotation == null) continue;
                this.registerDrops(annotation);
            }
            Atom.getInstance().getLogger().info("Loaded custom drops for " + customDrops.size() + " block types");
        }
        catch (Exception e) {
            Atom.getInstance().getLogger().warning("Failed to scan for custom block drops: " + e.getMessage());
        }
    }

    private void registerDrops(CustomBlockDrops annotation) {
        ArrayList<Material> targetBlocks = new ArrayList<Material>();
        if (!annotation.blockPattern().isEmpty()) {
            String pattern = annotation.blockPattern().toUpperCase();
            for (Material material : Material.values()) {
                String name;
                if (!material.isBlock() || !(name = material.name()).contains(pattern)) continue;
                targetBlocks.add(material);
            }
            Atom.getInstance().getLogger().info("Pattern '" + pattern + "' matched " + targetBlocks.size() + " blocks");
        } else {
            targetBlocks.addAll(Arrays.asList(annotation.blocks()));
        }
        HashSet<String> allowedAges = new HashSet<String>(Arrays.asList(annotation.ages()));
        for (Material material : targetBlocks) {
            List drops = customDrops.computeIfAbsent(material, k -> new ArrayList());
            for (CustomBlockDrops.Drop drop2 : annotation.drops()) {
                drops.add(new DropConfigWithAge(drop2.material(), drop2.customItemId(), drop2.chance(), drop2.min(), drop2.max(), allowedAges));
            }
            String string = allowedAges.isEmpty() ? "all ages" : "ages: " + String.join((CharSequence)", ", allowedAges);
            Atom.getInstance().getLogger().info("Registered " + annotation.drops().length + " custom drops for " + material.name() + " (" + string + ")");
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Block block = event.getBlock();
        Material blockType = block.getType();
        if (!customDrops.containsKey(blockType)) {
            return;
        }
        Player player = event.getPlayer();
        List<DropConfigWithAge> drops = customDrops.get(blockType);
        String currentAge = Atom.getInstance().getAgeManager().getCurrentAge().getId();
        ArrayList<DropConfigWithAge> applicableDrops = new ArrayList<DropConfigWithAge>();
        for (DropConfigWithAge drop2 : drops) {
            if (!drop2.allowedAges.isEmpty() && !drop2.allowedAges.contains(currentAge)) continue;
            applicableDrops.add(drop2);
        }
        if (applicableDrops.isEmpty()) {
            return;
        }
        event.setDropItems(false);
        for (DropConfigWithAge drop2 : applicableDrops) {
            ItemStack itemToDrop;
            if (!(random.nextDouble() <= drop2.chance)) continue;
            int amount = drop2.min;
            if (drop2.max > drop2.min) {
                amount = drop2.min + random.nextInt(drop2.max - drop2.min + 1);
            }
            if (!drop2.customItemId.isEmpty()) {
                itemToDrop = Atom.getInstance().getItemRegistry().createItem(drop2.customItemId);
                if (itemToDrop == null) {
                    Atom.getInstance().getLogger().warning("Custom item not found: " + drop2.customItemId);
                    continue;
                }
            } else {
                itemToDrop = new ItemStack(drop2.material);
            }
            itemToDrop.setAmount(amount);
            block.getWorld().dropItemNaturally(block.getLocation(), itemToDrop);
        }
    }

    private static class DropConfigWithAge {
        final Material material;
        final String customItemId;
        final double chance;
        final int min;
        final int max;
        final Set<String> allowedAges;

        DropConfigWithAge(Material material, String customItemId, double chance, int min2, int max, Set<String> allowedAges) {
            this.material = material;
            this.customItemId = customItemId;
            this.chance = chance;
            this.min = min2;
            this.max = max;
            this.allowedAges = allowedAges;
        }
    }
}

